/*
 * Decompiled with CFR 0.152.
 */
package io.allune.bigquery.maven.config;

import io.allune.bigquery.maven.config.SchemaLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SchemaLocations {
    private static final Log LOG = LogFactory.getLog(SchemaLocations.class);
    private final List<SchemaLocation> schemaLocationList = new ArrayList<SchemaLocation>();

    public SchemaLocations(List<String> rawLocations) {
        ArrayList<SchemaLocation> normalizedSchemaLocations = new ArrayList<SchemaLocation>();
        for (String rawLocation : rawLocations) {
            normalizedSchemaLocations.add(new SchemaLocation(rawLocation));
        }
        Collections.sort(normalizedSchemaLocations);
        normalizedSchemaLocations.forEach(normalizedSchemaLocation -> {
            if (this.schemaLocationList.contains(normalizedSchemaLocation)) {
                LOG.warn((Object)("Schema location '" + normalizedSchemaLocation + "' already found, skipping"));
                return;
            }
            SchemaLocation parentSchemaLocation = this.getParentLocationIfExists((SchemaLocation)normalizedSchemaLocation, this.schemaLocationList);
            if (parentSchemaLocation != null) {
                LOG.warn((Object)("Schema location '" + normalizedSchemaLocation + "' is contained in '" + parentSchemaLocation + "'"));
                return;
            }
            this.schemaLocationList.add((SchemaLocation)normalizedSchemaLocation);
        });
    }

    public List<SchemaLocation> getSchemaLocations() {
        return this.schemaLocationList;
    }

    private SchemaLocation getParentLocationIfExists(SchemaLocation schemaLocation, List<SchemaLocation> finalSchemaLocations) {
        for (SchemaLocation finalSchemaLocation : finalSchemaLocations) {
            if (!finalSchemaLocation.isParentOf(schemaLocation)) continue;
            return finalSchemaLocation;
        }
        return null;
    }
}

