/*
 * Decompiled with CFR 0.152.
 */
package io.allune.bigquery.maven.service;

import com.google.api.gax.paging.Page;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.common.base.Preconditions;
import io.allune.bigquery.maven.ConfigurationException;
import io.allune.bigquery.maven.config.SchemaLocation;
import io.allune.bigquery.maven.config.SchemaLocations;
import io.allune.bigquery.maven.service.BigQueryService;
import io.allune.bigquery.maven.service.TableDefinitionLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.logging.Log;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class BigQueryServiceImpl
implements BigQueryService {
    private final BigQuery bigQuery;
    private final String projectId;
    private final String dataset;
    private final Log log;

    private BigQueryServiceImpl(BigQuery bigQuery, String projectId, String dataset, Log log) {
        this.bigQuery = bigQuery;
        this.projectId = projectId;
        this.dataset = dataset;
        this.log = log;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void createDataset(String dataLocation) {
        DatasetInfo.Builder builder = DatasetInfo.newBuilder((String)this.dataset);
        builder.setLocation(dataLocation);
        this.bigQuery.create(builder.build(), new BigQuery.DatasetOption[0]);
        this.log.info((CharSequence)("Dataset created: " + this.dataset));
    }

    @Override
    public void createNativeTables(List<String> schemaLocations) {
        List<Resource> resources = BigQueryServiceImpl.loadResources(schemaLocations);
        resources.forEach(resource -> {
            TableDefinition tableDefinition = TableDefinitionLoader.loadStandardTableDefinition(resource);
            TableInfo tableInfo = this.createTableInfo(resource.getFilename(), this.dataset, tableDefinition);
            this.bigQuery.create(tableInfo, new BigQuery.TableOption[0]);
            this.log.info((CharSequence)("Table " + tableInfo.getTableId().getTable() + " created"));
        });
    }

    @Override
    public void createExternalTables(String sourceUri, String formatOptions, List<String> schemaLocations) {
        List<Resource> resources = BigQueryServiceImpl.loadResources(schemaLocations);
        resources.forEach(resource -> {
            TableDefinition tableDefinition = TableDefinitionLoader.loadExternalTableDefinition(sourceUri, formatOptions, resource);
            TableInfo tableInfo = this.createTableInfo(resource.getFilename(), this.dataset, tableDefinition);
            this.bigQuery.create(tableInfo, new BigQuery.TableOption[0]);
            this.log.info((CharSequence)("Table " + tableInfo.getTableId().getTable() + " created"));
        });
    }

    @Override
    public void createViews(List<String> schemaLocations) {
        List<Resource> resources = BigQueryServiceImpl.loadResources(schemaLocations);
        resources.forEach(resource -> {
            TableDefinition viewDefinition = TableDefinitionLoader.loadViewDefinition(resource, this.projectId, this.dataset);
            TableInfo tableInfo = this.createTableInfo(resource.getFilename(), this.dataset, viewDefinition);
            this.bigQuery.create(tableInfo, new BigQuery.TableOption[0]);
            this.log.info((CharSequence)("View " + tableInfo.getTableId().getTable() + " created"));
        });
    }

    @Override
    public void deleteTables() {
        Dataset ds = this.bigQuery.getDataset(this.dataset, new BigQuery.DatasetOption[0]);
        if (ds != null) {
            Page tablePage;
            this.log.info((CharSequence)("Deleting tables from " + this.dataset));
            do {
                tablePage = ds.list(new BigQuery.TableListOption[0]);
                tablePage.getValues().forEach(table -> {
                    this.log.info((CharSequence)("Deleting table " + table.getTableId().getTable()));
                    table.delete();
                });
            } while (tablePage.hasNextPage());
        }
    }

    @Override
    public void deleteDataset(boolean forceDelete) {
        ArrayList<BigQuery.DatasetDeleteOption> deleteOptions = new ArrayList<BigQuery.DatasetDeleteOption>();
        if (forceDelete) {
            deleteOptions.add(BigQuery.DatasetDeleteOption.deleteContents());
        }
        this.log.info((CharSequence)("Deleting dataset " + this.dataset + (forceDelete ? " (forced)" : "")));
        this.bigQuery.delete(this.dataset, deleteOptions.toArray(new BigQuery.DatasetDeleteOption[0]));
    }

    private static List<Resource> loadResources(List<String> locations) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
        SchemaLocations loc = new SchemaLocations(locations);
        ArrayList<Resource> loadedResources = new ArrayList<Resource>();
        loc.getSchemaLocations().forEach(arg_0 -> BigQueryServiceImpl.lambda$loadResources$4((ResourcePatternResolver)resolver, loadedResources, arg_0));
        return loadedResources;
    }

    private TableInfo createTableInfo(String filename, String dataset, TableDefinition tableDefinition) {
        String tableName = FilenameUtils.removeExtension((String)filename);
        TableId tableId = TableId.of((String)dataset, (String)tableName);
        return TableInfo.newBuilder((TableId)tableId, (TableDefinition)tableDefinition).build();
    }

    private static /* synthetic */ void lambda$loadResources$4(ResourcePatternResolver resolver, List loadedResources, SchemaLocation location) {
        try {
            Resource resource = resolver.getResource(location.getDescriptor());
            if (resource != null && resource.isReadable()) {
                loadedResources.add(resource);
            } else {
                Resource[] resources = resolver.getResources(location.getDescriptor() + "/*");
                loadedResources.addAll(Arrays.asList(resources));
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public static class Builder {
        private BigQuery bigQuery;
        private String projectId;
        private String credentialsFile;
        private String dataset;
        private Log log;

        private Builder() {
        }

        public Builder bigQuery(BigQuery bigQuery) {
            this.bigQuery = bigQuery;
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder credentialsFile(String credentialsFile) {
            this.credentialsFile = credentialsFile;
            return this;
        }

        public Builder dataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder logger(Log log) {
            this.log = log;
            return this;
        }

        public BigQueryServiceImpl build() {
            Preconditions.checkNotNull((Object)this.bigQuery, (Object)"bigQuery is null");
            Preconditions.checkNotNull((Object)this.projectId, (Object)"projectId is null");
            Preconditions.checkNotNull((Object)this.dataset, (Object)"dataset is null");
            Preconditions.checkNotNull((Object)this.credentialsFile, (Object)"credentialsFile is null");
            Preconditions.checkNotNull((Object)this.log, (Object)"log is null");
            return new BigQueryServiceImpl(this.bigQuery, this.projectId, this.dataset, this.log);
        }
    }
}

