/*
 * Decompiled with CFR 0.152.
 */
package io.allune.bigquery.maven.service;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class ObjectMappers {
    private static ObjectMapper objectMapper;

    private ObjectMappers() {
    }

    static ObjectMapper mapper() {
        if (objectMapper == null) {
            objectMapper = ObjectMappers.createObjectMapper();
        }
        return objectMapper;
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(TableFieldSchema.class, (JsonDeserializer)new TableFieldSchemaDeserializer());
        objectMapper.registerModule((Module)module);
        objectMapper.registerModule((Module)new Jdk8Module());
        return objectMapper;
    }

    private static class TableFieldSchemaDeserializer
    extends JsonDeserializer<TableFieldSchema> {
        private TableFieldSchemaDeserializer() {
        }

        public TableFieldSchema deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            String name = node.get("name").asText();
            String type = node.get("type").asText();
            String mode = node.get("mode").asText();
            ArrayList fields = Lists.newArrayList();
            JsonNode nestedTableFields = node.get("fields");
            if (nestedTableFields != null && nestedTableFields.isArray()) {
                for (JsonNode nestedTableField : nestedTableFields) {
                    TableFieldSchema embedNode = (TableFieldSchema)ObjectMappers.mapper().readValue(nestedTableField.toString(), TableFieldSchema.class);
                    fields.add(embedNode);
                }
            }
            TableFieldSchema tableFieldSchema = new TableFieldSchema();
            tableFieldSchema.setName(name);
            tableFieldSchema.setType(type);
            tableFieldSchema.setMode(mode);
            if (!fields.isEmpty()) {
                tableFieldSchema.setFields((List)fields);
            }
            return tableFieldSchema;
        }
    }
}

