/*
 * Decompiled with CFR 0.152.
 */
package io.allune.bigquery.maven.service;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.ViewDefinition;
import com.google.common.collect.Lists;
import io.allune.bigquery.maven.ConfigurationException;
import io.allune.bigquery.maven.service.ObjectMappers;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;

class TableDefinitionLoader {
    private TableDefinitionLoader() {
    }

    static TableDefinition loadStandardTableDefinition(Resource resource) {
        return StandardTableDefinition.of((Schema)TableDefinitionLoader.loadTableSchema(resource));
    }

    static TableDefinition loadExternalTableDefinition(String sourceUri, String formatOptions, Resource resource) {
        return ExternalTableDefinition.of((String)sourceUri, (Schema)TableDefinitionLoader.loadTableSchema(resource), (FormatOptions)FormatOptions.of((String)formatOptions));
    }

    static TableDefinition loadViewDefinition(Resource resource, String projectId, String dataset) {
        try {
            String view = IOUtils.toString((InputStream)resource.getInputStream(), (String)"UTF-8").replace("$projectId", projectId).replace("$datasetName", dataset);
            return ViewDefinition.of((String)view);
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    private static Schema loadTableSchema(Resource resource) {
        List<TableFieldSchema> fieldSchemas = TableDefinitionLoader.getTableFieldSchemas(resource);
        List<TableFieldSchema> tableFieldSchemas = TableDefinitionLoader.createTableSchema(fieldSchemas);
        TableSchema sourceSchema = new TableSchema();
        sourceSchema.setFields(tableFieldSchemas);
        return TableDefinitionLoader.fromPb(sourceSchema);
    }

    private static List<TableFieldSchema> getTableFieldSchemas(Resource resource) {
        List fieldSchemas;
        try {
            CollectionType type = ObjectMappers.mapper().getTypeFactory().constructCollectionType(List.class, TableFieldSchema.class);
            fieldSchemas = (List)ObjectMappers.mapper().readValue(resource.getInputStream(), (JavaType)type);
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        return fieldSchemas;
    }

    private static List<TableFieldSchema> createTableSchema(List<TableFieldSchema> tableFieldSchemas) {
        ArrayList allFields = Lists.newArrayList();
        List simpleFields = tableFieldSchemas.stream().filter(tfs -> !tfs.getType().equals("RECORD")).collect(Collectors.toList());
        allFields.addAll(simpleFields);
        List<TableFieldSchema> recordFields = tableFieldSchemas.stream().filter(tfs -> tfs.getType().equals("RECORD")).collect(Collectors.toList());
        recordFields.forEach(record -> {
            record.setFields(TableDefinitionLoader.createTableSchema(record.getFields()));
            allFields.add(record);
        });
        return allFields;
    }

    private static Schema fromPb(TableSchema tableSchemaPb) {
        try {
            Method fromPb = Schema.class.getDeclaredMethod("fromPb", TableSchema.class);
            fromPb.setAccessible(true);
            return (Schema)fromPb.invoke(null, tableSchemaPb);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }
}

