/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.examples.client;

import io.allune.quickfixj.spring.boot.starter.EnableQuickFixJClient;
import io.allune.quickfixj.spring.boot.starter.examples.client.ClientApplicationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.Initiator;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.SessionSettings;
import quickfix.ThreadedSocketInitiator;

@EnableQuickFixJClient
@SpringBootApplication
public class AppClient
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(AppClient.class);

    public static void main(String[] args) {
        SpringApplication.run(AppClient.class, (String[])args);
    }

    public void run(String ... args) throws Exception {
        log.info("Joining thread, you can press Ctrl+C to shutdown application");
        Thread.currentThread().join();
    }

    @Bean
    public Application clientApplication() {
        return new ClientApplicationAdapter();
    }

    @Bean
    public Initiator clientInitiator(Application clientApplication, MessageStoreFactory clientMessageStoreFactory, SessionSettings clientSessionSettings, LogFactory clientLogFactory, MessageFactory clientMessageFactory) throws ConfigError {
        return new ThreadedSocketInitiator(clientApplication, clientMessageStoreFactory, clientSessionSettings, clientLogFactory, clientMessageFactory);
    }
}

