/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.examples.sender;

import io.allune.quickfixj.spring.boot.starter.template.QuickFixJTemplate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import quickfix.Acceptor;
import quickfix.Initiator;
import quickfix.Message;
import quickfix.SessionID;
import quickfix.StringField;
import quickfix.field.ClOrdID;
import quickfix.field.OrigClOrdID;
import quickfix.field.QuoteID;
import quickfix.field.Side;
import quickfix.field.Symbol;
import quickfix.fix41.OrderCancelRequest;
import quickfix.fix50.Quote;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class SenderController {
    private static final Map<String, Map<String, Message>> messageMap = SenderController.createMessageMap();
    private final QuickFixJTemplate serverQuickFixJTemplate;
    private final Acceptor serverAcceptor;
    private final QuickFixJTemplate clientQuickFixJTemplate;
    private final Initiator clientInitiator;

    public SenderController(QuickFixJTemplate serverQuickFixJTemplate, Acceptor serverAcceptor, QuickFixJTemplate clientQuickFixJTemplate, Initiator clientInitiator) {
        this.serverQuickFixJTemplate = serverQuickFixJTemplate;
        this.serverAcceptor = serverAcceptor;
        this.clientQuickFixJTemplate = clientQuickFixJTemplate;
        this.clientInitiator = clientInitiator;
    }

    private static HashMap<String, Map<String, Message>> createMessageMap() {
        HashMap<String, Map<String, Message>> stringMapHashMap = new HashMap<String, Map<String, Message>>();
        stringMapHashMap.put("FIX.4.1", SenderController.initialiseFix41MessageMap());
        stringMapHashMap.put("FIXT.1.1", SenderController.initialiseFix50MessageMap());
        return stringMapHashMap;
    }

    private static Map<String, Message> initialiseFix41MessageMap() {
        HashMap<String, Message> messageMap = new HashMap<String, Message>();
        messageMap.put("OrderCancelRequest", (Message)new OrderCancelRequest(new OrigClOrdID("123"), new ClOrdID("321"), new Symbol("LNUX"), new Side('1')));
        return messageMap;
    }

    private static Map<String, Message> initialiseFix50MessageMap() {
        HashMap<String, Message> messageMap = new HashMap<String, Message>();
        messageMap.put("Quote", (Message)new Quote(new QuoteID("123")));
        return messageMap;
    }

    @RequestMapping(value={"/send-client-message"})
    @ResponseStatus(value=HttpStatus.OK)
    public void sendMessageToClient(@RequestParam String fixVersion, @RequestParam String messageType) {
        Map stringMessageMap = (Map)messageMap.get(fixVersion);
        Message message = (Message)stringMessageMap.get(messageType);
        message.setField(new StringField(58, "Text: " + UUID.randomUUID().toString()));
        SessionID sessionID = this.serverAcceptor.getSessions().stream().filter(id -> id.getBeginString().equals(fixVersion)).findFirst().orElseThrow(RuntimeException::new);
        this.serverQuickFixJTemplate.send(message, sessionID);
    }

    @RequestMapping(value={"/send-server-message"})
    @ResponseStatus(value=HttpStatus.OK)
    public void sendMessageToServer(@RequestParam String fixVersion, @RequestParam String messageType) {
        Map stringMessageMap = (Map)messageMap.get(fixVersion);
        Message message = (Message)stringMessageMap.get(messageType);
        message.setField(new StringField(58, "Text: " + UUID.randomUUID().toString()));
        SessionID sessionID = this.clientInitiator.getSessions().stream().filter(id -> id.getBeginString().equals(fixVersion)).findFirst().orElseThrow(RuntimeException::new);
        this.clientQuickFixJTemplate.send(message, sessionID);
    }
}

