/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.examples.server;

import io.allune.quickfixj.spring.boot.starter.EnableQuickFixJServer;
import io.allune.quickfixj.spring.boot.starter.examples.server.ServerApplicationAdapter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import quickfix.Acceptor;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.FileLogFactory;
import quickfix.FileStoreFactory;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.ThreadedSocketAcceptor;
import quickfix.mina.acceptor.AcceptorSessionProvider;
import quickfix.mina.acceptor.DynamicAcceptorSessionProvider;

@EnableQuickFixJServer
@SpringBootApplication
public class AppServer {
    public static void main(String[] args) {
        SpringApplication.run(AppServer.class, (String[])args);
    }

    @Bean
    public Application serverApplication() {
        return new ServerApplicationAdapter();
    }

    @Bean
    public Acceptor serverAcceptor(Application serverApplication, MessageStoreFactory serverMessageStoreFactory, SessionSettings serverSessionSettings, LogFactory serverLogFactory, MessageFactory serverMessageFactory) throws ConfigError {
        ThreadedSocketAcceptor threadedSocketAcceptor = new ThreadedSocketAcceptor(serverApplication, serverMessageStoreFactory, serverSessionSettings, serverLogFactory, serverMessageFactory);
        SessionID anySession = new SessionID("FIX.4.0", "*", "*");
        serverSessionSettings.setBool(anySession, "AcceptorTemplate", true);
        serverSessionSettings.setString(anySession, "BeginString", "FIX.4.4");
        threadedSocketAcceptor.setSessionProvider((SocketAddress)new InetSocketAddress("0.0.0.0", 9876), (AcceptorSessionProvider)new DynamicAcceptorSessionProvider(serverSessionSettings, anySession, serverApplication, serverMessageStoreFactory, serverLogFactory, serverMessageFactory));
        return threadedSocketAcceptor;
    }

    @Bean
    public MessageStoreFactory serverMessageStoreFactory(SessionSettings serverSessionSettings) {
        return new FileStoreFactory(serverSessionSettings);
    }

    @Bean
    public LogFactory serverLogFactory(SessionSettings serverSessionSettings) {
        return new FileLogFactory(serverSessionSettings);
    }
}

