/*
 * Decompiled with CFR 0.152.
 */
package io.altoo.akka.serialization.kryo;

import io.altoo.akka.serialization.kryo.Transformer;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0004\b\u00013!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011!9\u0004A!A!\u0002\u0013A\u0004\"B\u001e\u0001\t\u0003a\u0004bB!\u0001\u0005\u0004%iA\u0011\u0005\u0007\u000b\u0002\u0001\u000bQB\"\t\r\u0019\u0003\u0001\u0015!\u0003H\u0011!\t\u0006\u0001#b\u0001\n\u0013\u0011\u0006\"B.\u0001\t\u0003b\u0006\"B.\u0001\t\u0003z\u0006\"B7\u0001\t\u0003r\u0007\"B7\u0001\t\u0003\n(!E&ss>\u001c%/\u001f9u_\u001e\u0014\u0018\r\u001d5fe*\u0011q\u0002E\u0001\u0005WJLxN\u0003\u0002\u0012%\u0005i1/\u001a:jC2L'0\u0019;j_:T!a\u0005\u000b\u0002\t\u0005\\7.\u0019\u0006\u0003+Y\tQ!\u00197u_>T\u0011aF\u0001\u0003S>\u001c\u0001aE\u0002\u00015\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0007CA\u0011#\u001b\u0005q\u0011BA\u0012\u000f\u0005-!&/\u00198tM>\u0014X.\u001a:\u0002\u0007-,\u0017\u0010E\u0002\u001cM!J!a\n\u000f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005mI\u0013B\u0001\u0016\u001d\u0005\u0011\u0011\u0015\u0010^3\u0002\t5|G-\u001a\t\u0003[Qr!A\f\u001a\u0011\u0005=bR\"\u0001\u0019\u000b\u0005EB\u0012A\u0002\u001fs_>$h(\u0003\u000249\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019D$\u0001\u0005jm2+gn\u001a;i!\tY\u0012(\u0003\u0002;9\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\u0011idh\u0010!\u0011\u0005\u0005\u0002\u0001\"\u0002\u0013\u0005\u0001\u0004)\u0003\"B\u0016\u0005\u0001\u0004a\u0003\"B\u001c\u0005\u0001\u0004A\u0014!D!vi\"$\u0016m\u001a'f]\u001e$\b.F\u0001D\u001f\u0005!UD\u0001\u0001\u0001\u00049\tU\u000f\u001e5UC\u001edUM\\4uQ\u0002\nqa[3z'B,7\r\u0005\u0002I\u001f6\t\u0011J\u0003\u0002K\u0017\u0006!1\u000f]3d\u0015\taU*\u0001\u0004def\u0004Ho\u001c\u0006\u0002\u001d\u0006)!.\u0019<bq&\u0011\u0001+\u0013\u0002\u000e'\u0016\u001c'/\u001a;LKf\u001c\u0006/Z2\u0002\rI\fg\u000eZ8n+\u0005\u0019\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003!\u0019XmY;sSRL(\"\u0001-\u0002\t)\fg/Y\u0005\u00035V\u0013AbU3dkJ,'+\u00198e_6\f\u0001\u0002^8CS:\f'/\u001f\u000b\u0003KuCQAX\u0005A\u0002\u0015\n\u0011\u0002\u001d7bS:$X\r\u001f;\u0015\u0007\u0001\u001cW\r\u0005\u0002\u001cC&\u0011!\r\b\u0002\u0005+:LG\u000fC\u0003e\u0015\u0001\u0007Q%A\u0005j]B,HOQ;gM\")aM\u0003a\u0001O\u0006Qq.\u001e;qkR\u0014UO\u001a4\u0011\u0005!\\W\"A5\u000b\u0005)<\u0016a\u00018j_&\u0011A.\u001b\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018A\u00034s_6\u0014\u0015N\\1ssR\u0011Qe\u001c\u0005\u0006a.\u0001\r!J\u0001\u0006S:\u0004X\u000f\u001e\u000b\u0003KIDQ\u0001\u001a\u0007A\u0002\u001d\u0004")
public class KryoCryptographer
implements Transformer {
    private SecureRandom random;
    private final String mode;
    private final int ivLength;
    private final SecretKeySpec keySpec;
    private volatile boolean bitmap$0;

    private final int AuthTagLength() {
        return 128;
    }

    private SecureRandom random$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.random = new SecureRandom();
                this.bitmap$0 = true;
            }
        }
        return this.random;
    }

    private SecureRandom random() {
        if (!this.bitmap$0) {
            return this.random$lzycompute();
        }
        return this.random;
    }

    @Override
    public byte[] toBinary(byte[] plaintext) {
        Cipher cipher = Cipher.getInstance(this.mode);
        byte[] iv = new byte[this.ivLength];
        this.random().nextBytes(iv);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)this.keySpec, parameterSpec);
        byte[] ciphertext = cipher.doFinal(plaintext);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + iv.length + ciphertext.length);
        byteBuffer.putInt(iv.length);
        byteBuffer.put(iv);
        byteBuffer.put(ciphertext);
        return byteBuffer.array();
    }

    @Override
    public void toBinary(byte[] inputBuff, ByteBuffer outputBuff) {
        Cipher cipher = Cipher.getInstance(this.mode);
        byte[] iv = new byte[this.ivLength];
        this.random().nextBytes(iv);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)this.keySpec, parameterSpec);
        outputBuff.putInt(iv.length);
        outputBuff.put(iv);
        cipher.doFinal(ByteBuffer.wrap(inputBuff), outputBuff);
    }

    @Override
    public byte[] fromBinary(byte[] input) {
        return this.fromBinary(ByteBuffer.wrap(input));
    }

    @Override
    public byte[] fromBinary(ByteBuffer inputBuff) {
        Cipher cipher = Cipher.getInstance(this.mode);
        int ivLength = inputBuff.getInt();
        if (ivLength < 12 || ivLength >= 16) {
            throw new IllegalStateException("invalid iv length");
        }
        byte[] iv = new byte[ivLength];
        inputBuff.get(iv);
        byte[] ciphertext = new byte[inputBuff.remaining()];
        inputBuff.get(ciphertext);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)this.keySpec, parameterSpec);
        return cipher.doFinal(ciphertext);
    }

    public KryoCryptographer(byte[] key, String mode, int ivLength) {
        this.mode = mode;
        this.ivLength = ivLength;
        Transformer.$init$(this);
        if (ivLength < 12 || ivLength >= 16) {
            throw new IllegalStateException("invalid iv length");
        }
        this.keySpec = new SecretKeySpec(key, "AES");
    }
}

