/*
 * Decompiled with CFR 0.152.
 */
package io.altoo.akka.serialization.kryo;

import io.altoo.akka.serialization.kryo.Transformer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-3Aa\u0002\u0005\u0001'!)a\u0004\u0001C\u0001?!A\u0011\u0005\u0001EC\u0002\u0013%!\u0005C\u0003.\u0001\u0011\u0005c\u0006C\u0003.\u0001\u0011\u0005s\u0007C\u0003G\u0001\u0011\u0005s\tC\u0003G\u0001\u0011\u0005\u0013JA\tM5RZ%/_8D_6\u0004(/Z:t_JT!!\u0003\u0006\u0002\t-\u0014\u0018p\u001c\u0006\u0003\u00171\tQb]3sS\u0006d\u0017N_1uS>t'BA\u0007\u000f\u0003\u0011\t7n[1\u000b\u0005=\u0001\u0012!B1mi>|'\"A\t\u0002\u0005%|7\u0001A\n\u0004\u0001QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001c95\t\u0001\"\u0003\u0002\u001e\u0011\tYAK]1og\u001a|'/\\3s\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\u001c\u0001\u0005QAN\u001f\u001bgC\u000e$xN]=\u0016\u0003\r\u0002\"\u0001J\u0016\u000e\u0003\u0015R!AJ\u0014\u0002\u00071THG\u0003\u0002)S\u00059!\u000e]8v]RT(\"\u0001\u0016\u0002\u00079,G/\u0003\u0002-K\tQAJ\u0017\u001bGC\u000e$xN]=\u0002\u0011Q|')\u001b8bef$\"aL\u001b\u0011\u0007U\u0001$'\u0003\u00022-\t)\u0011I\u001d:bsB\u0011QcM\u0005\u0003iY\u0011AAQ=uK\")ag\u0001a\u0001_\u0005I\u0011N\u001c9vi\n+hM\u001a\u000b\u0004qmb\u0004CA\u000b:\u0013\tQdC\u0001\u0003V]&$\b\"\u0002\u001c\u0005\u0001\u0004y\u0003\"B\u001f\u0005\u0001\u0004q\u0014AC8viB,HOQ;gMB\u0011q\bR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0004]&|'\"A\"\u0002\t)\fg/Y\u0005\u0003\u000b\u0002\u0013!BQ=uK\n+hMZ3s\u0003)1'o\\7CS:\f'/\u001f\u000b\u0003_!CQAN\u0003A\u0002=\"\"a\f&\t\u000bY2\u0001\u0019\u0001 ")
public class LZ4KryoCompressor
implements Transformer {
    private LZ4Factory lz4factory;
    private volatile boolean bitmap$0;

    private LZ4Factory lz4factory$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.lz4factory = LZ4Factory.fastestInstance();
                this.bitmap$0 = true;
            }
        }
        return this.lz4factory;
    }

    private LZ4Factory lz4factory() {
        if (!this.bitmap$0) {
            return this.lz4factory$lzycompute();
        }
        return this.lz4factory;
    }

    @Override
    public byte[] toBinary(byte[] inputBuff) {
        int inputSize = inputBuff.length;
        LZ4Compressor lz4 = this.lz4factory().fastCompressor();
        int maxOutputSize = lz4.maxCompressedLength(inputSize);
        byte[] outputBuff = new byte[maxOutputSize + 4];
        int outputSize = lz4.compress(inputBuff, 0, inputSize, outputBuff, 4, maxOutputSize);
        outputBuff[0] = (byte)(inputSize & 0xFF);
        outputBuff[1] = (byte)(inputSize >> 8 & 0xFF);
        outputBuff[2] = (byte)(inputSize >> 16 & 0xFF);
        outputBuff[3] = (byte)(inputSize >> 24 & 0xFF);
        return (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(outputBuff)).take(outputSize + 4);
    }

    @Override
    public void toBinary(byte[] inputBuff, ByteBuffer outputBuff) {
        int inputSize = inputBuff.length;
        LZ4Compressor lz4 = this.lz4factory().fastCompressor();
        outputBuff.order(ByteOrder.LITTLE_ENDIAN).putInt(inputSize);
        try {
            lz4.compress(ByteBuffer.wrap(inputBuff), outputBuff);
            return;
        }
        catch (LZ4Exception e) {
            throw new RuntimeException(new StringBuilder(67).append("Compression failed for input buffer size: ").append(inputBuff.length).append(" and output buffer size: ").append(outputBuff.capacity()).toString(), e);
        }
    }

    @Override
    public byte[] fromBinary(byte[] inputBuff) {
        return this.fromBinary(ByteBuffer.wrap(inputBuff));
    }

    @Override
    public byte[] fromBinary(ByteBuffer inputBuff) {
        int size = inputBuff.order(ByteOrder.LITTLE_ENDIAN).getInt();
        LZ4FastDecompressor lz4 = this.lz4factory().fastDecompressor();
        byte[] outputBuff = new byte[size];
        lz4.decompress(inputBuff, ByteBuffer.wrap(outputBuff));
        return outputBuff;
    }

    public LZ4KryoCompressor() {
        Transformer.$init$(this);
    }
}

