/*
 * Decompiled with CFR 0.152.
 */
package io.altoo.akka.serialization.kryo;

import io.altoo.akka.serialization.kryo.Transformer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y2AAB\u0004\u0001%!)Q\u0004\u0001C\u0001=!)\u0001\u0005\u0001C!C!)\u0001\u0005\u0001C!U!)\u0011\b\u0001C!u!)\u0011\b\u0001C!y\t\t\",\u001b9Lef|7i\\7qe\u0016\u001c8o\u001c:\u000b\u0005!I\u0011\u0001B6ss>T!AC\u0006\u0002\u001bM,'/[1mSj\fG/[8o\u0015\taQ\"\u0001\u0003bW.\f'B\u0001\b\u0010\u0003\u0015\tG\u000e^8p\u0015\u0005\u0001\u0012AA5p\u0007\u0001\u00192\u0001A\n\u001a!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fMB\u0011!dG\u0007\u0002\u000f%\u0011Ad\u0002\u0002\f)J\fgn\u001d4pe6,'/\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011!\u0004A\u0001\ti>\u0014\u0015N\\1ssR\u0011!\u0005\u000b\t\u0004)\r*\u0013B\u0001\u0013\u0016\u0005\u0015\t%O]1z!\t!b%\u0003\u0002(+\t!!)\u001f;f\u0011\u0015I#\u00011\u0001#\u0003%Ig\u000e];u\u0005V4g\rF\u0002,]=\u0002\"\u0001\u0006\u0017\n\u00055*\"\u0001B+oSRDQ!K\u0002A\u0002\tBQ\u0001M\u0002A\u0002E\n!b\\;uaV$()\u001e4g!\t\u0011t'D\u00014\u0015\t!T'A\u0002oS>T\u0011AN\u0001\u0005U\u00064\u0018-\u0003\u00029g\tQ!)\u001f;f\u0005V4g-\u001a:\u0002\u0015\u0019\u0014x.\u001c\"j]\u0006\u0014\u0018\u0010\u0006\u0002#w!)\u0011\u0006\u0002a\u0001EQ\u0011!%\u0010\u0005\u0006S\u0015\u0001\r!\r")
public class ZipKryoCompressor
implements Transformer {
    @Override
    public byte[] toBinary(byte[] inputBuff) {
        Deflater deflater = new Deflater(1);
        int inputSize = inputBuff.length;
        ArrayBuilder.ofByte outputBuff = new ArrayBuilder.ofByte();
        outputBuff.$plus$eq((byte)(inputSize & 0xFF));
        outputBuff.$plus$eq((byte)(inputSize >> 8 & 0xFF));
        outputBuff.$plus$eq((byte)(inputSize >> 16 & 0xFF));
        outputBuff.$plus$eq((byte)(inputSize >> 24 & 0xFF));
        deflater.setInput(inputBuff);
        deflater.finish();
        byte[] buff = new byte[4096];
        while (!deflater.finished()) {
            int n = deflater.deflate(buff);
            outputBuff.$plus$plus$eq((TraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(buff)).take(n))));
        }
        deflater.end();
        return outputBuff.result();
    }

    @Override
    public void toBinary(byte[] inputBuff, ByteBuffer outputBuff) {
        Deflater deflater = new Deflater(1);
        int inputSize = inputBuff.length;
        outputBuff.order(ByteOrder.LITTLE_ENDIAN).putInt(inputSize);
        deflater.setInput(inputBuff);
        deflater.finish();
        deflater.deflate(outputBuff);
        deflater.end();
    }

    @Override
    public byte[] fromBinary(byte[] inputBuff) {
        return this.fromBinary(ByteBuffer.wrap(inputBuff));
    }

    @Override
    public byte[] fromBinary(ByteBuffer inputBuff) {
        Inflater inflater = new Inflater();
        byte[] outputBuff = new byte[inputBuff.order(ByteOrder.LITTLE_ENDIAN).getInt()];
        inflater.setInput(inputBuff);
        inflater.inflate(ByteBuffer.wrap(outputBuff));
        inflater.end();
        return outputBuff;
    }

    public ZipKryoCompressor() {
        Transformer.$init$(this);
    }
}

