/*
 * Decompiled with CFR 0.152.
 */
package io.amplicode.rautils.patch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.util.LRUMap;
import io.amplicode.rautils.patch.JsonConversionException;
import io.amplicode.rautils.patch.PatchValidationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Validator;

public class ObjectPatcher {
    private final ObjectMapper objectMapper;
    private final Validator validator;
    private final LRUMap<Class<?>, BeanDescription> cachedDescriptions;

    public ObjectPatcher(ObjectMapper objectMapper, Validator validator) {
        this.objectMapper = objectMapper;
        this.validator = validator;
        this.cachedDescriptions = new LRUMap(64, 2000);
    }

    public <T> T patchAndValidate(T target, JsonNode patchJson) {
        T patchedTarget = this.patch(target, patchJson);
        this.validate(patchedTarget);
        return patchedTarget;
    }

    public <T> T patchAndValidate(T target, String patchJson) {
        T patchedTarget = this.patch(target, patchJson);
        this.validate(patchedTarget);
        return patchedTarget;
    }

    public <T> T patch(T target, JsonNode patchJson) {
        Object patchObject;
        BeanDescription beanDescription = this.getBeanDescription(target.getClass());
        List beanProperties = beanDescription.findProperties();
        if (this.canBePatchedInPlace(beanDescription)) {
            this.patchBeanInPlace(patchJson, target);
            return target;
        }
        try {
            patchObject = this.objectMapper.readerFor(target.getClass()).readValue(patchJson);
        }
        catch (IOException e) {
            throw new JsonConversionException("Failed to parse patch JSON", e);
        }
        Set<String> patchedPropertyNames = this.determinePatchedProperties(patchJson);
        Map<String, Object> allPropertyValues = this.extractPropertyValues(target, beanProperties);
        for (String patchedPropertyName : patchedPropertyNames) {
            BeanPropertyDefinition propertyDefinition = beanProperties.stream().filter(p -> p.getName().equals(patchedPropertyName) && p.hasGetter()).findAny().orElseThrow(() -> new IllegalStateException("Can't find getter for property " + patchedPropertyName));
            Object patchedValue = propertyDefinition.getGetter().getValue(patchObject);
            allPropertyValues.put(patchedPropertyName, patchedValue);
        }
        Object patchedObject = this.constructBean(allPropertyValues, beanDescription);
        return (T)patchedObject;
    }

    public <T> T patch(T target, String patchJson) {
        try {
            JsonNode patchJsonNode = this.objectMapper.readTree(patchJson);
            return this.patch(target, patchJsonNode);
        }
        catch (JsonProcessingException e) {
            throw new JsonConversionException("Failed to parse patch JSON", e);
        }
    }

    private <T> void patchBeanInPlace(JsonNode patchJson, T target) {
        try {
            this.objectMapper.readerForUpdating(target).readValue(patchJson);
        }
        catch (IOException e) {
            throw new JsonConversionException("Failed to parse patch JSON", e);
        }
    }

    private boolean canBePatchedInPlace(BeanDescription beanDescription) {
        if (beanDescription.isRecordType()) {
            return false;
        }
        return beanDescription.findProperties().stream().noneMatch(p -> (p.hasConstructorParameter() || p.hasField()) && !p.hasSetter());
    }

    private Object constructBean(Map<String, Object> propertyValues, BeanDescription beanDescription) {
        try {
            DefaultDeserializationContext defaultContext = (DefaultDeserializationContext)this.objectMapper.getDeserializationContext();
            DefaultDeserializationContext ctxt = defaultContext.createInstance(this.objectMapper.getDeserializationConfig(), null, null);
            BeanDeserializer deser = (BeanDeserializer)ctxt.findRootValueDeserializer(beanDescription.getType());
            ValueInstantiator valueInstantiator = deser.getValueInstantiator();
            SettableBeanProperty[] creatorProps = valueInstantiator.getFromObjectArguments(ctxt.getConfig());
            if (creatorProps.length == 0) {
                throw new IllegalArgumentException("Bean " + beanDescription.getBeanClass() + " doesn't have appropriate constructor");
            }
            Object[] args = new Object[creatorProps.length];
            for (int i = 0; i < args.length; ++i) {
                String propertyName = creatorProps[i].getName();
                args[i] = propertyValues.get(propertyName);
            }
            Object bean = valueInstantiator.createFromObjectWith((DeserializationContext)ctxt, args);
            this.fillNonConstructorProperties(propertyValues, beanDescription, creatorProps, bean);
            return bean;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error when constructing patched bean", e);
        }
    }

    private void fillNonConstructorProperties(Map<String, Object> propertyValues, BeanDescription beanDescription, SettableBeanProperty[] creatorProps, Object bean) {
        Set constructorPropertyNames = Arrays.stream(creatorProps).map(p -> p.getName()).collect(Collectors.toSet());
        List allBeanProperties = beanDescription.findProperties();
        for (Map.Entry<String, Object> property : propertyValues.entrySet()) {
            String propertyName = property.getKey();
            if (constructorPropertyNames.contains(propertyName)) continue;
            allBeanProperties.stream().filter(p -> p.getName().equals(propertyName) && (p.hasSetter() || p.hasField())).findAny().ifPresent(def -> def.getNonConstructorMutator().setValue(bean, property.getValue()));
        }
    }

    private BeanDescription getBeanDescription(Class<?> targetClass) {
        BeanDescription description = (BeanDescription)this.cachedDescriptions.get(targetClass);
        if (description != null) {
            return description;
        }
        DeserializationConfig config = this.objectMapper.getDeserializationConfig();
        ClassIntrospector introspector = config.getClassIntrospector();
        description = introspector.forDeserialization(config, this.objectMapper.constructType(targetClass), (ClassIntrospector.MixInResolver)config);
        this.cachedDescriptions.put(targetClass, (Object)description);
        return description;
    }

    private Set<String> determinePatchedProperties(JsonNode patchJson) {
        HashSet<String> propertyNames = new HashSet<String>();
        Iterator it = patchJson.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            propertyNames.add((String)entry.getKey());
        }
        return propertyNames;
    }

    private <T> Map<String, Object> extractPropertyValues(T bean, List<BeanPropertyDefinition> beanProperties) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        beanProperties.stream().filter(def -> def.hasGetter()).forEach(def -> {
            Object value = def.getGetter().getValue(bean);
            map.put(def.getName(), value);
        });
        return map;
    }

    public void validate(Object target) {
        DataBinder dataBinder = new DataBinder(target);
        dataBinder.setValidator(this.validator);
        dataBinder.validate();
        BindingResult bindResult = dataBinder.getBindingResult();
        if (bindResult.hasErrors()) {
            throw new PatchValidationException(bindResult);
        }
    }
}

