/*
 * Decompiled with CFR 0.152.
 */
package io.amplicode.rautils.patch;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.ErrorResponse;

public class PatchValidationException
extends RuntimeException
implements ErrorResponse {
    private final BindingResult bindingResult;
    private final ProblemDetail body;

    public PatchValidationException(BindingResult bindingResult) {
        Assert.notNull((Object)bindingResult, (String)"BindingResult must not be null");
        this.bindingResult = bindingResult;
        this.body = ProblemDetail.forStatusAndDetail((HttpStatusCode)this.getStatusCode(), (String)"Invalid patch request content.");
    }

    public HttpStatusCode getStatusCode() {
        return HttpStatus.BAD_REQUEST;
    }

    public ProblemDetail getBody() {
        return this.body;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("Validation failed ");
        if (this.bindingResult.getErrorCount() > 1) {
            sb.append(" with ").append(this.bindingResult.getErrorCount()).append(" errors");
        }
        sb.append(": ");
        for (ObjectError error : this.bindingResult.getAllErrors()) {
            sb.append('[').append(error).append("] ");
        }
        return sb.toString();
    }

    public Object[] getDetailMessageArguments() {
        return new Object[]{PatchValidationException.errorsToStringList(this.bindingResult.getGlobalErrors()), PatchValidationException.errorsToStringList(this.bindingResult.getFieldErrors())};
    }

    public Object[] getDetailMessageArguments(MessageSource messageSource, Locale locale) {
        return new Object[]{PatchValidationException.errorsToStringList(this.bindingResult.getGlobalErrors(), messageSource, locale), PatchValidationException.errorsToStringList(this.bindingResult.getFieldErrors(), messageSource, locale)};
    }

    public Map<ObjectError, String> resolveErrorMessages(MessageSource messageSource, Locale locale) {
        LinkedHashMap<ObjectError, String> map = new LinkedHashMap<ObjectError, String>();
        PatchValidationException.addMessages(map, this.bindingResult.getGlobalErrors(), messageSource, locale);
        PatchValidationException.addMessages(map, this.bindingResult.getFieldErrors(), messageSource, locale);
        return map;
    }

    private static void addMessages(Map<ObjectError, String> map, List<? extends ObjectError> errors, MessageSource messageSource, Locale locale) {
        List<String> messages = PatchValidationException.errorsToStringList(errors, messageSource, locale);
        for (int i = 0; i < errors.size(); ++i) {
            map.put(errors.get(i), messages.get(i));
        }
    }

    public static List<String> errorsToStringList(List<? extends ObjectError> errors) {
        return PatchValidationException.errorsToStringList(errors, error -> error.getDefaultMessage() != null ? error.getDefaultMessage() : error.getCode());
    }

    public static List<String> errorsToStringList(List<? extends ObjectError> errors, @Nullable MessageSource source, Locale locale) {
        return source != null ? PatchValidationException.errorsToStringList(errors, error -> source.getMessage((MessageSourceResolvable)error, locale)) : PatchValidationException.errorsToStringList(errors);
    }

    private static List<String> errorsToStringList(List<? extends ObjectError> errors, Function<ObjectError, String> formatter) {
        ArrayList<String> result = new ArrayList<String>(errors.size());
        for (ObjectError objectError : errors) {
            String string;
            String value = formatter.apply(objectError);
            if (!StringUtils.hasText((String)value)) continue;
            if (objectError instanceof FieldError) {
                FieldError fieldError = (FieldError)objectError;
                string = fieldError.getField() + ": '" + value + "'";
            } else {
                string = "'" + value + "'";
            }
            result.add(string);
        }
        return result;
    }
}

