/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.common.serialization;

import io.annot8.api.components.Annot8ComponentDescriptor;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Type;

public class Annot8ComponentDescriptorDeserializer
implements JsonbDeserializer<Annot8ComponentDescriptor> {
    private final Jsonb jb = this.createJsonB();

    protected Jsonb createJsonB() {
        return JsonbBuilder.create();
    }

    public Annot8ComponentDescriptor deserialize(JsonParser parser, DeserializationContext ctx, Type type) {
        Annot8ComponentDescriptor desc = null;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            if (event != JsonParser.Event.KEY_NAME) continue;
            String className = parser.getString();
            parser.next();
            try {
                desc = (Annot8ComponentDescriptor)this.jb.fromJson(parser.getObject().toString(), Class.forName(className).asSubclass(Annot8ComponentDescriptor.class));
            }
            catch (ClassNotFoundException e) {
                throw new JsonbException("Deserialization failed - could not find class " + className, (Throwable)e);
            }
        }
        return desc;
    }
}

