/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.text.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.text.processors.AbstractTextProcessor;
import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;

@ComponentName(value="Capitalise")
@ComponentDescription(value="Capitalise or lower case text")
@SettingsClass(value=Settings.class)
public class Capitalise
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getTextCase(), settings.isRemoveSourceContent());
    }

    public Capabilities capabilities() {
        SimpleCapabilities.Builder builder = new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesContent(Text.class);
        if (((Settings)this.getSettings()).isRemoveSourceContent()) {
            builder = builder.withDeletesContent(Text.class);
        }
        return builder.build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private TextCase textCase;
        private boolean removeSourceContent;

        public Settings() {
            this.textCase = TextCase.UPPERCASE;
            this.removeSourceContent = false;
        }

        @JsonbCreator
        public Settings(@JsonbProperty(value="textCase") TextCase textCase, @JsonbProperty(value="removeSourceContent") boolean removeSourceContent) {
            this.textCase = textCase;
            this.removeSourceContent = removeSourceContent;
        }

        public boolean validate() {
            return true;
        }

        @Description(value="What case the text should be normalized to")
        public TextCase getTextCase() {
            return this.textCase;
        }

        public void setTextCase(TextCase textCase) {
            this.textCase = textCase;
        }

        @Description(value="Should the source Content be removed after successful processing?", defaultValue="true")
        public boolean isRemoveSourceContent() {
            return this.removeSourceContent;
        }

        public void setRemoveSourceContent(boolean removeSourceContent) {
            this.removeSourceContent = removeSourceContent;
        }
    }

    public static enum TextCase {
        UPPERCASE,
        LOWERCASE;

    }

    public static class Processor
    extends AbstractTextProcessor {
        private final TextCase textCase;
        private final boolean removeSourceContent;

        public Processor(TextCase textCase, boolean removeSourceContent) {
            this.textCase = textCase;
            this.removeSourceContent = removeSourceContent;
        }

        protected void process(Text content) {
            Item item = content.getItem();
            switch (this.textCase) {
                case UPPERCASE: {
                    item.createContent(Text.class).withDescription(String.format("Upper cased content[%s]", content.getId())).withData((Object)((String)content.getData()).toUpperCase()).save();
                    break;
                }
                case LOWERCASE: {
                    item.createContent(Text.class).withDescription(String.format("Lower cased content[%s]", content.getId())).withData((Object)((String)content.getData()).toLowerCase()).save();
                }
            }
            if (this.removeSourceContent) {
                item.removeContent((Content)content);
            }
        }
    }
}

