/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.text.processors;

import com.github.pemistahl.lingua.api.Language;
import com.github.pemistahl.lingua.api.LanguageDetector;
import com.github.pemistahl.lingua.api.LanguageDetectorBuilder;
import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.context.Context;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.ContentBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.text.processors.AbstractTextProcessor;
import java.util.SortedMap;

@ComponentName(value="Detect Language")
@ComponentDescription(value="Detect the language of text content")
public class DetectLanguage
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations("entity/language", ContentBounds.class).build();
    }

    public static class Processor
    extends AbstractTextProcessor {
        private final LanguageDetector languageDetector;

        public Processor(LanguageDetector languageDetector) {
            this.languageDetector = languageDetector;
        }

        public Processor(Language ... languages) {
            this.languageDetector = LanguageDetectorBuilder.fromLanguages((Language[])languages).build();
        }

        public Processor() {
            this.languageDetector = LanguageDetectorBuilder.fromAllLanguages().build();
        }

        public void process(Text text) {
            SortedMap languages = this.languageDetector.computeLanguageConfidenceValues((String)text.getData());
            Language lang = (Language)languages.firstKey();
            if (lang == Language.UNKNOWN) {
                return;
            }
            ((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)text.getAnnotations().create().withType("entity/language")).withBounds((Bounds)ContentBounds.getInstance()).withProperty("language", (Object)lang.getIsoCode639_1().toString())).withProperty("probability", languages.get(lang))).save();
        }
    }
}

