/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.text.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.text.processors.AbstractTextProcessor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@ComponentName(value="Key Value Pairs")
@ComponentDescription(value="Identify key value pairs within text")
@SettingsClass(value=Settings.class)
public class KeyValuePairs
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesAnnotations(((Settings)this.getSettings()).getAnnotationType(), SpanBounds.class).build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private String annotationType = "metadata";
        private String keyValueSeparator = ":";
        private String valueSeparator = ",";
        private boolean ignoreEmptyValues = true;
        private int maxKeyLength = -1;

        public boolean validate() {
            return this.keyValueSeparator != null && this.annotationType != null;
        }

        @Description(value="The annotation type")
        public String getAnnotationType() {
            return this.annotationType;
        }

        public void setAnnotationType(String annotationType) {
            this.annotationType = annotationType;
        }

        @Description(value="The character(s) that separate the key from the value - can be a regular expression")
        public String getKeyValueSeparator() {
            return this.keyValueSeparator;
        }

        public void setKeyValueSeparator(String keyValueSeparator) {
            this.keyValueSeparator = keyValueSeparator;
        }

        @Description(value="The character(s) that split values into multiple values - can be a regular expression, or null to disable")
        public String getValueSeparator() {
            return this.valueSeparator;
        }

        public void setValueSeparator(String valueSeparator) {
            this.valueSeparator = valueSeparator;
        }

        @Description(value="If true, then empty values are ignored")
        public boolean isIgnoreEmptyValues() {
            return this.ignoreEmptyValues;
        }

        public void setIgnoreEmptyValues(boolean ignoreEmptyValues) {
            this.ignoreEmptyValues = ignoreEmptyValues;
        }

        @Description(value="The maximum key length (keys longer than this will be ignored), or -1 to accept all keys")
        public int getMaxKeyLength() {
            return this.maxKeyLength;
        }

        public void setMaxKeyLength(int maxKeyLength) {
            this.maxKeyLength = maxKeyLength;
        }
    }

    public static class Processor
    extends AbstractTextProcessor {
        private final Settings settings;
        private final Pattern keyValuePattern;

        public Processor(Settings settings) {
            this.settings = settings;
            this.keyValuePattern = Pattern.compile("^\\h*(?<key>.*?)\\h*" + settings.getKeyValueSeparator() + "\\h*(?<value>.*?)\\h*$", 8);
        }

        protected void process(Text content) {
            Matcher m = this.keyValuePattern.matcher((CharSequence)content.getData());
            while (m.find()) {
                String key = m.group("key").strip();
                if (this.settings.getMaxKeyLength() > 0 && key.length() > this.settings.getMaxKeyLength()) continue;
                List<String> values = this.settings.getValueSeparator() != null && !this.settings.getValueSeparator().isEmpty() ? Arrays.stream(m.group("value").split(this.settings.getValueSeparator())).map(String::strip).collect(Collectors.toList()) : List.of(m.group("value").strip());
                if (this.settings.isIgnoreEmptyValues()) {
                    values = values.stream().filter(s -> !s.isBlank()).collect(Collectors.toList());
                }
                if (values.isEmpty()) continue;
                Optional<Object> mergedProperties = Optional.empty();
                String type = null;
                if (values.size() == 1) {
                    SpanBounds sbMatch = new SpanBounds(m.start("value"), m.end("value"));
                    Optional<Object> aMerge = content.getAnnotations().getByBounds(SpanBounds.class).filter(a -> {
                        SpanBounds sb = a.getBounds(SpanBounds.class).orElse(null);
                        if (sb == null) {
                            return false;
                        }
                        return sbMatch.isWithin(sb);
                    }).sorted(Comparator.comparingInt(a -> ((SpanBounds)((Annotation)a).getBounds(SpanBounds.class).get()).getLength()).reversed()).findFirst();
                    if (aMerge.isPresent()) {
                        mergedProperties = Optional.of(((Annotation)aMerge.get()).getProperties().getAll());
                        type = ((Annotation)aMerge.get()).getType();
                    }
                }
                ((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)((Annotation.Builder)content.getAnnotations().create().withBounds((Bounds)new SpanBounds(m.start("key"), m.end("value"))).withType(this.settings.getAnnotationType())).withPropertyIfPresent("entity", mergedProperties)).withPropertyIfPresent("type", Optional.ofNullable(type))).withProperty("key", (Object)key)).withProperty("value", values.size() > 1 ? values : values.get(0))).save();
            }
        }
    }
}

