/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.text.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.annotations.Group;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Row;
import io.annot8.common.data.content.Table;
import io.annot8.common.data.content.TableContent;
import io.annot8.common.data.utils.SortUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@ComponentName(value="Phrases to Table")
@ComponentDescription(value="Converts phrase groups to a table in the format document,content,phraseType,value,start,end")
@SettingsClass(value=Settings.class)
public class PhraseToTable
extends AbstractProcessorDescriptor<Processor, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesGroups("group/grammar/phrase").withCreatesContent(TableContent.class).build();
    }

    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private List<String> phraseTypes = new ArrayList<String>();

        public boolean validate() {
            return this.phraseTypes != null;
        }

        @Description(value="A list of the phrase types (e.g. NP) that should be persisted. If empty, all phrase types are persisted.")
        public List<String> getPhraseTypes() {
            return this.phraseTypes;
        }

        public void setPhraseTypes(List<String> phraseTypes) {
            this.phraseTypes = phraseTypes;
        }
    }

    public static class PhraseRow
    implements Row {
        public static final List<String> COLUMN_HEADINGS = List.of("document", "content", "phraseType", "value", "start", "end");
        private int rowIndex = 0;
        private final List<Object> values;

        public PhraseRow(String documentId, String content, String phraseType, Object value, int start, int end) {
            this.values = List.of(documentId, content, phraseType, value, Integer.valueOf(start), Integer.valueOf(end));
        }

        public List<String> getColumnNames() {
            return COLUMN_HEADINGS;
        }

        public int getColumnCount() {
            return COLUMN_HEADINGS.size();
        }

        public void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public Optional<Object> getValueAt(int index) {
            if (index < 0 || index >= this.values.size()) {
                return Optional.empty();
            }
            return Optional.of(this.values.get(index));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhraseRow phraseRow = (PhraseRow)o;
            return this.rowIndex == phraseRow.rowIndex && Objects.equals(this.values, phraseRow.values);
        }

        public int hashCode() {
            return Objects.hash(this.rowIndex, this.values);
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final Settings settings;

        public Processor(Settings settings) {
            this.settings = settings;
        }

        public ProcessorResponse process(Item item) {
            final List rows = item.getGroups().getByType("group/grammar/phrase").filter(g -> this.settings.getPhraseTypes().isEmpty() || this.settings.getPhraseTypes().contains(g.getProperties().getOrDefault("subtype", (Object)""))).map(g -> this.groupToRow(item, (Group)g)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            for (int i = 0; i < rows.size(); ++i) {
                ((PhraseRow)rows.get(i)).setRowIndex(i);
            }
            Table table = new Table(){

                public int getColumnCount() {
                    return PhraseRow.COLUMN_HEADINGS.size();
                }

                public int getRowCount() {
                    return rows.size();
                }

                public Optional<List<String>> getColumnNames() {
                    return Optional.of(PhraseRow.COLUMN_HEADINGS);
                }

                public Stream<Row> getRows() {
                    return rows.stream().map(r -> r);
                }
            };
            item.createContent(TableContent.class).withData((Object)table).withDescription("Phrases from " + item.getId()).save();
            return ProcessorResponse.ok();
        }

        protected Optional<PhraseRow> groupToRow(Item item, Group g) {
            int end;
            List annotations = g.getAnnotations().values().stream().flatMap(Function.identity()).filter(a -> a.getBounds(SpanBounds.class).isPresent()).sorted(SortUtils.SORT_BY_SPANBOUNDS).collect(Collectors.toList());
            if (annotations.isEmpty()) {
                this.log().info("Group {} is empty of suitable annotations", (Object)g.getId());
                return Optional.empty();
            }
            String contentId = ((Annotation)annotations.get(0)).getContentId();
            if (!annotations.stream().map(Annotation::getContentId).allMatch(a -> a.equals(contentId))) {
                this.log().warn("Group {} contains annotations from more than one Content, and will not be processed", (Object)g.getId());
                return Optional.empty();
            }
            Optional content = item.getContent(contentId);
            if (content.isEmpty()) {
                this.log().warn("Content {} not found", (Object)contentId);
                return Optional.empty();
            }
            int begin = ((SpanBounds)((Annotation)annotations.get(0)).getBounds(SpanBounds.class).orElseThrow()).getBegin();
            SpanBounds sb = new SpanBounds(begin, end = ((SpanBounds)((Annotation)annotations.get(annotations.size() - 1)).getBounds(SpanBounds.class).orElseThrow()).getEnd());
            Optional value = sb.getData((Content)content.get());
            if (value.isEmpty()) {
                this.log().warn("Could not get data from Content {}", (Object)contentId);
                return Optional.empty();
            }
            return Optional.of(new PhraseRow((String)item.getProperties().getOrDefault("source", (Object)item.getId()), contentId, (String)g.getProperties().getOrDefault("subtype", (Object)""), value.get(), begin, end));
        }
    }
}

