/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.text.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.text.processors.AbstractTextProcessor;
import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ComponentName(value="Split Text")
@ComponentDescription(value="Split Text content into separate contents")
@SettingsClass(value=Settings.class)
public class Split
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getSplitOn(), settings.isRemoveSourceContent(), settings.getGroupProperties());
    }

    public Capabilities capabilities() {
        SimpleCapabilities.Builder builder = new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesContent(Text.class);
        if (((Settings)this.getSettings()).isRemoveSourceContent()) {
            builder = builder.withDeletesContent(Text.class);
        }
        return builder.build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private Pattern splitOn;
        private boolean removeSourceContent;
        private Map<Integer, String> groupProperties;

        public Settings() {
            this.splitOn = Pattern.compile("\\*\\*\\* SEPARATOR \\*\\*\\*", 2);
            this.removeSourceContent = false;
            this.groupProperties = Collections.emptyMap();
        }

        @JsonbCreator
        public Settings(@JsonbProperty(value="splitOn") Pattern splitOn, @JsonbProperty(value="removeSourceContent") boolean removeSourceContent, @JsonbProperty(value="groupProperties") Map<Integer, String> groupProperties) {
            this.splitOn = splitOn;
            this.removeSourceContent = removeSourceContent;
            this.groupProperties = groupProperties;
        }

        public boolean validate() {
            return this.splitOn != null;
        }

        @Description(value="The pattern that text content will be split on")
        public Pattern getSplitOn() {
            return this.splitOn;
        }

        public void setSplitOn(Pattern splitOn) {
            this.splitOn = splitOn;
        }

        @Description(value="Should the source Content be removed after successful processing?", defaultValue="true")
        public boolean isRemoveSourceContent() {
            return this.removeSourceContent;
        }

        public void setRemoveSourceContent(boolean removeSourceContent) {
            this.removeSourceContent = removeSourceContent;
        }

        @Description(value="Mapping of groups in the split regex to properties - if set, the value of the group will be assigned to the specified property on the content following the split")
        public Map<Integer, String> getGroupProperties() {
            return this.groupProperties;
        }

        public void setGroupProperties(Map<Integer, String> groupProperties) {
            this.groupProperties = groupProperties;
        }
    }

    public static class Processor
    extends AbstractTextProcessor {
        private final Pattern splitOn;
        private final boolean removeSourceContent;
        private final Map<Integer, String> groupProperties;

        public Processor(Pattern splitOn, boolean removeSourceContent, Map<Integer, String> groupProperties) {
            this.splitOn = splitOn;
            this.removeSourceContent = removeSourceContent;
            this.groupProperties = groupProperties;
        }

        protected void process(Text content) {
            Content.Builder builder;
            Item item = content.getItem();
            Matcher m = this.splitOn.matcher((CharSequence)content.getData());
            int begin = 0;
            int count = 0;
            HashMap<String, String> properties = new HashMap<String, String>();
            while (m.find()) {
                builder = (Content.Builder)((Content.Builder)item.createContent(Text.class).withDescription("Split text #" + count + " from " + content.getId()).withData((Object)((String)content.getData()).substring(begin, m.start())).withProperty("index", (Object)count)).withProperty("parent", (Object)content.getId());
                for (Map.Entry entry : properties.entrySet()) {
                    builder.withProperty((String)entry.getKey(), entry.getValue());
                }
                builder.save();
                properties.clear();
                for (Map.Entry<Object, Object> entry : this.groupProperties.entrySet()) {
                    try {
                        properties.put((String)entry.getValue(), m.group((Integer)entry.getKey()));
                    }
                    catch (IndexOutOfBoundsException ex) {
                        this.log().warn("Could not find group {} in split pattern", entry.getKey(), (Object)ex);
                    }
                }
                begin = m.end();
                ++count;
            }
            if (count > 0) {
                builder = (Content.Builder)((Content.Builder)item.createContent(Text.class).withDescription("Split text #" + count + " from " + content.getId()).withData((Object)((String)content.getData()).substring(begin)).withProperty("index", (Object)count)).withProperty("parent", (Object)content.getId());
                for (Map.Entry entry : properties.entrySet()) {
                    builder.withProperty((String)entry.getKey(), entry.getValue());
                }
                builder.save();
            }
            if (this.removeSourceContent && count > 0) {
                item.removeContent((Content)content);
            }
        }
    }
}

