/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtcandroidframework.api;

import io.antmedia.webrtcandroidframework.api.DefaultWebRTCListener;
import io.antmedia.webrtcandroidframework.websocket.Broadcast;
import org.webrtc.VideoTrack;

public class DefaultConferenceWebRTCListener
extends DefaultWebRTCListener {
    private final String roomId;
    private final String streamId;
    private boolean playStarted = false;
    private boolean publishReconnecting;

    @Override
    public void onNewVideoTrack(VideoTrack track, String streamId) {
        super.onNewVideoTrack(track, streamId);
    }

    public DefaultConferenceWebRTCListener(String roomId, String streamId) {
        this.roomId = roomId;
        this.streamId = streamId;
    }

    @Override
    public void onBroadcastObject(Broadcast broadcast) {
        super.onBroadcastObject(broadcast);
    }

    @Override
    public void onPublishStarted(String streamId) {
        super.onPublishStarted(streamId);
        if (this.publishReconnecting) {
            this.publishReconnecting = false;
        }
        this.webRTCClient.play(this.roomId);
    }

    @Override
    public void onPlayStarted(String streamId) {
        super.onPlayStarted(streamId);
        this.webRTCClient.getBroadcastObject(this.roomId);
        this.playStarted = true;
    }

    @Override
    public void onSessionRestored(String streamId) {
        super.onSessionRestored(streamId);
        if (this.publishReconnecting) {
            this.publishReconnecting = false;
        }
    }

    @Override
    public void onPublishFinished(String streamId) {
        super.onPublishFinished(streamId);
    }

    @Override
    public void onPlayFinished(String streamId) {
        super.onPlayFinished(streamId);
        this.playStarted = false;
    }

    @Override
    public void onReconnectionAttempt(String streamId) {
        super.onReconnectionAttempt(streamId);
        if (streamId.equals(this.streamId)) {
            this.publishReconnecting = true;
        }
    }

    public boolean isPublishReconnectingForTest() {
        return this.publishReconnecting;
    }
}

