/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtcandroidframework.api;

import android.util.Log;
import androidx.annotation.NonNull;
import io.antmedia.webrtcandroidframework.api.IDataChannelObserver;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.webrtc.DataChannel;

public class DefaultDataChannelObserver
implements IDataChannelObserver {
    @Override
    public void onBufferedAmountChange(long previousAmount, String dataChannelLabel) {
        String logText = "Data channel buffered amount changed: " + dataChannelLabel + ": " + previousAmount;
        Log.d((String)DefaultDataChannelObserver.class.getName(), (String)logText);
    }

    @Override
    public void onStateChange(DataChannel.State state, String dataChannelLabel) {
        String logText = "Data channel state changed: " + dataChannelLabel + ": " + (Object)((Object)state);
        Log.d((String)DefaultDataChannelObserver.class.getName(), (String)logText);
    }

    @Override
    public void onMessage(DataChannel.Buffer buffer, String dataChannelLabel) {
        String messageText = this.toTextMessage(buffer);
        this.textMessageReceived(messageText);
    }

    @NonNull
    protected String toTextMessage(DataChannel.Buffer buffer) {
        ByteBuffer data = buffer.data;
        String messageText = new String(data.array(), StandardCharsets.UTF_8);
        return messageText;
    }

    @Override
    public void onMessageSent(DataChannel.Buffer buffer, boolean successful) {
        if (successful) {
            String messageText = this.toTextMessage(buffer);
            Log.i((String)DefaultDataChannelObserver.class.getSimpleName(), (String)"Message is sent");
        } else {
            Log.e((String)DefaultDataChannelObserver.class.getSimpleName(), (String)"Could not send the text message");
        }
    }

    public void textMessageReceived(String messageText) {
        Log.i((String)DefaultDataChannelObserver.class.getSimpleName(), (String)("Text message received: " + messageText));
    }
}

