/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtcandroidframework.api;

import android.util.Log;
import de.tavendo.autobahn.WebSocket;
import io.antmedia.webrtcandroidframework.api.IWebRTCClient;
import io.antmedia.webrtcandroidframework.api.IWebRTCListener;
import io.antmedia.webrtcandroidframework.core.StreamInfo;
import io.antmedia.webrtcandroidframework.websocket.Broadcast;
import java.util.ArrayList;
import org.webrtc.SurfaceViewRenderer;
import org.webrtc.VideoTrack;

public class DefaultWebRTCListener
implements IWebRTCListener {
    protected IWebRTCClient webRTCClient;

    @Override
    public void setWebRTCClient(IWebRTCClient webRTCClient) {
        this.webRTCClient = webRTCClient;
    }

    @Override
    public void onWebSocketConnected() {
        String messageText = "Web Socket Connected";
        this.callbackCalled(messageText);
    }

    @Override
    public void onWebSocketDisconnected() {
        String messageText = "Web Socket Disconnected";
        this.callbackCalled(messageText);
    }

    @Override
    public void onDisconnected() {
        String messageText = "Web Socket Disconnected";
        this.callbackCalled(messageText);
    }

    @Override
    public void onPublishFinished(String streamId) {
        String messageText = "Publish finished for " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onPlayFinished(String streamId) {
        String messageText = "Play finished for " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onPublishStarted(String streamId) {
        String messageText = "Publish started for " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onPlayStarted(String streamId) {
        String messageText = "Play started for " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void noStreamExistsToPlay(String streamId) {
        String messageText = "No stream exists to play for " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onError(String description, String streamId) {
        String messageText = "Error for " + streamId + " : " + description;
        this.callbackCalled(messageText);
    }

    @Override
    public void onSignalChannelClosed(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification code, String streamId) {
        String messageText = "Signal channel closed for " + streamId + " : " + code;
        this.callbackCalled(messageText);
    }

    @Override
    public void streamIdInUse(String streamId) {
        String messageText = "Stream id is already in use " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onIceConnected(String streamId) {
        String messageText = "Ice connected for " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onPeerConnectionCreated(String streamId) {
        String messageText = "Peer Connection created for StreamId " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onIceDisconnected(String streamId) {
        String messageText = "Ice disconnected for " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onTrackList(String[] tracks) {
        String messageText = "Track list received";
        this.callbackCalled(messageText);
    }

    @Override
    public void onBitrateMeasurement(String streamId, int targetBitrate, int videoBitrate, int audioBitrate) {
        String messageText = "Bitrate measurement received";
        this.callbackCalled(messageText);
    }

    @Override
    public void onStreamInfoList(String streamId, ArrayList<StreamInfo> streamInfoList) {
        String messageText = "Stream info list received";
        this.callbackCalled(messageText);
    }

    @Override
    public void onNewVideoTrack(VideoTrack track) {
        this.onNewVideoTrack(track, null);
    }

    @Override
    public void onNewVideoTrack(VideoTrack track, String trackId) {
        String messageText = "New video track received";
        this.callbackCalled(messageText);
        for (SurfaceViewRenderer r : this.webRTCClient.getConfig().remoteVideoRenderers) {
            if (r.getTag() != null) continue;
            r.setTag(track);
            this.webRTCClient.setRendererForVideoTrack(r, track);
            break;
        }
    }

    @Override
    public void onVideoTrackEnded(VideoTrack track) {
        String messageText = "Video track ended";
        this.callbackCalled(messageText);
        for (SurfaceViewRenderer r : this.webRTCClient.getConfig().remoteVideoRenderers) {
            VideoTrack videoTrack = (VideoTrack)r.getTag();
            if (videoTrack == null || !videoTrack.id().equals(track.id())) continue;
            this.webRTCClient.releaseRenderer(r);
            return;
        }
    }

    @Override
    public void onReconnectionAttempt(String streamId) {
        String messageText = "Reconnection attempt for " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onJoinedTheRoom(String streamId, String[] streams) {
        String messageText = "Joined the room for " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onRoomInformation(String[] streams) {
        String messageText = "Room information received";
        this.callbackCalled(messageText);
    }

    @Override
    public void onLeftTheRoom(String roomId) {
        String messageText = "Left the room for " + roomId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onMutedFor(String streamId) {
        String messageText = "Microphone is muted for " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onUnmutedFor(String streamId) {
        String messageText = "Microphone is unmuted for " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onCameraTurnOnFor(String streamId) {
        String messageText = "Camera is turned on for " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onCameraTurnOffFor(String streamId) {
        String messageText = "Camera is turned off for " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onSatatusUpdateFor(String streamId, boolean micStatus, boolean cameraStatus) {
        String messageText = "Status update for " + streamId + " mic: " + micStatus + " camera: " + cameraStatus;
        this.callbackCalled(messageText);
    }

    @Override
    public void onSessionRestored(String streamId) {
        String messageText = "Session restored for " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onBroadcastObject(Broadcast broadcast) {
        String messageText = "Broadcast object received";
        this.callbackCalled(messageText);
    }

    @Override
    public void onReconnectionSuccess() {
        String messageText = "Reconnection success";
        this.callbackCalled(messageText);
    }

    @Override
    public void onPublishAttempt(String streamId) {
        String messageText = "Publish attempt for stream " + streamId;
        this.callbackCalled(messageText);
    }

    @Override
    public void onPlayAttempt(String streamId) {
        String messageText = "Play attempt for stream " + streamId;
        this.callbackCalled(messageText);
    }

    protected void callbackCalled(String messageText) {
        Log.d((String)DefaultWebRTCListener.class.getName(), (String)messageText);
    }
}

