/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtcandroidframework.api;

import android.app.Activity;
import io.antmedia.webrtcandroidframework.api.IDataChannelObserver;
import io.antmedia.webrtcandroidframework.api.IWebRTCClient;
import io.antmedia.webrtcandroidframework.api.IWebRTCListener;
import io.antmedia.webrtcandroidframework.api.WebRTCClientConfig;
import io.antmedia.webrtcandroidframework.core.WebRTCClient;
import java.util.Arrays;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceViewRenderer;

public class WebRTCClientBuilder {
    private WebRTCClientConfig webRTCClientConfig = new WebRTCClientConfig();

    public WebRTCClient build() {
        return new WebRTCClient(this.webRTCClientConfig);
    }

    public WebRTCClientBuilder setServerUrl(String serverUrl) {
        this.webRTCClientConfig.serverUrl = serverUrl;
        return this;
    }

    public WebRTCClientBuilder setStreamId(String streamId) {
        this.webRTCClientConfig.streamId = streamId;
        return this;
    }

    public WebRTCClientBuilder setToken(String token) {
        this.webRTCClientConfig.token = token;
        return this;
    }

    public WebRTCClientBuilder setVideoCallEnabled(boolean videoCallEnabled) {
        this.webRTCClientConfig.videoCallEnabled = videoCallEnabled;
        return this;
    }

    public WebRTCClientBuilder setAudioCallEnabled(boolean audioCallEnabled) {
        this.webRTCClientConfig.audioCallEnabled = audioCallEnabled;
        return this;
    }

    public WebRTCClientBuilder setDataChannelEnabled(boolean dataChannelEnabled) {
        this.webRTCClientConfig.dataChannelEnabled = dataChannelEnabled;
        return this;
    }

    public WebRTCClientBuilder setVideoWidth(int videoWidth) {
        this.webRTCClientConfig.videoWidth = videoWidth;
        return this;
    }

    public WebRTCClientBuilder setVideoHeight(int videoHeight) {
        this.webRTCClientConfig.videoHeight = videoHeight;
        return this;
    }

    public WebRTCClientBuilder setVideoFps(int videoFps) {
        this.webRTCClientConfig.videoFps = videoFps;
        return this;
    }

    public WebRTCClientBuilder setVideoStartBitrate(int videoStartBitrate) {
        this.webRTCClientConfig.videoStartBitrate = videoStartBitrate;
        return this;
    }

    public WebRTCClientBuilder setVideoCodec(String videoCodec) {
        this.webRTCClientConfig.videoCodec = videoCodec;
        return this;
    }

    public WebRTCClientBuilder setAudioStartBitrate(int audioStartBitrate) {
        this.webRTCClientConfig.audioStartBitrate = audioStartBitrate;
        return this;
    }

    public WebRTCClientBuilder setAudioCodec(String audioCodec) {
        this.webRTCClientConfig.audioCodec = audioCodec;
        return this;
    }

    public WebRTCClientBuilder setLocalVideoRenderer(SurfaceViewRenderer localVideoRenderer) {
        this.webRTCClientConfig.localVideoRenderer = localVideoRenderer;
        return this;
    }

    public WebRTCClientBuilder addRemoteVideoRenderer(SurfaceViewRenderer ... remoteVideoRenderers) {
        this.webRTCClientConfig.remoteVideoRenderers.addAll(Arrays.asList(remoteVideoRenderers));
        return this;
    }

    public WebRTCClientBuilder setWebRTCListener(IWebRTCListener webRTCListener) {
        this.webRTCClientConfig.webRTCListener = webRTCListener;
        return this;
    }

    public WebRTCClientBuilder setDataChannelObserver(IDataChannelObserver dataChannelObserver) {
        this.webRTCClientConfig.dataChannelObserver = dataChannelObserver;
        return this;
    }

    public WebRTCClientBuilder setActivity(Activity activity) {
        this.webRTCClientConfig.activity = activity;
        return this;
    }

    public WebRTCClientBuilder setInitiateBeforeStream(boolean b) {
        this.webRTCClientConfig.initiateBeforeStream = b;
        return this;
    }

    public WebRTCClientBuilder setCustomAudioFeed(boolean b) {
        this.webRTCClientConfig.customAudioFeed = b;
        return this;
    }

    public WebRTCClientBuilder setScalingType(RendererCommon.ScalingType scaleAspectFit) {
        this.webRTCClientConfig.scalingType = scaleAspectFit;
        return this;
    }

    public WebRTCClientBuilder setStunServerUri(String stunServerUri) {
        this.webRTCClientConfig.stunServerUri = stunServerUri;
        return this;
    }

    public WebRTCClientBuilder setReconnectionEnabled(boolean b) {
        this.webRTCClientConfig.reconnectionEnabled = b;
        return this;
    }

    public WebRTCClientConfig getConfig() {
        return this.webRTCClientConfig;
    }

    public WebRTCClientBuilder setVideoSource(IWebRTCClient.StreamSource rearCamera) {
        this.webRTCClientConfig.videoSource = rearCamera;
        return this;
    }
}

