/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtcandroidframework.core;

import android.content.Context;
import android.util.Log;
import org.webrtc.CapturerObserver;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

public class CustomVideoCapturer
implements VideoCapturer {
    private static final String TAG = "CustomVideoCapturer";
    private CapturerObserver capturerObserver;
    public SurfaceTextureHelper surfaceTextureHelper;

    public void writeFrame(VideoFrame videoFrame) {
        this.capturerObserver.onFrameCaptured(videoFrame);
        videoFrame.release();
    }

    @Override
    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, CapturerObserver capturerObserver) {
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.capturerObserver = capturerObserver;
    }

    @Override
    public void startCapture(final int width, final int height, int framerate) {
        this.surfaceTextureHelper.setTextureSize(height, width);
        this.surfaceTextureHelper.startListening(new VideoSink(){

            @Override
            public void onFrame(VideoFrame frame) {
                CustomVideoCapturer.this.capturerObserver.onFrameCaptured(frame);
                Log.i((String)"CustomVideoCapturer****", (String)("width:" + width + " height:" + height));
            }
        });
    }

    @Override
    public void stopCapture() throws InterruptedException {
    }

    @Override
    public void changeCaptureFormat(int width, int height, int framerate) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    public SurfaceTextureHelper getSurfaceTextureHelper() {
        return this.surfaceTextureHelper;
    }
}

