/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtcandroidframework.core;

import android.content.res.Resources;
import android.media.Image;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;

public class MediaFileReader {
    private static final int DESIRED_SAMPLE_RATE = 48000;
    private AtomicBoolean stopRequested = new AtomicBoolean(false);
    private MediaFormat format;
    private VideoFrameListener videoFrameListener;
    private AudioFrameListener audioFrameListener;
    private FrameType frameType;
    private MediaExtractor extractor;
    private String TAG = MediaFileReader.class.getSimpleName();

    private MediaFileReader(MediaExtractor extractor) {
        this.extractor = extractor;
    }

    @RequiresApi(api=24)
    public static MediaFileReader fromResources(Resources resources, int resourceId) {
        MediaExtractor extractor = new MediaExtractor();
        try {
            extractor.setDataSource(resources.openRawResourceFd(resourceId));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new MediaFileReader(extractor);
    }

    public static MediaFileReader fromPath(String filePath) {
        MediaExtractor extractor = new MediaExtractor();
        try {
            FileInputStream inputStream = new FileInputStream(filePath);
            extractor.setDataSource(inputStream.getFD());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new MediaFileReader(extractor);
    }

    public MediaFileReader withFrameType(FrameType frameType) {
        this.frameType = frameType;
        return this;
    }

    public MediaFileReader withVideoFrameListener(VideoFrameListener videoFrameListener) {
        this.videoFrameListener = videoFrameListener;
        return this;
    }

    public MediaFileReader withAudioFrameListener(AudioFrameListener audioFrameListener) {
        this.audioFrameListener = audioFrameListener;
        return this;
    }

    public void start() {
        this.format = this.getMediaFormat();
        Thread t = new Thread(){

            @Override
            @RequiresApi(api=24)
            public void run() {
                MediaFileReader.this.decodeFrames();
            }
        };
        t.start();
    }

    @Nullable
    private MediaFormat getMediaFormat() {
        MediaFormat format = null;
        int trackCount = this.extractor.getTrackCount();
        for (int i = 0; i < trackCount; ++i) {
            format = this.extractor.getTrackFormat(i);
            String mime = format.getString("mime");
            if (mime == null || !mime.startsWith(this.frameType.toString() + "/")) continue;
            this.extractor.selectTrack(i);
            break;
        }
        return format;
    }

    private void decodeFrames() {
        try {
            MediaCodec decoder = this.getMediaCodec();
            decoder.configure(this.format, null, null, 0);
            decoder.start();
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            boolean isEOS = false;
            ByteBuffer rawAudioBuffer = ByteBuffer.allocate(this.get10MsBufferLength() * 20);
            while (!(Thread.interrupted() || isEOS || this.stopRequested.get())) {
                int inputIndex = decoder.dequeueInputBuffer(10000L);
                System.out.println("inputIndex: " + inputIndex);
                if (inputIndex >= 0) {
                    ByteBuffer inputBuffer = decoder.getInputBuffer(inputIndex);
                    int sampleSize = this.extractor.readSampleData(inputBuffer, 0);
                    if (sampleSize < 0) {
                        isEOS = true;
                        decoder.queueInputBuffer(inputIndex, 0, 0, 0L, 4);
                    } else {
                        decoder.queueInputBuffer(inputIndex, 0, sampleSize, this.extractor.getSampleTime(), 0);
                        this.extractor.advance();
                    }
                }
                int outputIndex = decoder.dequeueOutputBuffer(bufferInfo, 10000L);
                System.out.println("outputIndex: " + outputIndex);
                if (outputIndex >= 0) {
                    if (this.frameType == FrameType.video) {
                        Image yuvImage = decoder.getOutputImage(outputIndex);
                        this.videoFrameListener.onYuvImage(yuvImage);
                        yuvImage.close();
                    } else if (this.frameType == FrameType.audio) {
                        ByteBuffer outputBuffer = decoder.getOutputBuffer(outputIndex);
                        rawAudioBuffer.put(outputBuffer);
                        this.processAudio(rawAudioBuffer);
                    }
                    decoder.releaseOutputBuffer(outputIndex, false);
                } else if (outputIndex == -2) {
                    // empty if block
                }
                Thread.sleep(this.sleepTime(this.frameType));
            }
            decoder.stop();
            decoder.release();
            this.extractor.release();
            this.stopRequested.set(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MediaCodec getMediaCodec() throws IOException {
        MediaCodec decoder = MediaCodec.createDecoderByType((String)this.format.getString("mime"));
        return decoder;
    }

    private void processAudio(ByteBuffer rawAudioBuffer) {
        int bufferLength = this.get10MsBufferLength();
        int length = rawAudioBuffer.position();
        rawAudioBuffer.position(0);
        int channelCount = this.format.getInteger("channel-count");
        int readBufferLength = bufferLength * this.format.getInteger("sample-rate") / 48000 * channelCount;
        Log.d((String)this.TAG, (String)("pushAudio: length: " + length + " bufferLength: " + bufferLength));
        while (length - rawAudioBuffer.position() >= readBufferLength) {
            byte[] pcmData = new byte[readBufferLength];
            rawAudioBuffer.get(pcmData);
            byte[] resampledData = this.modifySampleRate(pcmData, this.format.getInteger("sample-rate"), 48000, channelCount);
            Log.d((String)this.TAG, (String)("length: " + length + " position: " + rawAudioBuffer.position()));
            this.audioFrameListener.onAudioData(resampledData);
        }
        byte[] moreData = new byte[length - rawAudioBuffer.position()];
        rawAudioBuffer.get(moreData);
        rawAudioBuffer.clear();
        rawAudioBuffer.put(moreData);
    }

    private int get10MsBufferLength() {
        int channels = 1;
        int bytesPerSample = 2;
        int bytesPerFrame = channels * bytesPerSample;
        int framesPerBuffer = 441;
        int bufferLength = bytesPerFrame * framesPerBuffer;
        return bufferLength;
    }

    private byte[] modifySampleRate(byte[] pcmData, int inputSampleRate, int outputSampleRate, int channelCount) {
        int inputLength = pcmData.length / 2;
        int outputLength = (int)((float)inputLength / (float)inputSampleRate * (float)outputSampleRate) / channelCount;
        short[] inputSamples = new short[inputLength];
        short[] outputSamples = new short[outputLength];
        ByteBuffer.wrap(pcmData).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(inputSamples);
        float ratio = (float)inputSampleRate / (float)outputSampleRate;
        for (int i = 0; i < outputLength; ++i) {
            float index = (float)i * ratio;
            int leftSampleIndex = (int)index;
            int rightSampleIndex = Math.min(leftSampleIndex + 1, inputLength - channelCount);
            float fraction = index - (float)leftSampleIndex;
            short leftSample = inputSamples[leftSampleIndex * channelCount];
            short rightSample = inputSamples[Math.min(rightSampleIndex * channelCount, inputLength - 1)];
            outputSamples[i] = (short)(((1.0f - fraction) * (float)leftSample + fraction * (float)rightSample) / 2.0f);
        }
        byte[] outputData = new byte[outputLength * 2];
        ByteBuffer.wrap(outputData).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().put(outputSamples);
        return outputData;
    }

    private long sleepTime(FrameType frameType) {
        return frameType == FrameType.video ? 50L : 10L;
    }

    public void stop() {
        this.stopRequested.set(true);
    }

    public void setMediaExtractorForTest(MediaExtractor extractor) {
        this.extractor = extractor;
    }

    public static enum FrameType {
        video,
        audio;

    }

    public static interface AudioFrameListener {
        public void onAudioData(byte[] var1);
    }

    public static interface VideoFrameListener {
        public void onYuvImage(Image var1);
    }
}

