/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtcandroidframework.core;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.widget.Toast;
import androidx.core.app.ActivityCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PermissionsHandler {
    private final Activity activity;
    private PermissionCallback permissionCallback;
    public static final String[] REQUIRED_EXTENDED_PERMISSIONS;
    public static final String[] REQUIRED_MINIMUM_PERMISSIONS;

    public PermissionsHandler(Activity activity) {
        this.activity = activity;
    }

    public boolean checkAndRequestPermisssions(boolean isExtended, PermissionCallback permissionCallback) {
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.addAll(Arrays.asList(REQUIRED_MINIMUM_PERMISSIONS));
        if (isExtended) {
            permissions.addAll(Arrays.asList(REQUIRED_EXTENDED_PERMISSIONS));
        }
        if (this.hasPermissions(this.activity.getApplicationContext(), permissions)) {
            return true;
        }
        this.permissionCallback = permissionCallback;
        this.showPermissionsErrorAndRequest(permissions);
        return false;
    }

    public boolean hasPermissions(Context context, List<String> permissions) {
        if (context != null && permissions != null) {
            for (String permission2 : permissions) {
                if (ActivityCompat.checkSelfPermission((Context)context, (String)permission2) == 0) continue;
                Log.w((String)PermissionsHandler.class.getSimpleName(), (String)("Permission required:" + permission2));
                return false;
            }
        }
        return true;
    }

    public void showPermissionsErrorAndRequest(List<String> permissions) {
        this.makeToast("You need permissions before", 0);
        String[] permissionArray = new String[permissions.size()];
        permissions.toArray(permissionArray);
        ActivityCompat.requestPermissions((Activity)this.activity, (String[])permissionArray, (int)1);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        this.permissionCallback.onPermissionResult();
    }

    public void makeToast(String messageText, int lengthLong) {
        this.activity.runOnUiThread(() -> Toast.makeText((Context)this.activity, (CharSequence)messageText, (int)lengthLong).show());
    }

    static {
        String[] stringArray;
        if (Build.VERSION.SDK_INT >= 31) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "android.permission.RECORD_AUDIO";
            stringArray2[1] = "android.permission.CAMERA";
            stringArray = stringArray2;
            stringArray2[2] = "android.permission.BLUETOOTH_CONNECT";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "android.permission.RECORD_AUDIO";
            stringArray = stringArray3;
            stringArray3[1] = "android.permission.CAMERA";
        }
        REQUIRED_EXTENDED_PERMISSIONS = stringArray;
        REQUIRED_MINIMUM_PERMISSIONS = new String[]{"android.permission.MODIFY_AUDIO_SETTINGS", "android.permission.INTERNET"};
    }

    public static interface PermissionCallback {
        public void onPermissionResult();
    }
}

