/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtcandroidframework.core;

import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.webrtc.RTCStats;
import org.webrtc.RTCStatsReport;

public class StatsCollector {
    public static final String SSRC = "ssrc";
    public static final String OUTBOUND_RTP = "outbound-rtp";
    public static final String AUDIO = "audio";
    public static final String MEDIA_TYPE = "mediaType";
    public static final String PACKETS_SENT = "packetsSent";
    public static final String BYTES_SENT = "bytesSent";
    public static final String VIDEO = "video";
    public static final String REMOTE_INBOUND_RTP = "remote-inbound-rtp";
    public static final String TRACK_ID = "trackId";
    public static final String TRACK_IDENTIFIER = "trackIdentifier";
    public static final String KIND = "kind";
    public static final String NACK_COUNT = "nackCount";
    public static final String PLI_COUNT = "pliCount";
    public static final String FIR_COUNT = "firCount";
    public static final String FRAME_ENCODED = "framesEncoded";
    public static final String ROUND_TRIP_TIME = "roundTripTime";
    public static final String JITTER = "jitter";
    public static final String PACKETS_LOST = "packetsLost";
    public static final String VIDEO_TRACK_ID = "ARDAMSv";
    public static final String AUDIO_TRACK_ID = "ARDAMSa";
    public static final String AUDIO_LEVEL = "audioLevel";
    private double lastKnownStatsTimeStampMs;
    private long lastKnownAudioBytesSent;
    private long lastKnownVideoBytesSent;
    private long localAudioBitrate;
    private long localVideoBitrate;
    private double localAudioLevel;
    private final Map<Long, TrackStats> videoTrackStatsMap = new ConcurrentHashMap<Long, TrackStats>();
    private final Map<Long, TrackStats> audioTrackStatsMap = new ConcurrentHashMap<Long, TrackStats>();

    public void onStatsReport(RTCStatsReport report) {
        this.parseStats(report);
    }

    private void parseStats(RTCStatsReport report) {
        Map<String, RTCStats> statsMap = report.getStatsMap();
        double timeMs = 0.0;
        for (Map.Entry<String, RTCStats> entry : statsMap.entrySet()) {
            Map<String, Object> members;
            RTCStats value = entry.getValue();
            timeMs = value.getTimestampUs() / 1000.0;
            if (OUTBOUND_RTP.equals(value.getType())) {
                long packetsSent;
                long timeDiffSeconds = (long)((timeMs - this.lastKnownStatsTimeStampMs) / 1000.0);
                long l = timeDiffSeconds = timeDiffSeconds == 0L ? 1L : timeDiffSeconds;
                if (AUDIO.equals(value.getMembers().get(KIND))) {
                    long ssrc = (Long)value.getMembers().get(SSRC);
                    TrackStats audioTrackStat = this.audioTrackStatsMap.get(ssrc);
                    if (audioTrackStat == null) {
                        audioTrackStat = new TrackStats();
                        this.audioTrackStatsMap.put(ssrc, audioTrackStat);
                    }
                    packetsSent = ((BigInteger)value.getMembers().get(PACKETS_SENT)).longValue();
                    audioTrackStat.setPacketsSent(packetsSent);
                    BigInteger bytesSent = (BigInteger)value.getMembers().get(BYTES_SENT);
                    audioTrackStat.setBytesSent(bytesSent);
                    audioTrackStat.setTimeMs((long)timeMs);
                    String trackSenderId = (String)value.getMembers().get(TRACK_ID);
                    if (trackSenderId != null) {
                        String trackId = (String)statsMap.get(trackSenderId).getMembers().get(TRACK_IDENTIFIER);
                        trackId = trackId.replace(AUDIO_TRACK_ID, "");
                        audioTrackStat.setTrackId(trackId);
                    }
                    this.localAudioBitrate = (bytesSent.longValue() - this.lastKnownAudioBytesSent) / timeDiffSeconds * 8L;
                    this.lastKnownAudioBytesSent = bytesSent.longValue();
                    continue;
                }
                if (!VIDEO.equals(value.getMembers().get(KIND)) || !value.getMembers().containsKey(SSRC)) continue;
                long ssrc = (Long)value.getMembers().get(SSRC);
                TrackStats videoTrackStat = this.videoTrackStatsMap.get(ssrc);
                if (videoTrackStat == null) {
                    videoTrackStat = new TrackStats();
                    this.videoTrackStatsMap.put(ssrc, videoTrackStat);
                }
                if (value.getMembers().containsKey(FIR_COUNT)) {
                    long firCount = (Long)value.getMembers().get(FIR_COUNT);
                    videoTrackStat.setFirCount(firCount);
                }
                if (value.getMembers().containsKey(PLI_COUNT)) {
                    long pliCount = (Long)value.getMembers().get(PLI_COUNT);
                    videoTrackStat.setPliCount(pliCount);
                }
                if (value.getMembers().containsKey(NACK_COUNT)) {
                    long nackCount = (Long)value.getMembers().get(NACK_COUNT);
                    videoTrackStat.setNackCount(nackCount);
                }
                if (value.getMembers().containsKey(PACKETS_SENT)) {
                    packetsSent = ((BigInteger)value.getMembers().get(PACKETS_SENT)).longValue();
                    videoTrackStat.setPacketsSent(packetsSent);
                }
                if (value.getMembers().containsKey(BYTES_SENT)) {
                    BigInteger bytesSent = (BigInteger)value.getMembers().get(BYTES_SENT);
                    videoTrackStat.setBytesSent(bytesSent);
                    this.localVideoBitrate = (bytesSent.longValue() - this.lastKnownVideoBytesSent) / timeDiffSeconds * 8L;
                    this.lastKnownVideoBytesSent = bytesSent.bitCount();
                }
                if (value.getMembers().containsKey(FRAME_ENCODED)) {
                    long framesEncoded = (Long)value.getMembers().get(FRAME_ENCODED);
                    videoTrackStat.setFramesEncoded(framesEncoded);
                }
                videoTrackStat.setTimeMs((long)timeMs);
                String trackSenderId = (String)value.getMembers().get(TRACK_ID);
                if (trackSenderId == null) continue;
                String trackId = (String)statsMap.get(trackSenderId).getMembers().get(TRACK_IDENTIFIER);
                trackId = trackId.replace(VIDEO_TRACK_ID, "");
                videoTrackStat.setTrackId(trackId);
                continue;
            }
            if (REMOTE_INBOUND_RTP.equals(value.getType())) {
                long packetsLost;
                if (VIDEO.equals(value.getMembers().get(KIND))) {
                    if (!value.getMembers().containsKey(SSRC)) continue;
                    long ssrc = (Long)value.getMembers().get(SSRC);
                    TrackStats videoTrackStat = this.videoTrackStatsMap.get(ssrc);
                    if (videoTrackStat == null) {
                        videoTrackStat = new TrackStats();
                        this.videoTrackStatsMap.put(ssrc, videoTrackStat);
                    }
                    if (value.getMembers().containsKey(PACKETS_LOST)) {
                        packetsLost = ((Integer)value.getMembers().get(PACKETS_LOST)).intValue();
                        videoTrackStat.setPacketsLost(packetsLost);
                    }
                    if (value.getMembers().containsKey(JITTER)) {
                        double jitter = (Double)value.getMembers().get(JITTER);
                        videoTrackStat.setJitter(jitter);
                    }
                    if (!value.getMembers().containsKey(ROUND_TRIP_TIME)) continue;
                    double roundTripTime = (Double)value.getMembers().get(ROUND_TRIP_TIME);
                    videoTrackStat.setRoundTripTime(roundTripTime);
                    continue;
                }
                if (!AUDIO.equals(value.getMembers().get(KIND)) || !value.getMembers().containsKey(SSRC)) continue;
                long ssrc = (Long)value.getMembers().get(SSRC);
                TrackStats audioTrackStat = this.audioTrackStatsMap.get(ssrc);
                if (audioTrackStat == null) {
                    audioTrackStat = new TrackStats();
                    this.audioTrackStatsMap.put(ssrc, audioTrackStat);
                }
                if (value.getMembers().containsKey(PACKETS_LOST)) {
                    packetsLost = ((Integer)value.getMembers().get(PACKETS_LOST)).intValue();
                    audioTrackStat.setPacketsLost(packetsLost);
                }
                if (value.getMembers().containsKey(JITTER)) {
                    double jitter = (Double)value.getMembers().get(JITTER);
                    audioTrackStat.setJitter(jitter);
                }
                if (!value.getMembers().containsKey(ROUND_TRIP_TIME)) continue;
                double roundTripTime = (Double)value.getMembers().get(ROUND_TRIP_TIME);
                audioTrackStat.setRoundTripTime(roundTripTime);
                continue;
            }
            if (!"media-source".equals(value.getType()) || !(members = value.getMembers()).containsKey(AUDIO_LEVEL)) continue;
            this.localAudioLevel = (Double)members.get(AUDIO_LEVEL);
        }
        this.lastKnownStatsTimeStampMs = timeMs;
    }

    public double getLocalAudioLevel() {
        return this.localAudioLevel;
    }

    public long getLocalAudioBitrate() {
        return this.localAudioBitrate;
    }

    public long getLocalVideoBitrate() {
        return this.localVideoBitrate;
    }

    public long getLastKnownAudioBytesSent() {
        return this.lastKnownAudioBytesSent;
    }

    public long getLastKnownVideoBytesSent() {
        return this.lastKnownVideoBytesSent;
    }

    public Map<Long, TrackStats> getVideoTrackStatsMap() {
        return this.videoTrackStatsMap;
    }

    public Map<Long, TrackStats> getAudioTrackStatsMap() {
        return this.audioTrackStatsMap;
    }

    public static class TrackStats {
        private long packetsLost = 0L;
        private double jitter;
        private double roundTripTime;
        private float packetLostRatio;
        private long packetsLostDifference;
        long firCount;
        long pliCount;
        long nackCount;
        long packetsSent;
        private long framesEncoded;
        BigInteger bytesSent = BigInteger.ZERO;
        private long packetsSentPerSecond;
        private BigInteger bytesSentPerSecond = BigInteger.ZERO;
        private long framesEncodedPerSecond;
        private long timeMs;
        private long packetsSentDifference;
        private BigInteger bytesSentDiff = BigInteger.ZERO;
        private long framesEncodedDifference;
        private String trackId;
        private long timeDifference;

        public void setPacketsLost(long packetsLost) {
            this.packetsLostDifference = packetsLost - this.packetsLost;
            this.packetsLost = packetsLost;
        }

        public void setJitter(double jitter) {
            this.jitter = jitter;
        }

        public void setPacketLostRatio(float packetLostRatio) {
            this.packetLostRatio = packetLostRatio;
        }

        public void setRoundTripTime(double roundTripTime) {
            this.roundTripTime = roundTripTime;
        }

        public void setFirCount(long firCount) {
            this.firCount = firCount;
        }

        public void setPliCount(long pliCount) {
            this.pliCount = pliCount;
        }

        public void setNackCount(long nackCount) {
            this.nackCount = nackCount;
        }

        public void setPacketsSent(long packetsSent) {
            this.packetsSentDifference = packetsSent - this.packetsSent;
            this.packetsSent = packetsSent;
        }

        public void setBytesSent(BigInteger bytesSent) {
            this.bytesSentDiff = bytesSent.subtract(this.bytesSent);
            this.bytesSent = bytesSent;
        }

        public void setFramesEncoded(long framesEncoded) {
            this.framesEncodedDifference = this.framesEncodedPerSecond - this.framesEncodedPerSecond;
            this.framesEncoded = framesEncoded;
        }

        public void setTimeMs(long timeMs) {
            this.timeDifference = timeMs - this.timeMs;
            if (this.timeDifference > 0L) {
                this.packetsSentPerSecond = this.packetsSentDifference * 1000L / this.timeDifference;
                this.bytesSentPerSecond = this.bytesSentDiff.multiply(BigInteger.valueOf(1000L)).divide(BigInteger.valueOf(this.timeDifference));
                this.framesEncodedPerSecond = this.framesEncodedDifference * 1000L / this.timeDifference;
            }
            if (this.timeDifference == 0L) {
                return;
            }
            this.timeMs = timeMs;
        }

        public long getPacketsLost() {
            return this.packetsLost;
        }

        public double getJitter() {
            return this.jitter;
        }

        public double getRoundTripTime() {
            return this.roundTripTime;
        }

        public float getPacketLostRatio() {
            this.packetLostRatio = 100.0f * (float)this.packetsLostDifference / (float)this.packetsSentDifference;
            return this.packetLostRatio;
        }

        public BigInteger getBytesSent() {
            return this.bytesSent;
        }

        public long getPacketsLostDifference() {
            return this.packetsLostDifference;
        }

        public long getFirCount() {
            return this.firCount;
        }

        public long getPliCount() {
            return this.pliCount;
        }

        public long getNackCount() {
            return this.nackCount;
        }

        public long getPacketsSent() {
            return this.packetsSent;
        }

        public long getPacketsSentPerSecond() {
            return this.packetsSentPerSecond;
        }

        public BigInteger getBytesSentPerSecond() {
            return this.bytesSentPerSecond;
        }

        public long getFramesEncoded() {
            return this.framesEncoded;
        }

        public long getFramesEncodedPerSecond() {
            return this.framesEncodedPerSecond;
        }

        public long getTimeMs() {
            return this.timeMs;
        }

        public long getPacketsSentDifference() {
            return this.packetsSentDifference;
        }

        public BigInteger getBytesSentDiff() {
            return this.bytesSentDiff;
        }

        public long getFramesEncodedDifference() {
            return this.framesEncodedDifference;
        }

        public String getTrackId() {
            return this.trackId;
        }

        public void setTrackId(String trackId) {
            this.trackId = trackId;
        }

        public String toString() {
            return "TrackStats {trackId='" + this.trackId + ", time diff =" + this.timeDifference + ", packetsLost=" + this.packetsLost + ", jitter=" + this.jitter + ", roundTripTime=" + this.roundTripTime + ", packetLostRatio=" + this.getPacketLostRatio() + ", videoPacketsLostDifference=" + this.packetsLostDifference + ", firCount=" + this.firCount + ", pliCount=" + this.pliCount + ", nackCount=" + this.nackCount + ", packetsSent=" + this.packetsSent + ", framesEncoded=" + this.framesEncoded + ", bytesSent=" + this.bytesSent + ", packetsSentPerSecond=" + this.packetsSentPerSecond + ", bytesSentPerSecond=" + this.bytesSentPerSecond + ", framesEncodedPerSecond=" + this.framesEncodedPerSecond + ", timeMs=" + this.timeMs + ", packetsSentDifference=" + this.packetsSentDifference + ", bytesSentDiff=" + this.bytesSentDiff + ", framesEncodedDifference=" + this.framesEncodedDifference + '\'' + '}';
        }
    }
}

