/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtcandroidframework.core;

import android.content.Context;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.antmedia.webrtcandroidframework.api.IWebRTCClient;
import io.antmedia.webrtcandroidframework.api.WebRTCClientConfig;
import io.antmedia.webrtcandroidframework.apprtc.AppRTCAudioManager;
import io.antmedia.webrtcandroidframework.core.CustomVideoCapturer;
import io.antmedia.webrtcandroidframework.core.PermissionsHandler;
import io.antmedia.webrtcandroidframework.core.ProxyVideoSink;
import io.antmedia.webrtcandroidframework.core.StatsCollector;
import io.antmedia.webrtcandroidframework.core.StreamInfo;
import io.antmedia.webrtcandroidframework.websocket.AntMediaSignallingEvents;
import io.antmedia.webrtcandroidframework.websocket.Broadcast;
import io.antmedia.webrtcandroidframework.websocket.WebSocketHandler;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.webrtc.AddIceObserver;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.CandidatePairChangeEvent;
import org.webrtc.DataChannel;
import org.webrtc.DefaultVideoDecoderFactory;
import org.webrtc.DefaultVideoEncoderFactory;
import org.webrtc.EglBase;
import org.webrtc.IceCandidate;
import org.webrtc.IceCandidateErrorEvent;
import org.webrtc.Logging;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.MediaStreamTrack;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RTCStatsReport;
import org.webrtc.RtpParameters;
import org.webrtc.RtpReceiver;
import org.webrtc.RtpSender;
import org.webrtc.ScreenCapturerAndroid;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.SoftwareVideoDecoderFactory;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.SurfaceViewRenderer;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoSink;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.CustomWebRtcAudioRecord;
import org.webrtc.audio.JavaAudioDeviceModule;

public class WebRTCClient
implements IWebRTCClient,
AntMediaSignallingEvents {
    private static final String TAG = "WebRTCClient";
    public static final String VIDEO_ROTATION_EXT_LINE = "a=extmap:3 urn:3gpp:video-orientation\r\n";
    public static final String USER_REVOKED_CAPTURE_SCREEN_PERMISSION = "User revoked permission to capture the screen.";
    public static int STAT_CALLBACK_PERIOD = 1000;
    protected final ProxyVideoSink localVideoSink = new ProxyVideoSink();
    protected final List<ProxyVideoSink> remoteVideoSinks = new ArrayList<ProxyVideoSink>();
    protected Handler mainHandler;
    @javax.annotation.Nullable
    public AppRTCAudioManager audioManager = null;
    private final long callStartedTimeMs = 0L;
    protected EglBase eglBase;
    private String errorString = null;
    private boolean streamStoppedByUser = false;
    private boolean reconnectionInProgress = false;
    private boolean autoPlayTracks = false;
    private boolean waitingForPlay = false;
    private VideoCapturer videoCapturer;
    private VideoTrack localVideoTrack;
    private Handler handler = new Handler();
    private WebSocketHandler wsHandler;
    private final ArrayList<PeerConnection.IceServer> iceServers = new ArrayList();
    private PermissionsHandler permissionsHandler;
    private final StatsCollector statsCollector = new StatsCollector();
    public static final String VIDEO_TRACK_ID = "ARDAMSv0";
    public static final String AUDIO_TRACK_ID = "ARDAMSa0";
    public static final String VIDEO_TRACK_TYPE = "video";
    private static final String VIDEO_CODEC_VP8 = "VP8";
    private static final String VIDEO_CODEC_VP9 = "VP9";
    private static final String VIDEO_CODEC_H264 = "H264";
    private static final String VIDEO_CODEC_H264_BASELINE = "H264 Baseline";
    private static final String VIDEO_CODEC_H264_HIGH = "H264 High";
    private static final String VIDEO_CODEC_AV1 = "AV1";
    private static final String AUDIO_CODEC_ISAC = "ISAC";
    private static final String VIDEO_CODEC_PARAM_START_BITRATE = "x-google-start-bitrate";
    private static final String VIDEO_FLEXFEC_FIELDTRIAL = "WebRTC-FlexFEC-03-Advertised/Enabled/WebRTC-FlexFEC-03/Enabled/";
    private static final String VIDEO_VP8_INTEL_HW_ENCODER_FIELDTRIAL = "WebRTC-IntelVP8/Enabled/";
    private static final String DISABLE_WEBRTC_AGC_FIELDTRIAL = "WebRTC-Audio-MinimizeResamplingOnMobile/Enabled/";
    private static final String AUDIO_CODEC_PARAM_BITRATE = "maxaveragebitrate";
    private static final String AUDIO_ECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    private static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    private static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    private static final int BPS_IN_KBPS = 1000;
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private Timer statsTimer;
    @Nullable
    private PeerConnectionFactory factory;
    private boolean requestExtendedRights = false;
    private final Map<String, PeerInfo> peers = new ConcurrentHashMap<String, PeerInfo>();
    @Nullable
    private AudioSource audioSource;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private VideoSource videoSource;
    private boolean preferIsac;
    private boolean videoCapturerStopped;
    private MediaConstraints audioConstraints;
    private MediaConstraints sdpMediaConstraints;
    private boolean isInitiator;
    private boolean renderVideo = true;
    @Nullable
    public RtpSender localVideoSender;
    @Nullable
    private AudioTrack localAudioTrack;
    @Nullable
    public JavaAudioDeviceModule adm;
    private WebRTCClientConfig config;
    private boolean removeVideoRotationExtension = true;
    private Handler peerReconnectionHandler = new Handler();
    private Handler publishReconnectionHandler = new Handler();
    private Handler playReconnectionHandler = new Handler();
    private Runnable peerReconnectorRunnable;
    private Runnable publishReconnectorRunnable;
    private Runnable playReconnectorRunnable;
    public static final long PEER_RECONNECTION_DELAY_MS = 3000L;
    public static final long PEER_RECONNECTION_RETRY_DELAY_MS = 10000L;
    boolean released = false;
    String roomId;

    public void createReconnectorRunnables() {
        this.publishReconnectorRunnable = () -> {
            if (this.released || this.streamStoppedByUser) {
                return;
            }
            this.publishReconnectionHandler.postDelayed(this.publishReconnectorRunnable, 10000L);
            for (PeerInfo peerInfo : this.peers.values()) {
                PeerConnection pc = peerInfo.peerConnection;
                if (pc != null && (pc.iceConnectionState() == PeerConnection.IceConnectionState.CHECKING || pc.iceConnectionState() == PeerConnection.IceConnectionState.CONNECTED || pc.iceConnectionState() == PeerConnection.IceConnectionState.COMPLETED)) continue;
                if (pc != null) {
                    pc.close();
                }
                this.config.webRTCListener.onReconnectionAttempt(peerInfo.id);
                if (!peerInfo.mode.equals((Object)Mode.PUBLISH)) continue;
                Log.d((String)TAG, (String)"Reconnect attempt for publish");
                this.wsHandler.stop(peerInfo.id);
                this.wsHandler.startPublish(peerInfo.id, peerInfo.token, peerInfo.videoCallEnabled, peerInfo.audioCallEnabled, peerInfo.subscriberId, peerInfo.subscriberCode, peerInfo.streamName, peerInfo.mainTrackId);
            }
        };
        this.playReconnectorRunnable = () -> {
            if (this.released || this.streamStoppedByUser) {
                return;
            }
            this.releaseRemoteRenderers();
            this.playReconnectionHandler.postDelayed(this.playReconnectorRunnable, 10000L);
            for (PeerInfo peerInfo : this.peers.values()) {
                PeerConnection pc = peerInfo.peerConnection;
                if (pc != null && (pc.iceConnectionState() == PeerConnection.IceConnectionState.CHECKING || pc.iceConnectionState() == PeerConnection.IceConnectionState.CONNECTED || pc.iceConnectionState() == PeerConnection.IceConnectionState.COMPLETED)) continue;
                if (pc != null) {
                    pc.close();
                }
                this.config.webRTCListener.onReconnectionAttempt(peerInfo.id);
                if (!peerInfo.mode.equals((Object)Mode.PLAY)) continue;
                Log.d((String)TAG, (String)"Reconnect attempt for play");
                this.play(peerInfo.id, peerInfo.token, null, peerInfo.subscriberId, peerInfo.subscriberCode, peerInfo.metaData);
            }
        };
        this.peerReconnectorRunnable = () -> {
            if (this.released || this.streamStoppedByUser) {
                return;
            }
            this.peerReconnectionHandler.postDelayed(this.peerReconnectorRunnable, 10000L);
            for (PeerInfo peerInfo : this.peers.values()) {
                PeerConnection pc = peerInfo.peerConnection;
                if (pc != null && (pc.iceConnectionState() == PeerConnection.IceConnectionState.CHECKING || pc.iceConnectionState() == PeerConnection.IceConnectionState.CONNECTED || pc.iceConnectionState() == PeerConnection.IceConnectionState.COMPLETED)) continue;
                if (pc != null) {
                    pc.close();
                }
                this.config.webRTCListener.onReconnectionAttempt(peerInfo.id);
                if (peerInfo.mode.equals((Object)Mode.PUBLISH)) {
                    Log.d((String)TAG, (String)"Reconnect attempt for publish");
                    this.wsHandler.stop(peerInfo.id);
                    this.wsHandler.startPublish(peerInfo.id, peerInfo.token, peerInfo.videoCallEnabled, peerInfo.audioCallEnabled, peerInfo.subscriberId, peerInfo.subscriberCode, peerInfo.streamName, peerInfo.mainTrackId);
                    continue;
                }
                if (peerInfo.mode.equals((Object)Mode.PLAY)) {
                    this.releaseRemoteRenderers();
                    Log.d((String)TAG, (String)"Reconnect attempt for play");
                    this.play(peerInfo.id, peerInfo.token, null, peerInfo.subscriberId, peerInfo.subscriberCode, peerInfo.metaData);
                    continue;
                }
                if (!peerInfo.mode.equals((Object)Mode.P2P)) continue;
                Log.d((String)TAG, (String)"Reconnect attempt for P2P");
                this.config.localVideoRenderer.setZOrderOnTop(true);
                this.join(peerInfo.id, peerInfo.token);
            }
        };
    }

    public WebRTCClient(WebRTCClientConfig config) {
        this.config = config;
        config.webRTCListener.setWebRTCClient(this);
        this.permissionsHandler = new PermissionsHandler(config.activity);
        this.mainHandler = new Handler(config.activity.getMainLooper());
        this.iceServers.add(PeerConnection.IceServer.builder(config.stunServerUri).createIceServer());
        if (config.initiateBeforeStream) {
            this.init();
        }
    }

    @Override
    public WebRTCClientConfig getConfig() {
        return this.config;
    }

    public SDPObserver getSdpObserver(String streamId) {
        return new SDPObserver(streamId);
    }

    @Override
    public void joinToConferenceRoom(String roomId, String streamId) {
        this.roomId = roomId;
        this.publish(streamId, "", true, true, "", "", "", roomId);
    }

    @Override
    public void joinToConferenceRoom(String roomId, String streamId, boolean videoCallEnabled, boolean audioCallEnabled, String token, String subscriberId, String subscriberCode, String streamName) {
        this.roomId = roomId;
        this.publish(streamId, token, videoCallEnabled, audioCallEnabled, subscriberId, subscriberCode, streamName, roomId);
    }

    @Override
    public void joinToConferenceRoom(String roomId) {
        this.roomId = roomId;
        this.play(roomId);
    }

    @Override
    public void leaveFromConference(String roomId) {
        String publishId = this.getPublishStreamId();
        if (publishId != null) {
            this.stop(publishId);
        }
        this.stop(roomId);
    }

    @Override
    public void getRoomInfo(String roomId, String streamId) {
        this.handler.post(() -> {
            if (this.wsHandler != null) {
                this.wsHandler.getRoomInfo(roomId, streamId);
            }
        });
    }

    @Override
    public void setRendererForVideoTrack(SurfaceViewRenderer renderer, VideoTrack videoTrack) {
        this.mainHandler.post(() -> {
            ProxyVideoSink remoteVideoSink = new ProxyVideoSink();
            if (renderer != null) {
                remoteVideoSink.setTarget(renderer);
                renderer.init(this.eglBase.getEglBaseContext(), null);
                renderer.setScalingType(this.config.scalingType);
                renderer.setEnableHardwareScaler(true);
                renderer.setTag(renderer.getId(), remoteVideoSink);
            }
            videoTrack.addSink(remoteVideoSink);
            this.remoteVideoSinks.add(remoteVideoSink);
        });
    }

    public void init() {
        if (!this.checkPermissions(this::init)) {
            return;
        }
        if (this.config.reconnectionEnabled) {
            this.createReconnectorRunnables();
        }
        this.initializeRenderers();
        this.initializeParameters();
        this.initializePeerConnectionFactory();
        if (this.config.videoCallEnabled) {
            this.initializeVideoCapturer();
        }
        this.initializeAudioManager();
        this.connectWebSocket();
        this.released = false;
    }

    public boolean checkPermissions(PermissionsHandler.PermissionCallback permissionCallback) {
        return this.permissionsHandler.checkAndRequestPermisssions(this.requestExtendedRights, permissionCallback);
    }

    public void initializeParameters() {
        if (this.config.videoSource.equals((Object)IWebRTCClient.StreamSource.SCREEN)) {
            DisplayMetrics displayMetrics = this.getDisplayMetrics();
            this.config.videoWidth = displayMetrics.widthPixels;
            this.config.videoHeight = displayMetrics.heightPixels;
        }
    }

    public void initializeRenderers() {
        if (this.eglBase == null) {
            this.eglBase = EglBase.create();
        }
        if (this.config.localVideoRenderer != null && this.localVideoSink.getTarget() == null) {
            this.config.localVideoRenderer.init(this.eglBase.getEglBaseContext(), null);
            this.config.localVideoRenderer.setScalingType(this.config.scalingType);
            this.config.localVideoRenderer.setZOrderMediaOverlay(true);
            this.config.localVideoRenderer.setEnableHardwareScaler(true);
            this.localVideoSink.setTarget(this.config.localVideoRenderer);
        }
    }

    public void initializePeerConnectionFactory() {
        if (this.factory != null) {
            return;
        }
        Log.d((String)TAG, (String)("Preferred video codec: " + WebRTCClient.getSdpVideoCodecName(this.config.videoCodec)));
        String fieldTrials = WebRTCClient.getFieldTrials(this.config.videoFlexfecEnabled, this.config.disableWebRtcAGCAndHPF);
        executor.execute(() -> {
            Log.d((String)TAG, (String)("Initialize WebRTC. Field trials: " + fieldTrials));
            PeerConnectionFactory.initialize(PeerConnectionFactory.InitializationOptions.builder((Context)this.config.activity).setFieldTrials(fieldTrials).setEnableInternalTracer(true).createInitializationOptions());
        });
        PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
        this.createPeerConnectionFactory(options);
    }

    public void initializeAudioManager() {
        if (this.config.audioCallEnabled && this.audioManager == null) {
            this.audioManager = AppRTCAudioManager.create(this.config.activity.getApplicationContext());
            Log.d((String)TAG, (String)"Starting the audio manager...");
            this.audioManager.start(this::onAudioManagerDevicesChanged);
        }
    }

    public void initializeVideoCapturer() {
        if (this.videoCapturer != null) {
            return;
        }
        if (this.config.videoCallEnabled) {
            this.videoCapturer = this.createVideoCapturer(this.config.videoSource);
        }
        executor.execute(() -> {
            this.createMediaConstraintsInternal();
            this.createVideoTrack(this.videoCapturer);
            this.createAudioTrack();
        });
    }

    public void setBitrate(int bitrate) {
        this.setVideoMaxBitrate(bitrate);
    }

    public void connectWebSocket() {
        if (this.wsHandler == null) {
            Log.i((String)TAG, (String)"WebsocketHandler is null and creating a new instance");
            this.wsHandler = new WebSocketHandler(this, this.handler);
            this.wsHandler.connect(this.config.serverUrl);
            if (this.config.reconnectionEnabled) {
                this.wsHandler.setupWsReconnection();
            }
        } else if (!this.wsHandler.isConnected()) {
            Log.i((String)TAG, (String)"WebSocketHandler already exists but not connected. Disconnecting and connect again.");
            this.wsHandler.disconnect(true);
            this.wsHandler.connect(this.config.serverUrl);
        }
    }

    public DisplayMetrics getDisplayMetrics() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)this.config.activity.getSystemService("window");
        windowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
        return displayMetrics;
    }

    @javax.annotation.Nullable
    public VideoCapturer createScreenCapturer() {
        return new ScreenCapturerAndroid(this.config.mediaProjectionIntent, new MediaProjection.Callback(){

            public void onStop() {
                WebRTCClient.this.reportError(WebRTCClient.this.getPublishStreamId(), WebRTCClient.USER_REVOKED_CAPTURE_SCREEN_PERMISSION);
            }
        });
    }

    @javax.annotation.Nullable
    public VideoCapturer createCameraCapturer(CameraEnumerator enumerator) {
        CameraVideoCapturer videoCapturer;
        String[] deviceNames = enumerator.getDeviceNames();
        if (this.config.videoSource == IWebRTCClient.StreamSource.FRONT_CAMERA) {
            Logging.d(TAG, "Looking for front facing cameras.");
            for (String deviceName : deviceNames) {
                if (!enumerator.isFrontFacing(deviceName)) continue;
                Logging.d(TAG, "Creating front facing camera capturer.");
                videoCapturer = enumerator.createCapturer(deviceName, null);
                if (videoCapturer == null) continue;
                return videoCapturer;
            }
        }
        Logging.d(TAG, "Looking for other cameras.");
        for (String deviceName : deviceNames) {
            if (enumerator.isFrontFacing(deviceName)) continue;
            Logging.d(TAG, "Creating other camera capturer.");
            videoCapturer = enumerator.createCapturer(deviceName, null);
            if (videoCapturer == null) continue;
            return videoCapturer;
        }
        Logging.d(TAG, "Looking for front facing cameras to open again.");
        for (String deviceName : deviceNames) {
            if (!enumerator.isFrontFacing(deviceName)) continue;
            Logging.d(TAG, "Creating front facing camera capturer.");
            videoCapturer = enumerator.createCapturer(deviceName, null);
            if (videoCapturer == null) continue;
            return videoCapturer;
        }
        return null;
    }

    @Override
    public void setSwappedFeeds(boolean isSwappedFeeds) {
        this.localVideoSink.setTarget(isSwappedFeeds ? (VideoSink)this.config.remoteVideoRenderers.get(0) : this.config.localVideoRenderer);
        this.remoteVideoSinks.get(0).setTarget(isSwappedFeeds ? this.config.localVideoRenderer : (VideoSink)this.config.remoteVideoRenderers.get(0));
        this.config.remoteVideoRenderers.get(0).setMirror(isSwappedFeeds);
        this.config.localVideoRenderer.setMirror(!isSwappedFeeds);
    }

    @Override
    public void stop(String streamId) {
        this.stop(streamId, true);
    }

    public void stop(String streamId, boolean byUser) {
        Log.i((String)this.getClass().getSimpleName(), (String)"Stopping stream");
        this.streamStoppedByUser = byUser;
        if (this.wsHandler != null && this.wsHandler.isConnected()) {
            this.wsHandler.stop(streamId);
        }
    }

    @Override
    public void switchCamera() {
        if (this.config.videoSource == IWebRTCClient.StreamSource.FRONT_CAMERA) {
            this.config.videoSource = IWebRTCClient.StreamSource.REAR_CAMERA;
        } else if (this.config.videoSource == IWebRTCClient.StreamSource.REAR_CAMERA) {
            this.config.videoSource = IWebRTCClient.StreamSource.FRONT_CAMERA;
        }
        executor.execute(this::switchCameraInternal);
    }

    @Override
    public void getBroadcastObject(String streamId) {
        if (this.wsHandler != null && this.wsHandler.isConnected()) {
            this.wsHandler.getBroadcastObject(streamId);
        }
    }

    @Override
    public void onWebSocketConnected() {
        Log.i((String)TAG, (String)"WebSocket connected.");
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onWebSocketConnected();
            }
        });
        this.publishPlayIfRequested();
    }

    private void publishPlayIfRequested() {
        if (this.wsHandler == null) {
            return;
        }
        for (Map.Entry<String, PeerInfo> entry : this.peers.entrySet()) {
            PeerInfo peerInfo = entry.getValue();
            Mode peerMode = peerInfo.mode;
            if (peerMode == Mode.PUBLISH && peerInfo.peerConnection == null) {
                Log.i((String)TAG, (String)("Processing publish request for peer streamId: " + peerInfo.id));
                this.wsHandler.startPublish(peerInfo.id, peerInfo.token, peerInfo.videoCallEnabled, peerInfo.audioCallEnabled, peerInfo.subscriberId, peerInfo.subscriberCode, peerInfo.streamName, peerInfo.mainTrackId);
            }
            if (peerMode != Mode.PLAY || peerInfo.peerConnection != null) continue;
            Log.i((String)TAG, (String)("Processing play request for peer streamId: " + peerInfo.id));
            this.wsHandler.startPlay(peerInfo.id, peerInfo.token, null, peerInfo.subscriberId, peerInfo.subscriberCode, peerInfo.metaData);
        }
    }

    @Override
    public void publish(String streamId) {
        this.publish(streamId, null, true, true, null, null, streamId, null);
    }

    @Override
    public void publish(String streamId, String token, boolean videoCallEnabled, boolean audioCallEnabled, String subscriberId, String subscriberCode, String streamName, String mainTrackId) {
        Log.i((String)TAG, (String)("Publish: " + streamId));
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onPublishAttempt(streamId);
            }
        });
        this.requestExtendedRights = true;
        this.createPeerInfo(streamId, token, videoCallEnabled, audioCallEnabled, subscriberId, subscriberCode, streamName, mainTrackId, null, Mode.PUBLISH);
        this.init();
        if (this.isWebSocketConnected()) {
            Log.i((String)TAG, (String)("Publish request sent through ws for stream: " + streamId));
            this.wsHandler.startPublish(streamId, token, videoCallEnabled, audioCallEnabled, subscriberId, subscriberCode, streamName, mainTrackId);
        } else {
            Log.w((String)TAG, (String)"Websocket is not connected. Set publish requested. It will be processed when ws is connected.");
        }
    }

    private void createPeerInfo(String streamId, String token, boolean videoCallEnabled, boolean audioCallEnabled, String subscriberId, String subscriberCode, String streamName, String mainTrackId, String metaData, Mode mode) {
        PeerInfo peerInfo = new PeerInfo(streamId, mode);
        peerInfo.token = token;
        peerInfo.videoCallEnabled = videoCallEnabled || this.config.videoCallEnabled;
        peerInfo.audioCallEnabled = audioCallEnabled || this.config.audioCallEnabled;
        peerInfo.subscriberId = subscriberId;
        peerInfo.subscriberCode = subscriberCode;
        peerInfo.streamName = streamName;
        peerInfo.mainTrackId = mainTrackId;
        peerInfo.metaData = metaData;
        this.peers.put(streamId, peerInfo);
    }

    @Override
    public void play(String streamId) {
        this.play(streamId, "", null, "", "", "");
    }

    @Override
    public void play(String streamId, String[] tracks) {
        this.play(streamId, "", tracks, "", "", "");
    }

    @Override
    public void play(String streamId, String token, String[] tracks, String subscriberId, String subscriberCode, String viewerInfo) {
        Log.i((String)TAG, (String)("Play: " + streamId));
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onPlayAttempt(streamId);
            }
        });
        this.createPeerInfo(streamId, token, false, false, subscriberId, subscriberCode, "", "", viewerInfo, Mode.PLAY);
        if (!this.isReconnectionInProgress()) {
            this.init();
        }
        if (this.isWebSocketConnected()) {
            Log.i((String)TAG, (String)("Play request sent through ws for stream: " + streamId));
            this.wsHandler.startPlay(streamId, token, tracks, subscriberId, subscriberCode, viewerInfo);
        } else {
            Log.w((String)TAG, (String)"Websocket is not connected. Set play requested. It will be processed when ws is connected.");
        }
    }

    @Override
    public void join(String streamId) {
        this.join(streamId, "");
    }

    public void join(String streamId, String token) {
        Log.e((String)TAG, (String)("Join: " + streamId));
        this.requestExtendedRights = true;
        PeerInfo peerInfo = new PeerInfo(streamId, Mode.P2P);
        peerInfo.token = token;
        this.peers.put(streamId, peerInfo);
        this.init();
        this.wsHandler.joinToPeer(streamId, token);
    }

    @Override
    public void getTrackList(String streamId, String token) {
        this.init();
        this.wsHandler.getTrackList(streamId, token);
    }

    @Override
    public void enableTrack(String streamId, String trackId, boolean enabled) {
        this.wsHandler.enableTrack(streamId, trackId, enabled);
    }

    private void callConnected(String streamId) {
        long delta = System.currentTimeMillis() - 0L;
        Log.i((String)TAG, (String)("Call connected: delay=" + delta + "ms"));
        this.enableStatsEvents(streamId, true, STAT_CALLBACK_PERIOD);
    }

    public void onAudioManagerDevicesChanged(AppRTCAudioManager.AudioDevice device, Set<AppRTCAudioManager.AudioDevice> availableDevices) {
        Log.d((String)TAG, (String)("onAudioManagerDevicesChanged: " + availableDevices + ", selected: " + (Object)((Object)device)));
        if (this.audioManager != null) {
            this.audioManager.selectAudioDevice(device);
        }
    }

    public void release(boolean closeWebsocket) {
        if (this.released) {
            return;
        }
        this.released = true;
        Log.i((String)this.getClass().getSimpleName(), (String)"Releasing resources");
        if (closeWebsocket && this.wsHandler != null) {
            this.wsHandler.disconnect(true);
            this.wsHandler.stopReconnector();
            this.wsHandler = null;
        }
        if (this.config.localVideoRenderer != null) {
            this.releaseRenderer(this.config.localVideoRenderer, this.localVideoTrack, this.localVideoSink);
        }
        for (SurfaceViewRenderer remoteVideoRenderer : this.config.remoteVideoRenderers) {
            if (remoteVideoRenderer.getTag() == null) continue;
            this.releaseRenderer(remoteVideoRenderer);
        }
        this.localVideoTrack = null;
        this.localAudioTrack = null;
        this.remoteVideoSinks.clear();
        this.mainHandler.post(() -> executor.execute(this::closeInternal));
        if (this.audioManager != null) {
            this.audioManager.stop();
            this.audioManager = null;
        }
    }

    public void releaseRenderer(SurfaceViewRenderer renderer, VideoTrack track, VideoSink sink) {
        this.mainHandler.post(() -> {
            VideoSink videoSink;
            VideoTrack videoTrack = track != null ? track : (VideoTrack)renderer.getTag();
            VideoSink videoSink2 = videoSink = sink != null ? sink : (VideoSink)renderer.getTag(renderer.getId());
            if (videoTrack != null && videoSink != null) {
                videoTrack.removeSink(videoSink);
            }
            renderer.clearAnimation();
            this.mainHandler.postAtFrontOfQueue(renderer::clearImage);
            this.mainHandler.post(() -> {
                renderer.release();
                renderer.setTag(null);
            });
        });
    }

    private void releaseRemoteRenderers() {
        for (SurfaceViewRenderer remoteVideoRenderer : this.config.remoteVideoRenderers) {
            if (remoteVideoRenderer.getTag() == null) continue;
            this.releaseRenderer(remoteVideoRenderer);
        }
    }

    public boolean isWebSocketConnected() {
        if (this.wsHandler == null) {
            return false;
        }
        return this.wsHandler.isConnected();
    }

    @Override
    public void releaseRenderer(SurfaceViewRenderer renderer) {
        this.releaseRenderer(renderer, null, null);
    }

    public void reportError(String streamId, String description) {
        this.handler.post(() -> {
            this.errorString = description;
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onError(description, streamId);
            }
        });
    }

    @Override
    public void changeVideoSource(IWebRTCClient.StreamSource newSource) {
        if (!this.config.videoSource.equals((Object)newSource)) {
            if (newSource.equals((Object)IWebRTCClient.StreamSource.SCREEN) && this.adm != null) {
                this.adm.setMediaProjection(this.config.mediaProjection);
            }
            VideoCapturer newVideoCapturer = this.createVideoCapturer(newSource);
            this.changeVideoCapturer(newVideoCapturer);
            this.config.videoSource = newSource;
        }
    }

    @javax.annotation.Nullable
    public VideoCapturer createVideoCapturer(IWebRTCClient.StreamSource source) {
        this.config.videoSource = source;
        VideoCapturer videoCapturer = IWebRTCClient.StreamSource.SCREEN.equals((Object)source) ? this.createScreenCapturer() : (IWebRTCClient.StreamSource.CUSTOM.equals((Object)source) ? this.createCustomVideoCapturer() : this.createCameraCapturer(new Camera2Enumerator((Context)this.config.activity)));
        if (videoCapturer == null) {
            this.reportError(this.getPublishStreamId(), "Failed to create capturer:" + (Object)((Object)source));
        }
        return videoCapturer;
    }

    @NonNull
    public VideoCapturer createCustomVideoCapturer() {
        return new CustomVideoCapturer();
    }

    public String getPublishStreamId() {
        for (PeerInfo peerInfo : this.peers.values()) {
            if (!peerInfo.mode.equals((Object)Mode.PUBLISH)) continue;
            return peerInfo.id;
        }
        return null;
    }

    public String getMultiTrackStreamId() {
        for (PeerInfo peerInfo : this.peers.values()) {
            if (!peerInfo.mode.equals((Object)Mode.MULTI_TRACK_PLAY)) continue;
            return peerInfo.id;
        }
        return null;
    }

    public void setWsHandler(WebSocketHandler wsHandler) {
        this.wsHandler = wsHandler;
    }

    @Override
    public String getError() {
        return this.errorString;
    }

    public void onLocalDescription(String streamId, SessionDescription sdp) {
        long delta = System.currentTimeMillis() - 0L;
        this.handler.post(() -> {
            if (this.wsHandler != null) {
                Log.d((String)TAG, (String)("Sending " + (Object)((Object)sdp.type) + ", delay=" + delta + "ms"));
                if (this.isInitiator) {
                    this.wsHandler.sendConfiguration(streamId, sdp, "offer");
                } else {
                    this.wsHandler.sendConfiguration(streamId, sdp, "answer");
                }
            }
            if (this.config.videoStartBitrate > 0) {
                Log.d((String)TAG, (String)("Set video maximum bitrate: " + this.config.videoStartBitrate));
                this.setVideoMaxBitrate(this.config.videoStartBitrate);
            }
        });
    }

    public void onIceConnected(String streamId) {
        long delta = System.currentTimeMillis() - 0L;
        this.handler.post(() -> {
            Log.d((String)TAG, (String)("ICE connected, delay=" + delta + "ms"));
            PeerInfo peerInfo = this.getPeerInfoFor(streamId);
            peerInfo.restartIce = false;
            this.callConnected(streamId);
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onIceConnected(streamId);
            }
        });
    }

    public void rePublishPlay() {
        if (this.streamStoppedByUser || this.reconnectionInProgress) {
            return;
        }
        this.reconnectionInProgress = true;
        if (this.isConference()) {
            Log.i((String)TAG, (String)"Conference! Will try to republish in  3000 ms.");
            this.publishReconnectionHandler.postDelayed(this.publishReconnectorRunnable, 3000L);
        } else {
            Log.i((String)TAG, (String)"Peer was connected before. Will try to republish/replay in 3000 ms.");
            this.peerReconnectionHandler.postDelayed(this.peerReconnectorRunnable, 3000L);
        }
    }

    public void onIceDisconnected(String streamId) {
        this.handler.post(() -> {
            Log.d((String)TAG, (String)"ICE disconnected");
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onIceDisconnected(streamId);
            }
            if (this.streamStoppedByUser) {
                this.release(true);
                return;
            }
            if (this.config.reconnectionEnabled) {
                this.rePublishPlay();
            }
            if (this.isConference()) {
                this.releaseRemoteRenderers();
            }
        });
    }

    private boolean isConference() {
        return this.roomId != null;
    }

    private boolean isAllPeersConnected() {
        for (Map.Entry<String, PeerInfo> entry : this.peers.entrySet()) {
            PeerConnection peerConnection = entry.getValue().peerConnection;
            if (peerConnection == null) {
                return false;
            }
            PeerConnection.PeerConnectionState peerConnectionState = peerConnection.connectionState();
            if (peerConnectionState == PeerConnection.PeerConnectionState.CONNECTED) continue;
            return false;
        }
        return true;
    }

    public void onIceFailed(String streamId) {
        PeerInfo peerInfo = this.getPeerInfoFor(streamId);
        this.handler.post(() -> {
            Log.d((String)TAG, (String)"ICE failed");
            peerInfo.restartIce = true;
            PeerConnection peerConnection = this.getPeerConnectionFor(streamId);
            if (peerConnection != null) {
                Log.d((String)TAG, (String)"Restarting ice.");
                peerConnection.restartIce();
            }
        });
    }

    private boolean isPublishConnected() {
        for (Map.Entry<String, PeerInfo> entry : this.peers.entrySet()) {
            PeerConnection peerConnection = entry.getValue().peerConnection;
            if (peerConnection == null) {
                return false;
            }
            PeerConnection.PeerConnectionState peerConnectionState = peerConnection.connectionState();
            if (entry.getValue().mode != Mode.PUBLISH || peerConnectionState == PeerConnection.PeerConnectionState.CONNECTED) continue;
            return false;
        }
        return true;
    }

    private boolean isPlayConnected() {
        for (Map.Entry<String, PeerInfo> entry : this.peers.entrySet()) {
            PeerConnection peerConnection = entry.getValue().peerConnection;
            if (peerConnection == null) {
                return false;
            }
            PeerConnection.PeerConnectionState peerConnectionState = peerConnection.connectionState();
            if (entry.getValue().mode != Mode.PLAY || peerConnectionState == PeerConnection.PeerConnectionState.CONNECTED) continue;
            return false;
        }
        return true;
    }

    public void onConnected(String streamId) {
        Log.i((String)TAG, (String)("Connected for streamId:" + streamId));
        if (this.config.reconnectionEnabled && this.reconnectionInProgress && this.isConference() && this.isPublishConnected() && !this.isPlayConnected()) {
            Log.i((String)TAG, (String)"Conference reconnection. Publish connected. Play not connected. Try to reconnect play.");
            this.publishReconnectionHandler.removeCallbacksAndMessages(null);
            this.playReconnectionHandler.postDelayed(this.playReconnectorRunnable, 3000L);
            return;
        }
        if (this.config.reconnectionEnabled && this.reconnectionInProgress && this.isAllPeersConnected()) {
            Log.i((String)TAG, (String)"All peers reconnected. Reconnection completed successfully.");
            this.reconnectionInProgress = false;
            this.peerReconnectionHandler.removeCallbacksAndMessages(null);
            this.publishReconnectionHandler.removeCallbacksAndMessages(null);
            this.playReconnectionHandler.removeCallbacksAndMessages(null);
            this.handler.post(() -> {
                if (this.config.webRTCListener != null) {
                    this.config.webRTCListener.onReconnectionSuccess();
                }
            });
        }
    }

    public void onPeerConnectionClosed() {
    }

    public void onPeerConnectionStatsReady(RTCStatsReport report) {
        this.handler.post(() -> this.statsCollector.onStatsReport(report));
    }

    @Override
    public boolean isStreaming(String streamId) {
        PeerConnection pc = this.getPeerConnectionFor(streamId);
        return pc != null && pc.iceConnectionState().equals((Object)PeerConnection.IceConnectionState.CONNECTED);
    }

    @Override
    public void onTakeConfiguration(String streamId, SessionDescription sdp) {
        this.handler.post(() -> {
            if (sdp.type == SessionDescription.Type.OFFER) {
                PeerConnection pc = this.getPeerConnectionFor(streamId);
                if (pc == null) {
                    this.createPeerConnection(streamId);
                }
                this.setRemoteDescription(streamId, sdp);
                this.createAnswer(streamId);
            } else {
                this.setRemoteDescription(streamId, sdp);
            }
        });
    }

    @Override
    public void onPublishFinished(String streamId) {
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onPublishFinished(streamId);
            }
        });
    }

    @Override
    public void onPlayFinished(String streamId) {
        this.waitingForPlay = false;
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onPlayFinished(streamId);
            }
        });
    }

    @Override
    public void onPublishStarted(String streamId) {
        Log.d((String)TAG, (String)"Publish started.");
        this.streamStoppedByUser = false;
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onPublishStarted(streamId);
            }
        });
    }

    @Override
    public void onPlayStarted(String streamId) {
        Log.d((String)TAG, (String)"Play started.");
        this.streamStoppedByUser = false;
        this.reconnectionInProgress = false;
        this.waitingForPlay = false;
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onPlayStarted(streamId);
            }
        });
    }

    @Override
    public void onStartStreaming(String streamId) {
        this.handler.post(() -> this.createPeerConnection(streamId));
    }

    @Override
    public void onJoinedTheRoom(String streamId, String[] streams) {
        this.config.webRTCListener.onJoinedTheRoom(streamId, streams);
    }

    @Override
    public void onRoomInformation(String[] streams) {
        this.config.webRTCListener.onRoomInformation(streams);
    }

    @Override
    public void noStreamExistsToPlay(String streamId) {
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.noStreamExistsToPlay(streamId);
            }
        });
    }

    @Override
    public void onLeftTheRoom(String roomId) {
        this.config.webRTCListener.onLeftTheRoom(roomId);
    }

    @Override
    public void onSessionRestored(String streamId) {
        this.streamStoppedByUser = false;
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onSessionRestored(streamId);
            }
        });
    }

    @Override
    public void onBroadcastObject(Broadcast broadcast) {
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onBroadcastObject(broadcast);
            }
        });
    }

    @Override
    public void streamIdInUse(String streamId) {
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.streamIdInUse(streamId);
            }
        });
    }

    @Override
    public void onRemoteIceCandidate(String streamId, IceCandidate candidate) {
        this.handler.post(() -> this.addRemoteIceCandidate(streamId, candidate));
    }

    @Override
    public void onWebSocketDisconnected() {
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onWebSocketDisconnected();
            }
        });
        this.onDisconnected();
    }

    @Deprecated
    public void onDisconnected() {
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onDisconnected();
            }
        });
    }

    @Override
    public void onTrackList(String[] tracks) {
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onTrackList(tracks);
            }
        });
        this.sendPlayOtherTracks(tracks);
    }

    public void sendPlayOtherTracks(String[] tracks) {
        if (this.autoPlayTracks && !this.isStreaming(this.getMultiTrackStreamId()) && !this.waitingForPlay) {
            this.waitingForPlay = true;
            this.init();
            for (int i = 0; i < tracks.length; ++i) {
                if (!tracks[i].equals(this.getPublishStreamId())) continue;
                tracks[i] = "!" + tracks[i];
                break;
            }
            this.play(this.getMultiTrackStreamId(), tracks);
        }
    }

    @Override
    public void onBitrateMeasurement(String streamId, int targetBitrate, int videoBitrate, int audioBitrate) {
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onBitrateMeasurement(streamId, targetBitrate, videoBitrate, audioBitrate);
            }
        });
    }

    @Override
    public void onStreamInfoList(String streamId, ArrayList<StreamInfo> streamInfoList) {
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onStreamInfoList(streamId, streamInfoList);
            }
        });
    }

    @Override
    public void onError(String streamId, String definition) {
        this.handler.post(() -> {
            if (this.config.webRTCListener != null) {
                this.config.webRTCListener.onError(definition, streamId);
            }
        });
        if (definition.equals("no_stream_exist")) {
            this.waitingForPlay = false;
        }
    }

    @Override
    public boolean isDataChannelEnabled() {
        return this.config.dataChannelEnabled;
    }

    @Override
    public void getStreamInfoList(String streamId) {
        this.wsHandler.getStreamInfoList(streamId);
    }

    @Override
    public void forceStreamQuality(String streamId, int height) {
        this.wsHandler.forceStreamQuality(streamId, height);
    }

    @Override
    public void sendMessageViaDataChannel(String streamId, DataChannel.Buffer buffer) {
        if (this.isDataChannelEnabled()) {
            executor.execute(() -> {
                block6: {
                    try {
                        PeerInfo peer = this.peers.get(streamId);
                        if (peer == null || peer.dataChannel == null) {
                            this.reportError(streamId, "Peer not found for sending message via Data Channel");
                            return;
                        }
                        boolean success = peer.dataChannel.send(buffer);
                        buffer.data.rewind();
                        if (this.config.dataChannelObserver != null) {
                            if (success) {
                                this.handler.post(() -> this.config.dataChannelObserver.onMessageSent(buffer, true));
                            } else {
                                this.handler.post(() -> this.config.dataChannelObserver.onMessageSent(buffer, false));
                                this.reportError(streamId, "Failed to send the message via Data Channel ");
                            }
                        }
                    }
                    catch (Exception e) {
                        this.reportError(streamId, "An error occurred when sending the message via Data Channel " + e.getMessage());
                        if (this.config.dataChannelObserver == null) break block6;
                        buffer.data.rewind();
                        this.handler.post(() -> this.config.dataChannelObserver.onMessageSent(buffer, false));
                    }
                }
            });
        } else {
            Log.w((String)TAG, (String)("Data Channel is not ready for usage for ." + streamId));
        }
    }

    public void changeVideoCapturer(VideoCapturer newVideoCapturer) {
        try {
            if (this.videoCapturer != null) {
                this.videoCapturer.stopCapture();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.videoCapturerStopped = true;
        this.videoCapturer = newVideoCapturer;
        this.localVideoTrack = null;
        VideoTrack newTrack = this.createVideoTrack(this.videoCapturer);
        if (this.localVideoSender != null) {
            this.localVideoSender.setTrack(newTrack, true);
        }
    }

    public void createPeerConnectionFactory(PeerConnectionFactory.Options options) {
        if (this.factory != null) {
            throw new IllegalStateException("PeerConnectionFactory has already been constructed");
        }
        executor.execute(() -> this.createPeerConnectionFactoryInternal(options));
    }

    public void createPeerConnection(String streamId) {
        executor.execute(() -> {
            try {
                this.createMediaConstraintsInternal();
                this.createPeerConnectionInternal(streamId);
            }
            catch (Exception e) {
                this.reportError(streamId, "Failed to create peer connection: " + e.getMessage());
                throw e;
            }
        });
    }

    private void createPeerConnectionFactoryInternal(PeerConnectionFactory.Options options) {
        VideoDecoderFactory decoderFactory;
        VideoEncoderFactory encoderFactory;
        this.preferIsac = this.config.audioCodec != null && this.config.audioCodec.equals(AUDIO_CODEC_ISAC);
        this.adm = (JavaAudioDeviceModule)this.createJavaAudioDevice();
        if (options != null) {
            Log.d((String)TAG, (String)("Factory networkIgnoreMask option: " + options.networkIgnoreMask));
        }
        boolean enableH264HighProfile = VIDEO_CODEC_H264_HIGH.equals(this.config.videoCodec);
        if (this.config.hwCodecAcceleration) {
            encoderFactory = new DefaultVideoEncoderFactory(this.eglBase.getEglBaseContext(), true, enableH264HighProfile);
            decoderFactory = new DefaultVideoDecoderFactory(this.eglBase.getEglBaseContext());
        } else {
            encoderFactory = new SoftwareVideoEncoderFactory();
            decoderFactory = new SoftwareVideoDecoderFactory();
        }
        this.factory = PeerConnectionFactory.builder().setOptions(options).setAudioDeviceModule(this.adm).setVideoEncoderFactory(encoderFactory).setVideoDecoderFactory(decoderFactory).createPeerConnectionFactory();
        Log.d((String)TAG, (String)"Peer connection factory created.");
        if (this.adm != null) {
            this.adm.release();
        }
    }

    public AudioDeviceModule createJavaAudioDevice() {
        JavaAudioDeviceModule.AudioRecordErrorCallback audioRecordErrorCallback = new JavaAudioDeviceModule.AudioRecordErrorCallback(){

            @Override
            public void onWebRtcAudioRecordInitError(String errorMessage) {
                Log.e((String)WebRTCClient.TAG, (String)("onWebRtcAudioRecordInitError: " + errorMessage));
                WebRTCClient.this.reportError(WebRTCClient.this.getPublishStreamId(), errorMessage);
            }

            @Override
            public void onWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode errorCode, String errorMessage) {
                Log.e((String)WebRTCClient.TAG, (String)("onWebRtcAudioRecordStartError: " + (Object)((Object)errorCode) + ". " + errorMessage));
                WebRTCClient.this.reportError(WebRTCClient.this.getPublishStreamId(), errorMessage);
            }

            @Override
            public void onWebRtcAudioRecordError(String errorMessage) {
                Log.e((String)WebRTCClient.TAG, (String)("onWebRtcAudioRecordError: " + errorMessage));
                WebRTCClient.this.reportError(WebRTCClient.this.getPublishStreamId(), errorMessage);
            }
        };
        JavaAudioDeviceModule.AudioTrackErrorCallback audioTrackErrorCallback = new JavaAudioDeviceModule.AudioTrackErrorCallback(){

            @Override
            public void onWebRtcAudioTrackInitError(String errorMessage) {
                Log.e((String)WebRTCClient.TAG, (String)("onWebRtcAudioTrackInitError: " + errorMessage));
                WebRTCClient.this.reportError(WebRTCClient.this.getPublishStreamId(), errorMessage);
            }

            @Override
            public void onWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode errorCode, String errorMessage) {
                Log.e((String)WebRTCClient.TAG, (String)("onWebRtcAudioTrackStartError: " + (Object)((Object)errorCode) + ". " + errorMessage));
                WebRTCClient.this.reportError(WebRTCClient.this.getPublishStreamId(), errorMessage);
            }

            @Override
            public void onWebRtcAudioTrackError(String errorMessage) {
                Log.e((String)WebRTCClient.TAG, (String)("onWebRtcAudioTrackError: " + errorMessage));
                WebRTCClient.this.reportError(WebRTCClient.this.getPublishStreamId(), errorMessage);
            }
        };
        JavaAudioDeviceModule.AudioRecordStateCallback audioRecordStateCallback = new JavaAudioDeviceModule.AudioRecordStateCallback(){

            @Override
            public void onWebRtcAudioRecordStart() {
                Log.i((String)WebRTCClient.TAG, (String)"Audio recording starts");
            }

            @Override
            public void onWebRtcAudioRecordStop() {
                Log.i((String)WebRTCClient.TAG, (String)"Audio recording stops");
            }
        };
        JavaAudioDeviceModule.AudioTrackStateCallback audioTrackStateCallback = new JavaAudioDeviceModule.AudioTrackStateCallback(){

            @Override
            public void onWebRtcAudioTrackStart() {
                Log.i((String)WebRTCClient.TAG, (String)"Audio playout starts");
            }

            @Override
            public void onWebRtcAudioTrackStop() {
                Log.i((String)WebRTCClient.TAG, (String)"Audio playout stops");
            }
        };
        JavaAudioDeviceModule.Builder admBuilder = this.getADMBuilder();
        return admBuilder.setCustomAudioFeed(this.config.customAudioFeed).setUseHardwareAcousticEchoCanceler(true).setUseHardwareNoiseSuppressor(true).setAudioRecordErrorCallback(audioRecordErrorCallback).setAudioTrackErrorCallback(audioTrackErrorCallback).setAudioRecordStateCallback(audioRecordStateCallback).setAudioTrackStateCallback(audioTrackStateCallback).createAudioDeviceModule();
    }

    public JavaAudioDeviceModule.Builder getADMBuilder() {
        return JavaAudioDeviceModule.builder((Context)this.config.activity);
    }

    public void createMediaConstraintsInternal() {
        this.audioConstraints = new MediaConstraints();
        if (this.config.noAudioProcessing) {
            Log.d((String)TAG, (String)"Disabling audio processing");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_ECHO_CANCELLATION_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_HIGH_PASS_FILTER_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
        }
        this.sdpMediaConstraints = new MediaConstraints();
        this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", Boolean.toString(this.config.videoCallEnabled)));
    }

    public void createPeerConnectionInternal(String streamId) {
        if (this.factory == null) {
            Log.e((String)TAG, (String)"Peer connection factory is not created");
            return;
        }
        Log.d((String)TAG, (String)"Create peer connection.");
        PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(this.iceServers);
        rtcConfig.tcpCandidatePolicy = PeerConnection.TcpCandidatePolicy.DISABLED;
        rtcConfig.bundlePolicy = PeerConnection.BundlePolicy.MAXBUNDLE;
        rtcConfig.rtcpMuxPolicy = PeerConnection.RtcpMuxPolicy.REQUIRE;
        rtcConfig.continualGatheringPolicy = PeerConnection.ContinualGatheringPolicy.GATHER_CONTINUALLY;
        rtcConfig.keyType = PeerConnection.KeyType.ECDSA;
        rtcConfig.sdpSemantics = PeerConnection.SdpSemantics.UNIFIED_PLAN;
        PeerConnection peerConnection = this.factory.createPeerConnection(rtcConfig, (PeerConnection.Observer)this.getPCObserver(streamId));
        if (peerConnection != null) {
            PeerInfo peer = this.peers.get(streamId);
            if (peer != null) {
                peer.peerConnection = peerConnection;
            } else {
                Log.e((String)TAG, (String)("Peer not found for streamId: " + streamId));
            }
            this.isInitiator = false;
            this.setWebRTCLogLevel();
            List<String> mediaStreamLabels = Collections.singletonList("ARDAMS");
            try {
                if (this.config.videoCallEnabled) {
                    peerConnection.addTrack(this.createVideoTrack(this.videoCapturer), mediaStreamLabels);
                }
                peerConnection.addTrack(this.createAudioTrack(), mediaStreamLabels);
            }
            catch (IllegalStateException e) {
                Log.e((String)TAG, (String)("Could not add track to PC. Is it in closed state? Peer connection state " + peerConnection.connectionState().name() + " Error message: " + e.getMessage()));
                return;
            }
            if (this.config.videoCallEnabled) {
                this.findVideoSender(streamId);
            }
            this.config.webRTCListener.onPeerConnectionCreated(streamId);
            Log.d((String)TAG, (String)"Peer connection created.");
        } else {
            Log.e((String)TAG, (String)"Peer connection is not created");
        }
    }

    public void setWebRTCLogLevel() {
        Logging.enableLogToDebugOutput(Logging.Severity.LS_ERROR);
    }

    @NonNull
    public PCObserver getPCObserver(String streamId) {
        return new PCObserver(streamId);
    }

    public void initDataChannel(String streamId) {
        if (this.config.dataChannelEnabled) {
            DataChannel.Init init = new DataChannel.Init();
            init.ordered = true;
            init.negotiated = false;
            init.maxRetransmits = -1;
            init.maxRetransmitTimeMs = -1;
            init.id = 1;
            init.protocol = "";
            PeerInfo peer = this.peers.get(streamId);
            if (peer != null && peer.peerConnection != null) {
                DataChannel dataChannel = peer.peerConnection.createDataChannel(streamId, init);
                if (dataChannel != null) {
                    dataChannel.registerObserver(new DataChannelInternalObserver(dataChannel));
                    peer.dataChannel = dataChannel;
                }
            } else {
                Log.e((String)TAG, (String)("Peer not found for streamId: " + streamId));
            }
        }
    }

    @Override
    public void setDegradationPreference(RtpParameters.DegradationPreference degradationPreference) {
        if (this.localVideoSender == null) {
            Log.w((String)TAG, (String)"Sender is not ready.");
            return;
        }
        executor.execute(() -> {
            RtpParameters newParameters = this.localVideoSender.getParameters();
            if (newParameters != null) {
                newParameters.degradationPreference = degradationPreference;
                this.localVideoSender.setParameters(newParameters);
            }
        });
    }

    public void closeInternal() {
        Log.d((String)TAG, (String)"Closing resources.");
        if (this.statsTimer != null) {
            this.statsTimer.cancel();
        }
        for (Map.Entry<String, PeerInfo> entry : this.peers.entrySet()) {
            Log.d((String)TAG, (String)("Closing peer connections for " + entry.getValue().id));
            PeerConnection peerConnection = entry.getValue().peerConnection;
            if (peerConnection != null) {
                peerConnection.dispose();
                entry.getValue().peerConnection = null;
            }
            Log.d((String)TAG, (String)("Closing data channels for " + entry.getValue().id));
            DataChannel dataChannel = entry.getValue().dataChannel;
            if (dataChannel == null) continue;
            dataChannel.dispose();
            entry.getValue().dataChannel = null;
        }
        if (this.streamStoppedByUser) {
            this.peers.clear();
        }
        Log.d((String)TAG, (String)"Closing audio source.");
        if (this.audioSource != null) {
            this.audioSource.dispose();
            this.audioSource = null;
        }
        Log.d((String)TAG, (String)"Stopping capture.");
        if (this.videoCapturer != null && !this.videoCapturerStopped) {
            try {
                this.videoCapturer.stopCapture();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.videoCapturerStopped = true;
        }
        Log.d((String)TAG, (String)"Closing video source.");
        if (this.videoSource != null) {
            this.videoSource.dispose();
            this.videoSource = null;
        }
        if (this.surfaceTextureHelper != null) {
            this.surfaceTextureHelper.dispose();
            this.surfaceTextureHelper = null;
        }
        Log.d((String)TAG, (String)"Closing peer connection factory.");
        if (this.factory != null) {
            this.factory.dispose();
            this.factory = null;
        }
        if (this.eglBase != null) {
            this.eglBase.release();
            this.eglBase = null;
        }
        this.localVideoSink.setTarget(null);
        Log.d((String)TAG, (String)"Closing peer connection done.");
        this.onPeerConnectionClosed();
        this.clearStatsCollector();
        this.reconnectionInProgress = false;
        this.peerReconnectionHandler.removeCallbacksAndMessages(null);
        this.publishReconnectionHandler.removeCallbacksAndMessages(null);
        this.playReconnectionHandler.removeCallbacksAndMessages(null);
    }

    private void clearStatsCollector() {
        this.statsCollector.getAudioTrackStatsMap().clear();
        this.statsCollector.getVideoTrackStatsMap().clear();
    }

    public void getStats(String streamId) {
        PeerConnection pc = this.getPeerConnectionFor(streamId);
        if (pc != null) {
            pc.getStats(this::onPeerConnectionStatsReady);
        }
    }

    @Override
    public StatsCollector getStatsCollector() {
        return this.statsCollector;
    }

    public void enableStatsEvents(final String streamId, boolean enable, int periodMs) {
        if (enable) {
            try {
                this.statsTimer = new Timer();
                this.statsTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        executor.execute(() -> WebRTCClient.this.getStats(streamId));
                    }
                }, 0L, (long)periodMs);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Can not schedule statistics timer", (Throwable)e);
            }
        } else {
            this.statsTimer.cancel();
        }
    }

    @Override
    public void setAudioEnabled(boolean enable) {
        this.config.audioCallEnabled = enable;
        executor.execute(() -> {
            if (this.localAudioTrack != null) {
                this.localAudioTrack.setEnabled(enable);
            }
        });
    }

    @Override
    public void setVideoEnabled(boolean enable) {
        this.config.videoCallEnabled = enable;
        executor.execute(() -> {
            this.renderVideo = enable;
            if (this.localVideoTrack != null) {
                if (enable) {
                    this.startVideoSourceInternal();
                } else {
                    this.stopVideoSourceInternal();
                }
                this.localVideoTrack.setEnabled(this.renderVideo);
            }
        });
    }

    public void createOffer(String streamId) {
        executor.execute(() -> {
            Log.d((String)TAG, (String)"Creating OFFER...");
            PeerConnection pc = this.getPeerConnectionFor(streamId);
            PeerInfo peerInfo = this.getPeerInfoFor(streamId);
            if (pc != null) {
                MediaConstraints sdpMediaConstraintsLocal;
                Log.d((String)TAG, (String)"PC Create OFFER");
                this.isInitiator = true;
                this.initDataChannel(streamId);
                if (peerInfo.restartIce) {
                    Log.d((String)TAG, (String)"RESTART ICE IS TRUE, WILL CREATE OFFER");
                    sdpMediaConstraintsLocal = new MediaConstraints();
                    sdpMediaConstraintsLocal.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
                    sdpMediaConstraintsLocal.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", Boolean.toString(this.config.videoCallEnabled)));
                    sdpMediaConstraintsLocal.mandatory.add(new MediaConstraints.KeyValuePair("IceRestart", "true"));
                } else {
                    sdpMediaConstraintsLocal = this.sdpMediaConstraints;
                }
                pc.createOffer(this.getSdpObserver(streamId), sdpMediaConstraintsLocal);
            }
        });
    }

    public void createAnswer(String streamId) {
        executor.execute(() -> {
            PeerConnection pc = this.getPeerConnectionFor(streamId);
            if (pc != null) {
                Log.d((String)TAG, (String)"PC create ANSWER");
                this.isInitiator = false;
                pc.createAnswer(this.getSdpObserver(streamId), this.sdpMediaConstraints);
            }
        });
    }

    public void addRemoteIceCandidate(String streamId, final IceCandidate candidate) {
        executor.execute(() -> {
            PeerInfo peerInfo = this.getPeerInfoFor(streamId);
            if (peerInfo == null) {
                return;
            }
            PeerConnection pc = peerInfo.peerConnection;
            if (pc != null) {
                List<IceCandidate> queuedRemoteCandidates = peerInfo.getQueuedRemoteCandidates();
                if (queuedRemoteCandidates != null) {
                    queuedRemoteCandidates.add(candidate);
                } else {
                    pc.addIceCandidate(candidate, new AddIceObserver(){

                        @Override
                        public void onAddSuccess() {
                            Log.d((String)WebRTCClient.TAG, (String)("Candidate " + candidate + " successfully added."));
                        }

                        @Override
                        public void onAddFailure(String error) {
                            Log.d((String)WebRTCClient.TAG, (String)("Candidate " + candidate + " addition failed: " + error));
                        }
                    });
                }
            }
        });
    }

    public void removeRemoteIceCandidates(String streamId, IceCandidate[] candidates) {
        executor.execute(() -> {
            PeerConnection pc = this.getPeerConnectionFor(streamId);
            if (pc != null) {
                this.drainCandidates(streamId);
                pc.removeIceCandidates(candidates);
            }
        });
    }

    public void setRemoteDescription(String streamId, SessionDescription desc) {
        executor.execute(() -> {
            PeerConnection pc = this.getPeerConnectionFor(streamId);
            if (pc == null) {
                return;
            }
            String sdp = desc.description;
            if (this.preferIsac) {
                sdp = WebRTCClient.preferCodec(sdp, AUDIO_CODEC_ISAC, true);
            }
            if (this.config.videoCallEnabled) {
                sdp = WebRTCClient.preferCodec(sdp, WebRTCClient.getSdpVideoCodecName(this.config.videoCodec), false);
            }
            if (this.config.videoStartBitrate > 0) {
                sdp = WebRTCClient.setStartBitrate(this.config.videoCodec, true, sdp, this.config.videoStartBitrate);
            }
            if (this.config.audioStartBitrate > 0) {
                sdp = WebRTCClient.setStartBitrate(this.config.audioCodec, false, sdp, this.config.audioStartBitrate);
            }
            Log.d((String)TAG, (String)"Set remote SDP.");
            SessionDescription sdpRemote = new SessionDescription(desc.type, sdp);
            pc.setRemoteDescription(this.getSdpObserver(streamId), sdpRemote);
        });
    }

    private void stopVideoSourceInternal() {
        if (this.videoCapturer != null && !this.videoCapturerStopped) {
            Log.d((String)TAG, (String)"Stop video source.");
            try {
                this.videoCapturer.stopCapture();
            }
            catch (InterruptedException e) {
                Log.d((String)TAG, (String)e.getMessage());
            }
            this.videoCapturerStopped = true;
        }
    }

    private void startVideoSourceInternal() {
        if (this.videoCapturer != null && this.videoCapturerStopped) {
            Log.d((String)TAG, (String)"Restart video source.");
            this.videoCapturer.startCapture(this.config.videoWidth, this.config.videoHeight, this.config.videoFps);
            this.videoCapturerStopped = false;
        }
    }

    public void setVideoMaxBitrate(@Nullable Integer maxBitrateKbps) {
        if (this.released) {
            return;
        }
        executor.execute(() -> {
            if (this.localVideoSender == null) {
                return;
            }
            Log.d((String)TAG, (String)("Requested max video bitrate: " + maxBitrateKbps));
            if (this.localVideoSender == null) {
                Log.w((String)TAG, (String)"Sender is not ready.");
                return;
            }
            RtpParameters parameters = this.localVideoSender.getParameters();
            if (parameters.encodings.isEmpty()) {
                Log.w((String)TAG, (String)"RtpParameters are not ready.");
                return;
            }
            for (RtpParameters.Encoding encoding : parameters.encodings) {
                encoding.maxBitrateBps = maxBitrateKbps == null ? null : Integer.valueOf(maxBitrateKbps * 1000);
                encoding.minBitrateBps = maxBitrateKbps == null ? null : Integer.valueOf(maxBitrateKbps * 1000 / 2);
            }
            if (!this.localVideoSender.setParameters(parameters)) {
                Log.e((String)TAG, (String)"RtpSender.setParameters failed.");
            }
            Log.d((String)TAG, (String)("Configured max video bitrate to: " + maxBitrateKbps));
        });
    }

    @Nullable
    public AudioTrack createAudioTrack() {
        if (this.localAudioTrack == null && this.factory != null) {
            this.audioSource = this.factory.createAudioSource(this.audioConstraints);
            this.localAudioTrack = this.factory.createAudioTrack(AUDIO_TRACK_ID, this.audioSource);
            this.localAudioTrack.setEnabled(this.config.audioCallEnabled);
        }
        return this.localAudioTrack;
    }

    @Nullable
    private VideoTrack createVideoTrack(VideoCapturer capturer) {
        if (this.localVideoTrack == null && capturer != null && this.factory != null) {
            this.surfaceTextureHelper = SurfaceTextureHelper.create("CaptureThread", this.eglBase.getEglBaseContext());
            this.videoSource = this.factory.createVideoSource(capturer.isScreencast());
            capturer.initialize(this.surfaceTextureHelper, (Context)this.config.activity, this.videoSource.getCapturerObserver());
            capturer.startCapture(this.config.videoWidth, this.config.videoHeight, this.config.videoFps);
            this.localVideoTrack = this.factory.createVideoTrack(VIDEO_TRACK_ID, this.videoSource);
            this.localVideoTrack.setEnabled(this.renderVideo);
            this.localVideoTrack.addSink(this.localVideoSink);
            this.videoCapturerStopped = false;
        }
        return this.localVideoTrack;
    }

    private void findVideoSender(String streamId) {
        PeerConnection pc = this.getPeerConnectionFor(streamId);
        if (pc != null) {
            for (RtpSender sender : pc.getSenders()) {
                String trackType;
                MediaStreamTrack track = sender.track();
                if (track == null || !(trackType = track.kind()).equals(VIDEO_TRACK_TYPE)) continue;
                Log.d((String)TAG, (String)"Found video sender.");
                this.localVideoSender = sender;
            }
        }
    }

    private static String getSdpVideoCodecName(String codec) {
        switch (codec) {
            case "VP8": {
                return VIDEO_CODEC_VP8;
            }
            case "VP9": {
                return VIDEO_CODEC_VP9;
            }
            case "AV1": {
                return VIDEO_CODEC_AV1;
            }
            case "H264 High": 
            case "H264 Baseline": {
                return VIDEO_CODEC_H264;
            }
        }
        return VIDEO_CODEC_VP8;
    }

    private static String getFieldTrials(Boolean videoFlexfecEnabled, boolean disableWebRtcAGCAndHPF) {
        String fieldTrials = "";
        if (videoFlexfecEnabled.booleanValue()) {
            fieldTrials = fieldTrials + VIDEO_FLEXFEC_FIELDTRIAL;
            Log.d((String)TAG, (String)"Enable FlexFEC field trial.");
        }
        fieldTrials = fieldTrials + VIDEO_VP8_INTEL_HW_ENCODER_FIELDTRIAL;
        if (disableWebRtcAGCAndHPF) {
            fieldTrials = fieldTrials + DISABLE_WEBRTC_AGC_FIELDTRIAL;
            Log.d((String)TAG, (String)"Disable WebRTC AGC field trial.");
        }
        return fieldTrials;
    }

    private static String setStartBitrate(String codec, boolean isVideoCodec, String sdp, int bitrateKbps) {
        Matcher codecMatcher;
        int i;
        String[] lines = sdp.split("\r\n");
        int rtpmapLineIndex = -1;
        boolean sdpFormatUpdated = false;
        String codecRtpMap = null;
        String regex = "^a=rtpmap:(\\d+) " + codec + "(/\\d+)+''?$";
        Pattern codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            codecRtpMap = codecMatcher.group(1);
            rtpmapLineIndex = i;
            break;
        }
        if (codecRtpMap == null) {
            Log.w((String)TAG, (String)("No rtpmap for " + codec + " codec"));
            return sdp;
        }
        Log.d((String)TAG, (String)("Found " + codec + " rtpmap " + codecRtpMap + " at " + lines[rtpmapLineIndex]));
        regex = "^a=fmtp:" + codecRtpMap + " \\w+=\\d+.*''?$";
        codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            Log.d((String)TAG, (String)("Found " + codec + " " + lines[i]));
            if (isVideoCodec) {
                int n = i;
                lines[n] = lines[n] + "; x-google-start-bitrate=" + bitrateKbps;
            } else {
                int n = i;
                lines[n] = lines[n] + "; maxaveragebitrate=" + bitrateKbps * 1000;
            }
            Log.d((String)TAG, (String)("Update remote SDP line: " + lines[i]));
            sdpFormatUpdated = true;
            break;
        }
        StringBuilder newSdpDescription = new StringBuilder();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            newSdpDescription.append(lines[i2]).append("\r\n");
            if (sdpFormatUpdated || i2 != rtpmapLineIndex) continue;
            String bitrateSet = isVideoCodec ? "a=fmtp:" + codecRtpMap + " " + VIDEO_CODEC_PARAM_START_BITRATE + "=" + bitrateKbps : "a=fmtp:" + codecRtpMap + " " + AUDIO_CODEC_PARAM_BITRATE + "=" + bitrateKbps * 1000;
            Log.d((String)TAG, (String)("Add remote SDP line: " + bitrateSet));
            newSdpDescription.append(bitrateSet).append("\r\n");
        }
        return newSdpDescription.toString();
    }

    private static int findMediaDescriptionLine(boolean isAudio, String[] sdpLines) {
        String mediaDescription = isAudio ? "m=audio " : "m=video ";
        for (int i = 0; i < sdpLines.length; ++i) {
            if (!sdpLines[i].startsWith(mediaDescription)) continue;
            return i;
        }
        return -1;
    }

    private static String joinString(Iterable<? extends CharSequence> s, String delimiter, boolean delimiterAtEnd) {
        Iterator<? extends CharSequence> iter = s.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            buffer.append(delimiter).append(iter.next());
        }
        if (delimiterAtEnd) {
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    @Nullable
    private static String movePayloadTypesToFront(List<String> preferredPayloadTypes, String mLine) {
        List<String> origLineParts = Arrays.asList(mLine.split(" "));
        if (origLineParts.size() <= 3) {
            Log.e((String)TAG, (String)("Wrong SDP media description format: " + mLine));
            return null;
        }
        List<String> header = origLineParts.subList(0, 3);
        ArrayList<String> unpreferredPayloadTypes = new ArrayList<String>(origLineParts.subList(3, origLineParts.size()));
        unpreferredPayloadTypes.removeAll(preferredPayloadTypes);
        ArrayList<String> newLineParts = new ArrayList<String>();
        newLineParts.addAll(header);
        newLineParts.addAll(preferredPayloadTypes);
        newLineParts.addAll(unpreferredPayloadTypes);
        return WebRTCClient.joinString(newLineParts, " ", false);
    }

    private static String preferCodec(String sdp, String codec, boolean isAudio) {
        String[] lines = sdp.split("\r\n");
        int mLineIndex = WebRTCClient.findMediaDescriptionLine(isAudio, lines);
        if (mLineIndex == -1) {
            Log.w((String)TAG, (String)("No mediaDescription line, so can't prefer " + codec));
            return sdp;
        }
        ArrayList<String> codecPayloadTypes = new ArrayList<String>();
        Pattern codecPattern = Pattern.compile("^a=rtpmap:(\\d+) " + codec + "(/\\d+)+''?$");
        for (String line : lines) {
            Matcher codecMatcher = codecPattern.matcher(line);
            if (!codecMatcher.matches()) continue;
            codecPayloadTypes.add(codecMatcher.group(1));
        }
        if (codecPayloadTypes.isEmpty()) {
            Log.w((String)TAG, (String)("No payload types with name " + codec));
            return sdp;
        }
        String newMLine = WebRTCClient.movePayloadTypesToFront(codecPayloadTypes, lines[mLineIndex]);
        if (newMLine == null) {
            return sdp;
        }
        Log.d((String)TAG, (String)("Change media description from: " + lines[mLineIndex] + " to " + newMLine));
        lines[mLineIndex] = newMLine;
        return WebRTCClient.joinString(Arrays.asList(lines), "\r\n", true);
    }

    private void drainCandidates(String streamId) {
        PeerInfo peerInfo = this.getPeerInfoFor(streamId);
        if (peerInfo == null || peerInfo.getQueuedRemoteCandidates() == null) {
            return;
        }
        List<IceCandidate> queuedRemoteCandidates = peerInfo.getQueuedRemoteCandidates();
        Log.d((String)TAG, (String)("Add " + queuedRemoteCandidates.size() + " remote candidates"));
        for (final IceCandidate candidate : queuedRemoteCandidates) {
            PeerConnection pc = this.getPeerConnectionFor(streamId);
            if (pc == null) continue;
            pc.addIceCandidate(candidate, new AddIceObserver(){

                @Override
                public void onAddSuccess() {
                    Log.d((String)WebRTCClient.TAG, (String)("Candidate " + candidate + " successfully added."));
                }

                @Override
                public void onAddFailure(String error) {
                    Log.d((String)WebRTCClient.TAG, (String)("Candidate " + candidate + " addition failed: " + error));
                }
            });
        }
        peerInfo.setQueuedRemoteCandidates(null);
    }

    private PeerConnection getPeerConnectionFor(String streamId) {
        PeerInfo peer = this.peers.get(streamId);
        if (peer != null) {
            return peer.peerConnection;
        }
        return null;
    }

    private PeerInfo getPeerInfoFor(String streamId) {
        return this.peers.get(streamId);
    }

    private void switchCameraInternal() {
        if (this.videoCapturer instanceof CameraVideoCapturer) {
            if (!this.config.videoCallEnabled) {
                Log.e((String)TAG, (String)("Failed to switch camera. Video: " + this.config.videoCallEnabled));
                return;
            }
            Log.d((String)TAG, (String)"Switch camera");
            CameraVideoCapturer cameraVideoCapturer = (CameraVideoCapturer)this.videoCapturer;
            cameraVideoCapturer.switchCamera(null);
        } else {
            Log.d((String)TAG, (String)"Will not switch camera, video caputurer is not a camera");
        }
    }

    @Override
    public void changeCaptureFormat(int width, int height, int framerate) {
        if (!this.config.videoCallEnabled || this.videoSource == null) {
            Log.e((String)TAG, (String)("Failed to change capture format. Video: " + this.config.videoCallEnabled));
            return;
        }
        Log.d((String)TAG, (String)("changeCaptureFormat: " + width + "x" + height + "@" + framerate));
        this.videoSource.adaptOutputFormat(width, height, framerate);
    }

    public void addPeerConnection(String streamId, @Nullable PeerConnection peerConnection) {
        PeerInfo peerInfo = new PeerInfo(streamId, Mode.PLAY);
        peerInfo.peerConnection = peerConnection;
        this.peers.put(streamId, peerInfo);
    }

    public List<ProxyVideoSink> getRemoteVideoSinks() {
        return this.remoteVideoSinks;
    }

    public void setInitiator(boolean initiator) {
        this.isInitiator = initiator;
    }

    @Override
    public void toggleAudioOfAllParticipants(boolean enabled) {
        for (Map.Entry<String, PeerInfo> entry : this.peers.entrySet()) {
            PeerConnection peerConnection = entry.getValue().peerConnection;
            if (peerConnection == null) continue;
            List<RtpReceiver> receivers = peerConnection.getReceivers();
            for (RtpReceiver receiver : receivers) {
                MediaStreamTrack track = receiver.track();
                if (track == null || !track.kind().equals("audio")) continue;
                AudioTrack audioTrack = (AudioTrack)track;
                audioTrack.setEnabled(enabled);
            }
        }
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setAutoPlayTracks(boolean autoPlayTracks) {
        this.autoPlayTracks = autoPlayTracks;
    }

    @Override
    public boolean isReconnectionInProgress() {
        return this.reconnectionInProgress;
    }

    @Override
    public CustomWebRtcAudioRecord getAudioInput() {
        if (this.adm != null) {
            return this.adm.getAudioInput();
        }
        return null;
    }

    @Override
    public VideoCapturer getVideoCapturer() {
        return this.videoCapturer;
    }

    public void setRemoveVideoRotationExtension(boolean removeVideoRotationExtension) {
        this.removeVideoRotationExtension = removeVideoRotationExtension;
    }

    public void setDataChannelEnabled(boolean dataChannelEnabled) {
        this.config.dataChannelEnabled = dataChannelEnabled;
    }

    public void setFactory(@Nullable PeerConnectionFactory factory) {
        this.factory = factory;
    }

    public void setPermissionsHandlerForTest(PermissionsHandler permissionsHandler) {
        this.permissionsHandler = permissionsHandler;
    }

    public Map<String, PeerInfo> getPeersForTest() {
        return this.peers;
    }

    public boolean isStreamStoppedByUser() {
        return this.streamStoppedByUser;
    }

    public void setStreamStoppedByUser(boolean streamStoppedByUser) {
        this.streamStoppedByUser = streamStoppedByUser;
    }

    public Handler getPeerReconnectionHandler() {
        return this.peerReconnectionHandler;
    }

    public void setPeerReconnectionHandler(Handler peerReconnectionHandler) {
        this.peerReconnectionHandler = peerReconnectionHandler;
    }

    class DataChannelInternalObserver
    implements DataChannel.Observer {
        private final DataChannel dataChannel;

        DataChannelInternalObserver(DataChannel dataChannel) {
            this.dataChannel = dataChannel;
        }

        @Override
        public void onBufferedAmountChange(long previousAmount) {
            if (((WebRTCClient)WebRTCClient.this).config.dataChannelObserver == null) {
                return;
            }
            WebRTCClient.this.handler.post(() -> {
                if (this.dataChannel != null) {
                    Log.d((String)WebRTCClient.TAG, (String)("Data channel buffered amount changed: " + this.dataChannel.label() + ": " + (Object)((Object)this.dataChannel.state())));
                    try {
                        ((WebRTCClient)WebRTCClient.this).config.dataChannelObserver.onBufferedAmountChange(previousAmount, this.dataChannel.label());
                    }
                    catch (IllegalStateException e) {
                        Log.e((String)WebRTCClient.TAG, (String)("Data channel related error:" + e.getMessage()));
                    }
                }
            });
        }

        @Override
        public void onStateChange() {
            WebRTCClient.this.handler.post(() -> {
                if (((WebRTCClient)WebRTCClient.this).config.dataChannelObserver != null && this.dataChannel != null) {
                    try {
                        ((WebRTCClient)WebRTCClient.this).config.dataChannelObserver.onStateChange(this.dataChannel.state(), this.dataChannel.label());
                    }
                    catch (IllegalStateException e) {
                        Log.e((String)WebRTCClient.TAG, (String)("Data channel related error:" + e.getMessage()));
                    }
                }
            });
        }

        @Override
        public void onMessage(DataChannel.Buffer buffer) {
            ByteBuffer copyByteBuffer = ByteBuffer.allocate(buffer.data.capacity());
            copyByteBuffer.put(buffer.data);
            copyByteBuffer.rewind();
            boolean binary = buffer.binary;
            DataChannel.Buffer bufferCopy = new DataChannel.Buffer(copyByteBuffer, binary);
            WebRTCClient.this.handler.post(() -> {
                if (((WebRTCClient)WebRTCClient.this).config.dataChannelObserver == null || this.dataChannel == null) {
                    return;
                }
                try {
                    ((WebRTCClient)WebRTCClient.this).config.dataChannelObserver.onMessage(bufferCopy, this.dataChannel.label());
                }
                catch (IllegalStateException e) {
                    Log.e((String)WebRTCClient.TAG, (String)("Data channel related error:" + e.getMessage()));
                }
            });
        }
    }

    public class SDPObserver
    implements SdpObserver {
        private final String streamId;

        SDPObserver(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public void onCreateSuccess(SessionDescription desc) {
            String sdp = desc.description;
            if (WebRTCClient.this.preferIsac) {
                sdp = WebRTCClient.preferCodec(sdp, WebRTCClient.AUDIO_CODEC_ISAC, true);
            }
            if (((WebRTCClient)WebRTCClient.this).config.videoCallEnabled) {
                sdp = WebRTCClient.preferCodec(sdp, WebRTCClient.getSdpVideoCodecName(((WebRTCClient)WebRTCClient.this).config.videoCodec), false);
            }
            if (WebRTCClient.this.removeVideoRotationExtension) {
                sdp = sdp.replace(WebRTCClient.VIDEO_ROTATION_EXT_LINE, "");
            }
            SessionDescription newDesc = new SessionDescription(desc.type, sdp);
            PeerInfo peerInfo = WebRTCClient.this.getPeerInfoFor(this.streamId);
            peerInfo.setLocalDescription(newDesc);
            executor.execute(() -> {
                PeerConnection pc = peerInfo.peerConnection;
                if (pc != null) {
                    Log.d((String)WebRTCClient.TAG, (String)("Set local SDP from " + (Object)((Object)desc.type)));
                    pc.setLocalDescription(this, newDesc);
                }
            });
        }

        @Override
        public void onSetSuccess() {
            Log.i((String)WebRTCClient.TAG, (String)"onSetSuccess: ");
            executor.execute(() -> {
                PeerInfo peerInfo = WebRTCClient.this.getPeerInfoFor(this.streamId);
                if (peerInfo == null) {
                    return;
                }
                PeerConnection pc = peerInfo.peerConnection;
                if (pc == null) {
                    return;
                }
                if (WebRTCClient.this.isInitiator) {
                    if (pc.getRemoteDescription() == null) {
                        Log.d((String)WebRTCClient.TAG, (String)"Local SDP set succesfully");
                        WebRTCClient.this.onLocalDescription(this.streamId, peerInfo.getLocalDescription());
                    } else {
                        Log.d((String)WebRTCClient.TAG, (String)"Remote SDP set succesfully");
                        WebRTCClient.this.drainCandidates(this.streamId);
                    }
                } else if (pc.getLocalDescription() != null) {
                    Log.d((String)WebRTCClient.TAG, (String)"Local SDP set succesfully");
                    WebRTCClient.this.onLocalDescription(this.streamId, peerInfo.getLocalDescription());
                    WebRTCClient.this.drainCandidates(this.streamId);
                } else {
                    Log.d((String)WebRTCClient.TAG, (String)"Remote SDP set succesfully");
                }
            });
        }

        @Override
        public void onCreateFailure(String error) {
            WebRTCClient.this.reportError(this.streamId, "createSDP error: " + error);
        }

        @Override
        public void onSetFailure(String error) {
            WebRTCClient.this.reportError(this.streamId, "setSDP error: " + error);
        }
    }

    public class PCObserver
    implements PeerConnection.Observer {
        private final String streamId;

        PCObserver(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public void onIceCandidate(IceCandidate candidate) {
            executor.execute(() -> WebRTCClient.this.handler.post(() -> {
                if (WebRTCClient.this.wsHandler != null) {
                    WebRTCClient.this.wsHandler.sendLocalIceCandidate(this.streamId, candidate);
                }
            }));
        }

        @Override
        public void onIceCandidateError(IceCandidateErrorEvent event) {
            Log.d((String)WebRTCClient.TAG, (String)("IceCandidateError address: " + event.address + ", port: " + event.port + ", url: " + event.url + ", errorCode: " + event.errorCode + ", errorText: " + event.errorText));
        }

        @Override
        public void onIceCandidatesRemoved(IceCandidate[] candidates) {
            executor.execute(() -> {});
        }

        @Override
        public void onSignalingChange(PeerConnection.SignalingState newState) {
            Log.d((String)WebRTCClient.TAG, (String)("SignalingState: " + (Object)((Object)newState)));
        }

        @Override
        public void onIceConnectionChange(PeerConnection.IceConnectionState newState) {
            executor.execute(() -> {
                Log.d((String)WebRTCClient.TAG, (String)("IceConnectionState: " + (Object)((Object)newState)));
                if (newState == PeerConnection.IceConnectionState.CONNECTED) {
                    WebRTCClient.this.onIceConnected(this.streamId);
                } else if (newState == PeerConnection.IceConnectionState.DISCONNECTED || newState == PeerConnection.IceConnectionState.CLOSED) {
                    WebRTCClient.this.onIceDisconnected(this.streamId);
                } else if (newState == PeerConnection.IceConnectionState.FAILED) {
                    WebRTCClient.this.onIceFailed(this.streamId);
                }
            });
        }

        @Override
        public void onConnectionChange(PeerConnection.PeerConnectionState newState) {
            executor.execute(() -> {
                Log.d((String)WebRTCClient.TAG, (String)("PeerConnectionState: " + (Object)((Object)newState)));
                if (newState == PeerConnection.PeerConnectionState.CONNECTED) {
                    WebRTCClient.this.onConnected(this.streamId);
                } else if (newState == PeerConnection.PeerConnectionState.DISCONNECTED) {
                    WebRTCClient.this.onDisconnected();
                } else if (newState == PeerConnection.PeerConnectionState.FAILED) {
                    WebRTCClient.this.reportError(this.streamId, "DTLS connection failed.");
                }
            });
        }

        @Override
        public void onIceGatheringChange(PeerConnection.IceGatheringState newState) {
            Log.d((String)WebRTCClient.TAG, (String)("IceGatheringState: " + (Object)((Object)newState)));
        }

        @Override
        public void onIceConnectionReceivingChange(boolean receiving) {
            Log.d((String)WebRTCClient.TAG, (String)("IceConnectionReceiving changed to " + receiving));
        }

        @Override
        public void onSelectedCandidatePairChanged(CandidatePairChangeEvent event) {
            Log.d((String)WebRTCClient.TAG, (String)("Selected candidate pair changed because: " + event));
        }

        @Override
        public void onAddStream(MediaStream stream) {
        }

        @Override
        public void onRemoveStream(MediaStream stream) {
        }

        @Override
        public void onDataChannel(DataChannel dc) {
            Log.d((String)WebRTCClient.TAG, (String)("New Data channel " + dc.label()));
            if (!((WebRTCClient)WebRTCClient.this).config.dataChannelEnabled) {
                return;
            }
            PeerInfo peerInfo = (PeerInfo)WebRTCClient.this.peers.get(this.streamId);
            if (peerInfo != null && peerInfo.dataChannel == null) {
                peerInfo.dataChannel = dc;
            }
            dc.registerObserver(new DataChannelInternalObserver(dc));
        }

        @Override
        public void onRenegotiationNeeded() {
            Log.d((String)WebRTCClient.TAG, (String)"Renegotiation needed.");
            PeerInfo peerInfo = WebRTCClient.this.getPeerInfoFor(this.streamId);
            if (peerInfo != null && ((WebRTCClient)WebRTCClient.this).getPeerInfoFor((String)this.streamId).mode == Mode.PUBLISH) {
                WebRTCClient.this.createOffer(this.streamId);
            }
        }

        @Override
        public void onAddTrack(RtpReceiver receiver, MediaStream[] mediaStreams) {
            MediaStreamTrack addedTrack = receiver.track();
            if (addedTrack == null) {
                return;
            }
            String receiverId = receiver.id();
            String streamId = receiverId.substring("ARDAMSX".length());
            Log.d((String)WebRTCClient.TAG, (String)("onAddTrack " + addedTrack.kind() + " " + addedTrack.id() + " " + (Object)((Object)addedTrack.state())));
            if (addedTrack instanceof VideoTrack) {
                VideoTrack videoTrack = (VideoTrack)addedTrack;
                ((WebRTCClient)WebRTCClient.this).config.webRTCListener.onNewVideoTrack(videoTrack, streamId);
            }
        }

        @Override
        public void onRemoveTrack(RtpReceiver receiver) {
            MediaStreamTrack removedTrack = receiver.track();
            if (removedTrack == null) {
                return;
            }
            Log.d((String)"antmedia", (String)("on remove track " + removedTrack.kind() + " " + removedTrack.id() + " " + (Object)((Object)removedTrack.state())));
            if (removedTrack instanceof VideoTrack) {
                ((WebRTCClient)WebRTCClient.this).config.webRTCListener.onVideoTrackEnded((VideoTrack)removedTrack);
            }
        }
    }

    public static class PeerInfo {
        public SessionDescription localDescription;
        private List<IceCandidate> queuedRemoteCandidates = new ArrayList<IceCandidate>();
        public String id;
        public PeerConnection peerConnection;
        public DataChannel dataChannel;
        public Mode mode;
        public String token;
        public boolean videoCallEnabled;
        public boolean audioCallEnabled;
        public String subscriberId;
        public String subscriberCode;
        public String streamName;
        public String mainTrackId;
        public String metaData;
        public boolean restartIce = false;

        public PeerInfo(String id, Mode mode) {
            this.id = id;
            this.mode = mode;
        }

        public SessionDescription getLocalDescription() {
            return this.localDescription;
        }

        public void setLocalDescription(SessionDescription localDescription) {
            this.localDescription = localDescription;
        }

        public List<IceCandidate> getQueuedRemoteCandidates() {
            return this.queuedRemoteCandidates;
        }

        public void setQueuedRemoteCandidates(List<IceCandidate> queuedRemoteCandidates) {
            this.queuedRemoteCandidates = queuedRemoteCandidates;
        }
    }

    public static enum Mode {
        PUBLISH,
        PLAY,
        P2P,
        MULTI_TRACK_PLAY;

    }
}

