/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtcandroidframework.utility;

import android.app.Activity;
import android.content.Context;
import android.media.AudioRecord;
import androidx.core.app.ActivityCompat;
import io.antmedia.webrtcandroidframework.utility.LocalAudioLevelListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SoundMeter {
    private final int SAMPLE_RATE = 44100;
    private final int CHANNEL_CONFIG = 16;
    private final int AUDIO_FORMAT = 2;
    private final int BUFFER_SIZE = AudioRecord.getMinBufferSize((int)44100, (int)16, (int)2);
    private Activity activity;
    private AudioRecord audioRecord;
    private ScheduledExecutorService executorService;
    private long updateAudioLevelFrequencyMs = 250L;
    private LocalAudioLevelListener audioLevelListener;

    public SoundMeter(long updateAudioLevelFrequencyMs, Activity activity, LocalAudioLevelListener listener) {
        this.activity = activity;
        this.audioLevelListener = listener;
        this.updateAudioLevelFrequencyMs = updateAudioLevelFrequencyMs;
        this.init();
    }

    private void init() {
        if (ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.RECORD_AUDIO") != 0) {
            throw new SecurityException("RECORD_AUDIO permission not granted.");
        }
        this.setAudioRecord(new AudioRecord(1, 44100, 16, 2, this.BUFFER_SIZE));
    }

    public void start() {
        if (this.audioRecord.getState() == 1) {
            this.audioRecord.startRecording();
            this.executorService = Executors.newScheduledThreadPool(1);
            this.executorService.scheduleAtFixedRate(() -> {
                short[] buffer = new short[this.BUFFER_SIZE / 2];
                int numSamples = this.audioRecord.read(buffer, 0, buffer.length);
                if (numSamples > 0) {
                    double rms = this.calculateRMS(buffer, numSamples);
                    double db = 20.0 * Math.log10(rms);
                    this.audioLevelListener.onAudioLevelUpdated(db);
                }
            }, 0L, this.updateAudioLevelFrequencyMs, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.audioRecord != null) {
            if (this.audioRecord.getState() == 1) {
                this.audioRecord.stop();
            }
            this.audioRecord.release();
            this.audioRecord = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    public double calculateRMS(short[] audioData, int numSamples) {
        double sum = 0.0;
        for (int i = 0; i < numSamples; ++i) {
            sum += (double)(audioData[i] * audioData[i]);
        }
        double mean = sum / (double)numSamples;
        return Math.sqrt(mean);
    }

    public void setAudioRecord(AudioRecord audioRecord) {
        this.audioRecord = audioRecord;
    }
}

