/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtcandroidframework.websocket;

import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.tavendo.autobahn.WebSocket;
import de.tavendo.autobahn.WebSocketConnection;
import de.tavendo.autobahn.WebSocketException;
import io.antmedia.webrtcandroidframework.core.StreamInfo;
import io.antmedia.webrtcandroidframework.websocket.AntMediaSignallingEvents;
import io.antmedia.webrtcandroidframework.websocket.Broadcast;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.IceCandidate;
import org.webrtc.SessionDescription;

public class WebSocketHandler
implements WebSocket.WebSocketConnectionObserver {
    private static final String TAG = "WebSocketHandler";
    private static final int CLOSE_TIMEOUT = 1000;
    private WebSocketConnection ws;
    private final Handler handler;
    private String wsServerUrl;
    private final Object closeEventLock = new Object();
    private boolean closeEvent;
    private AntMediaSignallingEvents signallingListener;
    public ScheduledExecutorService pingPongExecutor;
    private int pingPongTimoutCount = 0;
    public static final long TIMER_DELAY = 3000L;
    public static final long TIMER_PERIOD = 2000L;
    public static final long WEBSOCKET_RECONNECTION_CONTROL_PERIOD_MS = 5000L;
    private Runnable wsReconnectorRunnable;
    private Handler wsReconnectionHandler = new Handler();
    Gson gson;

    public WebSocketHandler(AntMediaSignallingEvents signallingListener, Handler handler) {
        this.handler = handler;
        this.signallingListener = signallingListener;
        GsonBuilder builder = new GsonBuilder();
        this.gson = builder.create();
    }

    public void connect(String wsUrl) {
        this.checkIfCalledOnValidThread();
        this.wsServerUrl = wsUrl;
        Log.d((String)TAG, (String)("Connecting WebSocket to: " + wsUrl));
        this.ws = new WebSocketConnection();
        try {
            this.ws.connect(new URI(this.wsServerUrl), (WebSocket.WebSocketConnectionObserver)this);
        }
        catch (WebSocketException e) {
            e.printStackTrace();
            this.disconnect(false);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            this.disconnect(false);
        }
    }

    public void sendTextMessage(String message) {
        if (this.ws.isConnected()) {
            this.ws.sendTextMessage(message);
            Log.e((String)TAG, (String)("sent websocket message:" + message));
        } else {
            Log.d((String)TAG, (String)"Web Socket is not connected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean waitForComplete) {
        this.checkIfCalledOnValidThread();
        Log.d((String)TAG, (String)"Disconnect WebSocket.");
        this.ws.disconnect();
        if (waitForComplete) {
            Object object = this.closeEventLock;
            synchronized (object) {
                while (!this.closeEvent) {
                    try {
                        this.closeEventLock.wait(1000L);
                        break;
                    }
                    catch (InterruptedException e) {
                        Log.e((String)TAG, (String)("Wait error: " + e.toString()));
                    }
                }
            }
        }
        Log.d((String)TAG, (String)"Disconnecting WebSocket done.");
    }

    public void checkIfCalledOnValidThread() {
        if (Thread.currentThread() != this.handler.getLooper().getThread()) {
            throw new IllegalStateException("WebSocket method is not called on valid thread");
        }
    }

    public void onOpen() {
        Log.d((String)TAG, (String)"WebSocket connection opened.");
        this.signallingListener.onWebSocketConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(WebSocket.WebSocketConnectionObserver.WebSocketCloseNotification webSocketCloseNotification, String s) {
        Log.d((String)TAG, (String)"WebSocket connection closed.");
        this.signallingListener.onWebSocketDisconnected();
        Object object = this.closeEventLock;
        synchronized (object) {
            this.closeEvent = true;
            this.closeEventLock.notify();
            this.stopPingPongTimer();
        }
    }

    public void onTextMessage(String msg) {
        Log.e((String)TAG, (String)("onTextMessage: " + msg));
        if (!this.isConnected()) {
            Log.e((String)TAG, (String)"Got WebSocket message in non registered state.");
            return;
        }
        try {
            JSONObject json = new JSONObject(msg);
            String commandText = json.getString("command");
            String streamId = null;
            if (json.has("streamId")) {
                streamId = json.getString("streamId");
            }
            if (commandText.equals("start")) {
                this.signallingListener.onStartStreaming(streamId);
            } else if (commandText.equals("takeConfiguration")) {
                String description = json.getString("sdp");
                String type = json.getString("type");
                SessionDescription.Type sdpType = SessionDescription.Type.fromCanonicalForm(type);
                SessionDescription sdp = new SessionDescription(sdpType, description);
                this.signallingListener.onTakeConfiguration(streamId, sdp);
            } else if (commandText.equals("takeCandidate")) {
                String id = json.getString("id");
                int label = json.getInt("label");
                String sdp = json.getString("candidate");
                IceCandidate candidate = new IceCandidate(id, label, sdp);
                this.signallingListener.onRemoteIceCandidate(streamId, candidate);
            } else if (commandText.equals("roomInformation")) {
                String[] streams = null;
                if (json.has("streams") && !json.isNull("streams")) {
                    JSONArray streamsArray = json.getJSONArray("streams");
                    streams = new String[streamsArray.length()];
                    for (int i = 0; i < streamsArray.length(); ++i) {
                        streams[i] = streamsArray.getString(i);
                    }
                }
                this.signallingListener.onRoomInformation(streams);
            } else if (commandText.equals("streamInformation")) {
                JSONArray jsonArray = json.getJSONArray("streamInfo");
                ArrayList<StreamInfo> streamInfos = new ArrayList<StreamInfo>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject streamJSON = (JSONObject)jsonArray.get(i);
                    StreamInfo streamInfo = new StreamInfo();
                    streamInfo.setWidth(streamJSON.getInt("streamWidth"));
                    streamInfo.setHeight(streamJSON.getInt("streamHeight"));
                    streamInfo.setVideoBitrate(streamJSON.getInt("videoBitrate"));
                    streamInfo.setAudioBitrate(streamJSON.getInt("audioBitrate"));
                    streamInfo.setCodec(streamJSON.getString("videoCodec"));
                    streamInfos.add(streamInfo);
                }
                this.signallingListener.onStreamInfoList(streamId, streamInfos);
            } else if (commandText.equals("notification")) {
                String definition = json.getString("definition");
                Log.d((String)TAG, (String)("notification:   " + definition));
                if (definition.equals("publish_started")) {
                    this.signallingListener.onPublishStarted(streamId);
                    this.startPingPongTimer();
                } else if (definition.equals("publish_finished")) {
                    this.signallingListener.onPublishFinished(streamId);
                    this.stopPingPongTimer();
                } else if (definition.equals("play_started")) {
                    this.signallingListener.onPlayStarted(streamId);
                } else if (definition.equals("play_finished")) {
                    this.signallingListener.onPlayFinished(streamId);
                } else if (definition.equals("session_restored")) {
                    this.signallingListener.onSessionRestored(streamId);
                } else if (definition.equals("joinedTheRoom")) {
                    String[] streams = null;
                    if (json.has("streams") && !json.isNull("streams")) {
                        JSONArray streamsArray = json.getJSONArray("streams");
                        streams = new String[streamsArray.length()];
                        for (int i = 0; i < streamsArray.length(); ++i) {
                            streams[i] = streamsArray.getString(i);
                        }
                    }
                    this.signallingListener.onJoinedTheRoom(streamId, streams);
                } else if (definition.equals("leavedFromRoom")) {
                    String roomId = null;
                    if (json.has("ATTR_ROOM_NAME")) {
                        roomId = json.getString("ATTR_ROOM_NAME");
                    }
                    this.signallingListener.onLeftTheRoom(roomId);
                } else if (definition.equals("bitrateMeasurement")) {
                    int targetBitrate = json.getInt("targetBitrate");
                    int videoBitrate = json.getInt("videoBitrate");
                    int audioBitrate = json.getInt("audioBitrate");
                    this.signallingListener.onBitrateMeasurement(streamId, targetBitrate, videoBitrate, audioBitrate);
                } else if (definition.equals("broadcastObject")) {
                    String broadcastJson = json.getString("broadcast");
                    Broadcast broadcast = (Broadcast)this.gson.fromJson(broadcastJson, Broadcast.class);
                    this.signallingListener.onBroadcastObject(broadcast);
                }
            } else if (commandText.equals("trackList")) {
                JSONArray trackList = json.getJSONArray("trackList");
                String[] tracks = new String[trackList.length()];
                for (int i = 0; i < trackList.length(); ++i) {
                    tracks[i] = trackList.getString(i);
                }
                this.signallingListener.onTrackList(tracks);
            } else if (commandText.equals("error")) {
                String definition = json.getString("definition");
                Log.d((String)TAG, (String)("error command received: " + definition));
                this.signallingListener.onError(streamId, definition);
                if (definition.equals("no_stream_exist")) {
                    this.signallingListener.noStreamExistsToPlay(streamId);
                }
                if (definition.equals("streamIdInUse")) {
                    this.signallingListener.streamIdInUse(streamId);
                }
            } else if (commandText.equals("stop")) {
                this.disconnect(true);
            } else if (commandText.equals("pong")) {
                this.pingPongTimoutCount = 0;
                Log.i((String)TAG, (String)"pong reply is received");
            } else {
                Log.e((String)TAG, (String)("Received offer for call receiver: " + msg));
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("WebSocket message JSON parsing error: " + e.toString()));
        }
    }

    public void onRawTextMessage(byte[] bytes) {
    }

    public void onBinaryMessage(byte[] bytes) {
    }

    public void startPublish(String streamId, String token, boolean videoEnabled, boolean audioEnabled, String subscriberId, String subscriberCode, String streamName, String mainTrackId) {
        this.checkIfCalledOnValidThread();
        JSONObject json = new JSONObject();
        try {
            json.put("command", (Object)"publish");
            json.put("streamId", (Object)streamId);
            json.put("token", (Object)token);
            json.put("subscriberId", (Object)subscriberId);
            json.put("subscriberCode", (Object)subscriberCode);
            json.put("streamName", (Object)streamName);
            json.put("video", videoEnabled);
            json.put("audio", audioEnabled);
            json.put("mainTrack", (Object)mainTrackId);
            this.sendTextMessage(json.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void startPlay(String streamId, String token, String[] tracks, String subscriberId, String subscriberCode, String viewerInfo) {
        this.checkIfCalledOnValidThread();
        JSONObject json = new JSONObject();
        try {
            json.put("command", (Object)"play");
            json.put("streamId", (Object)streamId);
            json.put("token", (Object)token);
            JSONArray jsonArray = new JSONArray();
            if (tracks != null) {
                for (String trackId : tracks) {
                    jsonArray.put((Object)trackId);
                }
            }
            json.put("trackList", (Object)jsonArray);
            json.put("subscriberId", (Object)subscriberId);
            json.put("subscriberCode", (Object)subscriberCode);
            json.put("viewerInfo", (Object)viewerInfo);
            this.sendTextMessage(json.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void joinToPeer(String streamId, String token) {
        this.checkIfCalledOnValidThread();
        JSONObject json = new JSONObject();
        try {
            json.put("command", (Object)"join");
            json.put("streamId", (Object)streamId);
            json.put("token", (Object)token);
            this.sendTextMessage(json.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void stop(String streamId) {
        this.checkIfCalledOnValidThread();
        JSONObject json = new JSONObject();
        try {
            json.put("command", (Object)"stop");
            json.put("streamId", (Object)streamId);
            this.sendTextMessage(json.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void sendConfiguration(String streamId, SessionDescription sdp, String type) {
        this.checkIfCalledOnValidThread();
        JSONObject json = new JSONObject();
        try {
            json.put("command", (Object)"takeConfiguration");
            json.put("streamId", (Object)streamId);
            json.put("type", (Object)type);
            json.put("sdp", (Object)sdp.description);
            this.sendTextMessage(json.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void sendLocalIceCandidate(String streamId, IceCandidate candidate) {
        this.checkIfCalledOnValidThread();
        JSONObject json = new JSONObject();
        try {
            json.put("command", (Object)"takeCandidate");
            json.put("streamId", (Object)streamId);
            json.put("label", candidate.sdpMLineIndex);
            json.put("id", (Object)candidate.sdpMid);
            json.put("candidate", (Object)candidate.sdp);
            this.sendTextMessage(json.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getTrackList(String streamId, String token) {
        this.checkIfCalledOnValidThread();
        JSONObject json = new JSONObject();
        try {
            json.put("command", (Object)"getTrackList");
            json.put("streamId", (Object)streamId);
            json.put("token", (Object)token);
            this.sendTextMessage(json.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void enableTrack(String streamId, String trackId, boolean enabled) {
        this.checkIfCalledOnValidThread();
        JSONObject json = new JSONObject();
        try {
            json.put("command", (Object)"enableTrack");
            json.put("streamId", (Object)streamId);
            json.put("trackId", (Object)trackId);
            json.put("enabled", enabled);
            this.sendTextMessage(json.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void startPingPongTimer() {
        Log.d((String)TAG, (String)"Ping Pong timer is started");
        Runnable timerTask = new Runnable(){

            @Override
            public void run() {
                Log.d((String)WebSocketHandler.TAG, (String)"Ping Pong timer is executed");
                WebSocketHandler.this.sendPingPongMessage();
                if (WebSocketHandler.this.pingPongTimoutCount == 2) {
                    Log.d((String)WebSocketHandler.TAG, (String)"Ping Pong websocket response not received for 4 seconds");
                    WebSocketHandler.this.stopPingPongTimer();
                    WebSocketHandler.this.disconnect(true);
                }
                WebSocketHandler.this.pingPongTimoutCount++;
            }
        };
        this.pingPongExecutor = Executors.newSingleThreadScheduledExecutor();
        this.pingPongExecutor.scheduleAtFixedRate(timerTask, 3000L, 2000L, TimeUnit.MILLISECONDS);
    }

    public void stopPingPongTimer() {
        Log.d((String)TAG, (String)"Ping Pong timer stop called");
        if (this.pingPongExecutor != null) {
            this.pingPongExecutor.shutdown();
            this.pingPongExecutor = null;
            this.pingPongTimoutCount = 0;
        }
    }

    public void sendPingPongMessage() {
        JSONObject json = new JSONObject();
        try {
            json.put("command", (Object)"ping");
            this.sendTextMessage(json.toString());
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Ping/Pong message error " + json.toString()));
        }
    }

    public void joinToConferenceRoom(String roomName, String streamId) {
        this.checkIfCalledOnValidThread();
        JSONObject json = new JSONObject();
        try {
            json.put("command", (Object)"joinRoom");
            json.put("room", (Object)roomName);
            json.put("streamId", (Object)streamId);
            this.sendTextMessage(json.toString());
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Connect to conference room JSON error: " + e.getMessage()));
        }
    }

    public void leaveFromTheConferenceRoom(String roomName) {
        this.checkIfCalledOnValidThread();
        JSONObject json = new JSONObject();
        try {
            json.put("command", (Object)"leaveFromRoom");
            json.put("room", (Object)roomName);
            this.sendTextMessage(json.toString());
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Leave from conference room JSON error: " + e.getMessage()));
        }
    }

    public void getRoomInfo(String roomName, String streamId) {
        this.checkIfCalledOnValidThread();
        JSONObject json = new JSONObject();
        try {
            json.put("command", (Object)"getRoomInfo");
            json.put("room", (Object)roomName);
            json.put("streamId", (Object)streamId);
            this.sendTextMessage(json.toString());
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Room Info conference room JSON error: " + e.getMessage()));
        }
    }

    public void getStreamInfoList(String streamId) {
        this.checkIfCalledOnValidThread();
        JSONObject json = new JSONObject();
        try {
            json.put("command", (Object)"getStreamInfo");
            json.put("streamId", (Object)streamId);
            this.sendTextMessage(json.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public AntMediaSignallingEvents getSignallingListener() {
        return this.signallingListener;
    }

    public boolean isConnected() {
        return this.ws != null && this.ws.isConnected();
    }

    public void forceStreamQuality(String streamId, int height) {
        this.checkIfCalledOnValidThread();
        JSONObject json = new JSONObject();
        try {
            json.put("command", (Object)"forceStreamQuality");
            json.put("streamId", (Object)streamId);
            json.put("streamHeight", height);
            this.sendTextMessage(json.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getBroadcastObject(String streamId) {
        this.checkIfCalledOnValidThread();
        JSONObject json = new JSONObject();
        try {
            json.put("command", (Object)"getBroadcastObject");
            json.put("streamId", (Object)streamId);
            this.sendTextMessage(json.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setupWsReconnection() {
        if (this.wsReconnectorRunnable != null) {
            return;
        }
        this.wsReconnectorRunnable = () -> {
            this.wsReconnectionHandler.postDelayed(this.wsReconnectorRunnable, 5000L);
            if (!this.isConnected()) {
                this.connect(this.wsServerUrl);
            }
        };
        if (Build.VERSION.SDK_INT >= 29) {
            if (!this.wsReconnectionHandler.hasCallbacks(this.wsReconnectorRunnable)) {
                this.wsReconnectionHandler.postDelayed(this.wsReconnectorRunnable, 5000L);
            }
        } else {
            this.wsReconnectionHandler.postDelayed(this.wsReconnectorRunnable, 5000L);
        }
    }

    public void stopReconnector() {
        if (this.wsReconnectionHandler == null) {
            return;
        }
        this.wsReconnectionHandler.removeCallbacksAndMessages(null);
        this.wsReconnectionHandler = null;
    }

    public Runnable getWsReconnectorRunnable() {
        return this.wsReconnectorRunnable;
    }

    public Handler getWsReconnectionHandler() {
        return this.wsReconnectionHandler;
    }

    public void setWsReconnectionHandler(Handler wsReconnectionHandler) {
        this.wsReconnectionHandler = wsReconnectionHandler;
    }
}

