/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audio;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTimestamp;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledExecutorService;
import org.webrtc.CalledByNative;
import org.webrtc.Logging;
import org.webrtc.audio.JavaAudioDeviceModule;
import org.webrtc.audio.WebRtcAudioEffects;
import org.webrtc.audio.WebRtcAudioRecord;

public class CustomWebRtcAudioRecord
extends WebRtcAudioRecord {
    private static final String TAG = "CustomWebRtcAudioRecordExternal";
    private int sampleRate = 0;
    private int channelCount = 0;
    private int bufferByteLength;
    private boolean started;

    public void pushAudio(byte[] audio, int length) {
        if (this.started) {
            AudioTimestamp audioTimestamp;
            this.byteBuffer.clear();
            this.byteBuffer.put(audio, 0, length);
            long captureTimeNs = 0L;
            if (Build.VERSION.SDK_INT >= 240 && this.audioRecord.getTimestamp(audioTimestamp = new AudioTimestamp(), 0) == 0) {
                captureTimeNs = audioTimestamp.nanoTime;
            }
            this.nativeDataIsRecorded(this.nativeAudioRecord, length, captureTimeNs);
        }
    }

    @CalledByNative
    CustomWebRtcAudioRecord(Context context, AudioManager audioManager) {
        this(context, CustomWebRtcAudioRecord.newDefaultScheduler(), audioManager, 7, 2, null, null, null, WebRtcAudioEffects.isAcousticEchoCancelerSupported(), WebRtcAudioEffects.isNoiseSuppressorSupported());
    }

    public CustomWebRtcAudioRecord(Context context, ScheduledExecutorService scheduler, AudioManager audioManager, int audioSource, int audioFormat, @Nullable JavaAudioDeviceModule.AudioRecordErrorCallback errorCallback, @Nullable JavaAudioDeviceModule.AudioRecordStateCallback stateCallback, @Nullable JavaAudioDeviceModule.SamplesReadyCallback audioSamplesReadyCallback, boolean isAcousticEchoCancelerSupported, boolean isNoiseSuppressorSupported) {
        super(context, scheduler, audioManager, audioSource, audioFormat, errorCallback, stateCallback, audioSamplesReadyCallback, isAcousticEchoCancelerSupported, isNoiseSuppressorSupported);
    }

    @Override
    @CalledByNative
    public int initRecording(int sampleRate, int channels) {
        Logging.d(TAG, "initRecording(sampleRate=" + sampleRate + ", channels=" + channels + ")");
        int bytesPerFrame = channels * CustomWebRtcAudioRecord.getBytesPerSample(this.audioFormat);
        int framesPerBuffer = sampleRate / 100;
        this.allocateBuffer(bytesPerFrame, framesPerBuffer);
        if (!this.byteBuffer.hasArray()) {
            this.reportWebRtcAudioRecordInitError("ByteBuffer does not have backing array.");
            return -1;
        }
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        this.nativeCacheDirectBufferAddress(this.nativeAudioRecord, this.byteBuffer);
        int channelConfig = this.channelCountToConfiguration(channels);
        int minBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)this.audioFormat);
        if (minBufferSize == -1 || minBufferSize == -2) {
            this.reportWebRtcAudioRecordInitError("AudioRecord.getMinBufferSize failed: " + minBufferSize);
            return -1;
        }
        Logging.d(TAG, "AudioRecord.getMinBufferSize: " + minBufferSize);
        int bufferSizeInBytes = Math.max(2 * minBufferSize, this.byteBuffer.capacity());
        Logging.d(TAG, "bufferSizeInBytes: " + bufferSizeInBytes);
        this.sampleRate = sampleRate;
        this.channelCount = channels;
        this.bufferByteLength = this.emptyBytes.length;
        return framesPerBuffer;
    }

    @Nullable
    public void allocateBuffer(int bytesPerFrame, int framesPerBuffer) {
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * framesPerBuffer);
    }

    @Override
    @RequiresApi(value=23)
    @TargetApi(value=23)
    public void setPreferredDevice(@Nullable AudioDeviceInfo preferredDevice) {
        Logging.d(TAG, "setPreferredDevice " + (preferredDevice != null ? Integer.valueOf(preferredDevice.getId()) : null));
        this.preferredDevice = preferredDevice;
    }

    @Override
    @CalledByNative
    public boolean startRecording() {
        Logging.d(TAG, "startRecording");
        this.started = true;
        return true;
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    @CalledByNative
    public synchronized boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        this.started = false;
        if (this.future != null) {
            if (!this.future.isDone()) {
                this.future.cancel(true);
            }
            this.future = null;
        }
        this.effects.release();
        this.releaseAudioResources();
        return true;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public int getAudioFormat() {
        return this.audioFormat;
    }

    public int getBufferByteLength() {
        return this.bufferByteLength;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }
}

