/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.gl;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import org.ar.rtc.gl.AREglBase;

@TargetApi(value=18)
public class AREglBase14
extends AREglBase {
    private static final String TAG = "EglBase14";
    private static final int EGLExt_SDK_VERSION = 18;
    private static final int CURRENT_SDK_VERSION = Build.VERSION.SDK_INT;
    private EGLContext eglContext;
    private EGLConfig eglConfig;
    private EGLDisplay eglDisplay;
    private EGLSurface eglSurface = EGL14.EGL_NO_SURFACE;

    public static boolean isEGL14Supported() {
        Log.d((String)TAG, (String)("SDK version: " + CURRENT_SDK_VERSION + ". isEGL14Supported: " + (CURRENT_SDK_VERSION >= 18)));
        return CURRENT_SDK_VERSION >= 18;
    }

    public AREglBase14(Context var1, int[] var2) {
        this.eglDisplay = AREglBase14.getEglDisplay();
        this.eglConfig = AREglBase14.getEglConfig(this.eglDisplay, var2);
        this.eglContext = AREglBase14.createEglContext(var1, this.eglDisplay, this.eglConfig);
    }

    @Override
    public void createSurface(Surface var1) {
        this.createSurfaceInternal(var1);
    }

    @Override
    public void createSurface(SurfaceTexture var1) {
        this.createSurfaceInternal(var1);
    }

    private void createSurfaceInternal(Object var1) {
        if (!(var1 instanceof Surface) && !(var1 instanceof SurfaceTexture)) {
            throw new IllegalStateException("Input must be either a Surface or SurfaceTexture");
        }
        this.checkIsNotReleased();
        if (this.eglSurface != EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("Already has an EGLSurface");
        }
        int[] var2 = new int[]{12344};
        this.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (Object)var1, (int[])var2, (int)0);
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("Failed to create window surface: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
    }

    @Override
    public void createDummyPbufferSurface() {
        this.createPbufferSurface(1, 1);
    }

    @Override
    public void createPbufferSurface(int var1, int var2) {
        this.checkIsNotReleased();
        if (this.eglSurface != EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("Already has an EGLSurface");
        }
        int[] var3 = new int[]{12375, var1, 12374, var2, 12344};
        this.eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (int[])var3, (int)0);
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("Failed to create pixel buffer surface with size " + var1 + "x" + var2 + ": 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
    }

    @Override
    public Context getEglBaseContext() {
        return new Context(this.eglContext);
    }

    @Override
    public boolean hasSurface() {
        return this.eglSurface != EGL14.EGL_NO_SURFACE;
    }

    @Override
    public int surfaceWidth() {
        int[] var1 = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12375, (int[])var1, (int)0);
        return var1[0];
    }

    @Override
    public int surfaceHeight() {
        int[] var1 = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12374, (int[])var1, (int)0);
        return var1[0];
    }

    @Override
    public void releaseSurface() {
        if (this.eglSurface != EGL14.EGL_NO_SURFACE) {
            EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
            this.eglSurface = EGL14.EGL_NO_SURFACE;
        }
    }

    private void checkIsNotReleased() {
        if (this.eglDisplay == EGL14.EGL_NO_DISPLAY || this.eglContext == EGL14.EGL_NO_CONTEXT || this.eglConfig == null) {
            throw new RuntimeException("This object has been released");
        }
    }

    @Override
    public void release() {
        this.checkIsNotReleased();
        this.releaseSurface();
        this.detachCurrent();
        EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
        EGL14.eglReleaseThread();
        EGL14.eglTerminate((EGLDisplay)this.eglDisplay);
        this.eglContext = EGL14.EGL_NO_CONTEXT;
        this.eglDisplay = EGL14.EGL_NO_DISPLAY;
        this.eglConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeCurrent() {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't make current");
        }
        Object object = AREglBase.lock;
        synchronized (object) {
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.eglContext)) {
                throw new RuntimeException("eglMakeCurrent failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachCurrent() {
        Object object = AREglBase.lock;
        synchronized (object) {
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT)) {
                throw new RuntimeException("eglDetachCurrent failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers() {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't swap buffers");
        }
        Object object = AREglBase.lock;
        synchronized (object) {
            EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers(long var1) {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL14.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't swap buffers");
        }
        Object object = AREglBase.lock;
        synchronized (object) {
            EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (long)var1);
            EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
        }
    }

    private static EGLDisplay getEglDisplay() {
        EGLDisplay var0 = EGL14.eglGetDisplay((int)0);
        if (var0 == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("Unable to get EGL14 display: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        int[] var1 = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)var0, (int[])var1, (int)0, (int[])var1, (int)1)) {
            throw new RuntimeException("Unable to initialize EGL14: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        return var0;
    }

    private static EGLConfig getEglConfig(EGLDisplay var0, int[] var1) {
        EGLConfig[] var2 = new EGLConfig[1];
        int[] var3 = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)var0, (int[])var1, (int)0, (EGLConfig[])var2, (int)0, (int)var2.length, (int[])var3, (int)0)) {
            throw new RuntimeException("eglChooseConfig failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        if (var3[0] <= 0) {
            throw new RuntimeException("Unable to find any matching EGL config");
        }
        EGLConfig var4 = var2[0];
        if (var4 == null) {
            throw new RuntimeException("eglChooseConfig returned null");
        }
        return var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EGLContext createEglContext(Context var0, EGLDisplay var1, EGLConfig var2) {
        if (var0 != null && var0.egl14Context == EGL14.EGL_NO_CONTEXT) {
            throw new RuntimeException("Invalid sharedContext");
        }
        int[] var3 = new int[]{12440, 2, 12344};
        EGLContext var4 = var0 == null ? EGL14.EGL_NO_CONTEXT : var0.egl14Context;
        EGLContext var5 = null;
        Object object = AREglBase.lock;
        synchronized (object) {
            var5 = EGL14.eglCreateContext((EGLDisplay)var1, (EGLConfig)var2, (EGLContext)var4, (int[])var3, (int)0);
            int var7 = EGL14.eglGetError();
            if (var7 != 12288) {
                int[] var8 = new int[]{12440, 3, 12344};
                var5 = EGL14.eglCreateContext((EGLDisplay)var1, (EGLConfig)var2, (EGLContext)var4, (int[])var8, (int)0);
            }
        }
        if (var5 == EGL14.EGL_NO_CONTEXT) {
            throw new RuntimeException("Failed to create EGL context: 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        return var5;
    }

    public static class Context
    implements AREglBase.Context {
        private final EGLContext egl14Context;

        @Override
        @TargetApi(value=21)
        public long getNativeEglContext() {
            return CURRENT_SDK_VERSION >= 21 ? this.egl14Context.getNativeHandle() : (long)this.egl14Context.getHandle();
        }

        public Context(EGLContext var1) {
            this.egl14Context = var1;
        }
    }
}

