/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.gl;

import android.opengl.GLES20;
import java.nio.FloatBuffer;
import java.util.IdentityHashMap;
import java.util.Map;
import org.ar.rtc.gl.ARGlUtil;
import org.ar.rtc.gl.ARRendererCommon;
import org.webrtc.GlShader;

public class ARGlRectDrawer
implements ARRendererCommon.GlDrawer {
    private static final String VERTEX_SHADER_STRING = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
    private static final String YUV_FRAGMENT_SHADER_STRING = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D y_tex;\nuniform sampler2D u_tex;\nuniform sampler2D v_tex;\n\nvoid main() {\n  float y = texture2D(y_tex, interp_tc).r;\n  float u = texture2D(u_tex, interp_tc).r - 0.5;\n  float v = texture2D(v_tex, interp_tc).r - 0.5;\n  gl_FragColor = vec4(y + 1.403 * v,                       y - 0.344 * u - 0.714 * v,                       y + 1.77 * u, 1);\n}\n";
    private static final String RGB_FRAGMENT_SHADER_STRING = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D rgb_tex;\n\nvoid main() {\n  gl_FragColor = texture2D(rgb_tex, interp_tc);\n}\n";
    private static final String OES_FRAGMENT_SHADER_STRING = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES oes_tex;\n\nvoid main() {\n  gl_FragColor = texture2D(oes_tex, interp_tc);\n}\n";
    private static final FloatBuffer FULL_RECTANGLE_BUF = ARGlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer FULL_RECTANGLE_TEX_BUF = ARGlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private FloatBuffer mTexCoordinate = ARGlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private FloatBuffer mPosCoordinate = ARGlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private final Map<String, Shader> shaders = new IdentityHashMap<String, Shader>();

    @Override
    public void drawOes(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8) {
        this.prepareShader(OES_FRAGMENT_SHADER_STRING, var2);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)var1);
        this.drawRectangle(var5, var6, var7, var8);
        GLES20.glBindTexture((int)36197, (int)0);
    }

    @Override
    public void drawRgb(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8) {
        this.prepareShader(RGB_FRAGMENT_SHADER_STRING, var2);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)var1);
        this.drawRectangle(var5, var6, var7, var8);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    public void drawYuv(int[] var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8) {
        int var9;
        this.prepareShader(YUV_FRAGMENT_SHADER_STRING, var2);
        for (var9 = 0; var9 < 3; ++var9) {
            GLES20.glActiveTexture((int)(33984 + var9));
            GLES20.glBindTexture((int)3553, (int)var1[var9]);
        }
        this.drawRectangle(var5, var6, var7, var8);
        for (var9 = 0; var9 < 3; ++var9) {
            GLES20.glActiveTexture((int)(33984 + var9));
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    private void drawRectangle(int var1, int var2, int var3, int var4) {
        GLES20.glViewport((int)var1, (int)var2, (int)var3, (int)var4);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }

    private void prepareShader(String var1, float[] var2) {
        Shader var3;
        if (this.shaders.containsKey(var1)) {
            var3 = this.shaders.get(var1);
        } else {
            var3 = new Shader(var1);
            this.shaders.put(var1, var3);
            var3.glShader.useProgram();
            if (YUV_FRAGMENT_SHADER_STRING.equals(var1)) {
                GLES20.glUniform1i((int)var3.glShader.getUniformLocation("y_tex"), (int)0);
                GLES20.glUniform1i((int)var3.glShader.getUniformLocation("u_tex"), (int)1);
                GLES20.glUniform1i((int)var3.glShader.getUniformLocation("v_tex"), (int)2);
            } else if (RGB_FRAGMENT_SHADER_STRING.equals(var1)) {
                GLES20.glUniform1i((int)var3.glShader.getUniformLocation("rgb_tex"), (int)0);
            } else {
                if (!OES_FRAGMENT_SHADER_STRING.equals(var1)) {
                    throw new IllegalStateException("Unknown fragment shader: " + var1);
                }
                GLES20.glUniform1i((int)var3.glShader.getUniformLocation("oes_tex"), (int)0);
            }
            ARGlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
            var3.glShader.setVertexAttribArray("in_pos", 2, FULL_RECTANGLE_BUF);
            var3.glShader.setVertexAttribArray("in_tc", 2, FULL_RECTANGLE_TEX_BUF);
        }
        var3.glShader.useProgram();
        GLES20.glUniformMatrix4fv((int)var3.texMatrixLocation, (int)1, (boolean)false, (float[])var2, (int)0);
    }

    private void prepareShader(String var1, float[] var2, FloatBuffer var3, FloatBuffer var4) {
        Shader var5;
        if (this.shaders.containsKey(var1)) {
            var5 = this.shaders.get(var1);
        } else {
            var5 = new Shader(var1);
            this.shaders.put(var1, var5);
            var5.glShader.useProgram();
            if (var1 == YUV_FRAGMENT_SHADER_STRING) {
                GLES20.glUniform1i((int)var5.glShader.getUniformLocation("y_tex"), (int)0);
                GLES20.glUniform1i((int)var5.glShader.getUniformLocation("u_tex"), (int)1);
                GLES20.glUniform1i((int)var5.glShader.getUniformLocation("v_tex"), (int)2);
            } else if (var1 == RGB_FRAGMENT_SHADER_STRING) {
                GLES20.glUniform1i((int)var5.glShader.getUniformLocation("rgb_tex"), (int)0);
            } else {
                if (var1 != OES_FRAGMENT_SHADER_STRING) {
                    throw new IllegalStateException("Unknown fragment shader: " + var1);
                }
                GLES20.glUniform1i((int)var5.glShader.getUniformLocation("oes_tex"), (int)0);
            }
            ARGlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
        }
        var5.glShader.setVertexAttribArray("in_pos", 2, var4);
        var5.glShader.setVertexAttribArray("in_tc", 2, var3);
        var5.glShader.useProgram();
        GLES20.glUniformMatrix4fv((int)var5.texMatrixLocation, (int)1, (boolean)false, (float[])var2, (int)0);
    }

    public void drawOes(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10) {
        float[] var11 = this.ComputeVertexAttribArray(var3, var4, var9, var10);
        this.mTexCoordinate = ARGlUtil.createFloatBuffer(var11);
        if (var9 == var7 && var10 == var8) {
            this.mPosCoordinate = FULL_RECTANGLE_BUF;
        } else {
            float[] var12 = this.ComputePosVertexAttribArray(var7, var8, var9, var10);
            this.mPosCoordinate = ARGlUtil.createFloatBuffer(var12);
        }
        this.prepareShader(OES_FRAGMENT_SHADER_STRING, var2, this.mTexCoordinate, this.mPosCoordinate);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)var1);
        this.drawRectangle(var5, var6, var7, var8);
        GLES20.glBindTexture((int)36197, (int)0);
    }

    public void drawRgb(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10) {
        float[] var11 = this.ComputeVertexAttribArray(var3, var4, var9, var10);
        if (var9 == var7 && var10 == var8) {
            this.mPosCoordinate = FULL_RECTANGLE_BUF;
        } else {
            float[] var12 = this.ComputePosVertexAttribArray(var7, var8, var9, var10);
            this.mPosCoordinate = ARGlUtil.createFloatBuffer(var12);
        }
        this.mTexCoordinate = ARGlUtil.createFloatBuffer(var11);
        this.prepareShader(RGB_FRAGMENT_SHADER_STRING, var2, this.mTexCoordinate, this.mPosCoordinate);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)var1);
        this.drawRectangle(var5, var6, var7, var8);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    private float[] ComputeVertexAttribArray(int var1, int var2, int var3, int var4) {
        float var6 = (float)var1 / (float)var2;
        float var5 = (float)var3 / (float)var4;
        if (var6 >= var5) {
            float var7 = (float)var2 * var5;
            float var8 = ((float)var1 - var7) / 2.0f / (float)var1;
            return new float[]{var8, 0.0f, 1.0f - var8, 0.0f, var8, 1.0f, 1.0f - var8, 1.0f};
        }
        float var7 = (float)var1 / var5;
        float var8 = 0.0f;
        float var9 = ((float)var2 - var7) / 2.0f / (float)var2;
        return new float[]{0.0f, var9, 1.0f, var9, 0.0f, 1.0f - var9, 1.0f, 1.0f - var9};
    }

    private float[] ComputePosVertexAttribArray(int var1, int var2, int var3, int var4) {
        float var5 = var2 == var4 ? -1.0f : 2.0f * (float)(var2 - var4) / (float)var2 - 1.0f;
        float var6 = var1 == var3 ? 1.0f : 2.0f * (float)var3 / (float)var1 - 1.0f;
        return new float[]{-1.0f, var5, var6, var5, -1.0f, 1.0f, var6, 1.0f};
    }

    @Override
    public void release() {
        for (Shader var2 : this.shaders.values()) {
            var2.glShader.release();
        }
        this.shaders.clear();
    }

    private static class Shader {
        public final GlShader glShader;
        public final int texMatrixLocation;

        public Shader(String var1) {
            this.glShader = new GlShader(ARGlRectDrawer.VERTEX_SHADER_STRING, var1);
            this.texMatrixLocation = this.glShader.getUniformLocation("texMatrix");
        }
    }
}

