/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.internal;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Process;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;

public class ARDeviceUtil {
    private Context context;
    private LifecycleEvent lifecycleEvent;
    private int activityCounter = 0;
    private DecimalFormat df = new DecimalFormat("######0.00");

    public ARDeviceUtil(Context context, LifecycleEvent lifecycleEvent) {
        this.context = context;
        this.lifecycleEvent = lifecycleEvent;
        this.getApplication();
    }

    public String getCpuName() {
        try {
            String text;
            FileReader fr = new FileReader("/proc/cpuinfo");
            BufferedReader br = new BufferedReader(fr);
            String last = "";
            while ((text = br.readLine()) != null) {
                last = text;
            }
            if (last.contains("Hardware")) {
                String[] hardWare = last.split(":\\s+", 2);
                return hardWare[1];
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Build.HARDWARE;
    }

    public double getCpuUsage() {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                return 0.0;
            }
            RandomAccessFile reader = new RandomAccessFile("/proc/stat", "r");
            String load = reader.readLine();
            String[] toks = load.split(" ");
            long idle1 = Long.parseLong(toks[5]);
            long cpu1 = Long.parseLong(toks[2]) + Long.parseLong(toks[3]) + Long.parseLong(toks[4]) + Long.parseLong(toks[6]) + Long.parseLong(toks[7]) + Long.parseLong(toks[8]);
            try {
                Thread.sleep(360L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            reader.seek(0L);
            load = reader.readLine();
            reader.close();
            toks = load.split(" ");
            long idle2 = Long.parseLong(toks[5]);
            long cpu2 = Long.parseLong(toks[2]) + Long.parseLong(toks[3]) + Long.parseLong(toks[4]) + Long.parseLong(toks[6]) + Long.parseLong(toks[7]) + Long.parseLong(toks[8]);
            long usage = cpu2 - cpu1;
            long total = cpu2 + idle2 - (cpu1 + idle1);
            return (double)usage * 100.0 / (double)total;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    public int getProcessMemUsage() {
        int memSize = 0;
        try {
            ActivityManager am = (ActivityManager)this.context.getSystemService("activity");
            int[] myMempid = new int[]{Process.myPid()};
            Debug.MemoryInfo[] memoryInfo = am.getProcessMemoryInfo(myMempid);
            memSize = memoryInfo[0].getTotalPss();
            return memSize;
        }
        catch (Exception e) {
            return memSize;
        }
    }

    public double getProcessPercentValue() {
        try {
            String percent = this.df.format((double)this.getProcessMemUsage() / (double)this.getTotleMem() * 100.0);
            return Double.parseDouble(percent);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private long getTotleMem() {
        try {
            ActivityManager manager = (ActivityManager)this.context.getSystemService("activity");
            ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
            manager.getMemoryInfo(info);
            return info.totalMem / 1024L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public double getSysUsedPercentValue() {
        String dir = "/proc/meminfo";
        try {
            FileReader fr = new FileReader(dir);
            BufferedReader br = new BufferedReader(fr, 2048);
            String memoryLine = br.readLine();
            String subMemoryLine = memoryLine.substring(memoryLine.indexOf("MemTotal:"));
            br.close();
            long totalMemorySize = Integer.parseInt(subMemoryLine.replaceAll("\\D+", ""));
            long availableSize = this.getAvailableMemory() / 1024L;
            String percent = this.df.format((double)(totalMemorySize - availableSize) / (double)totalMemorySize * 100.0);
            return Double.parseDouble(percent);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private long getAvailableMemory() {
        try {
            ActivityManager manager = (ActivityManager)this.context.getSystemService("activity");
            ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
            manager.getMemoryInfo(info);
            return info.availMem;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public double getProcessCpuRate() {
        String cpuRate = "0";
        try {
            float totalCpuTime1 = this.getTotalCpuTime();
            float processCpuTime1 = this.getAppCpuTime();
            Thread.sleep(360L);
            float totalCpuTime2 = this.getTotalCpuTime();
            float processCpuTime2 = this.getAppCpuTime();
            cpuRate = this.df.format(100.0f * (processCpuTime2 - processCpuTime1) / (totalCpuTime2 - totalCpuTime1));
            return Double.parseDouble(cpuRate);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public long getTotalCpuTime() {
        String[] cpuInfos = null;
        long totalCpu = 0L;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/stat")), 1000);
            String load = reader.readLine();
            reader.close();
            cpuInfos = load.split(" ");
            if (cpuInfos.length >= 8) {
                totalCpu = Long.parseLong(cpuInfos[2]) + Long.parseLong(cpuInfos[3]) + Long.parseLong(cpuInfos[4]) + Long.parseLong(cpuInfos[6]) + Long.parseLong(cpuInfos[5]) + Long.parseLong(cpuInfos[7]) + Long.parseLong(cpuInfos[8]);
            }
            return totalCpu;
        }
        catch (Exception e) {
            return totalCpu;
        }
    }

    public long getAppCpuTime() {
        String[] cpuInfos = null;
        long appCpuTime = 0L;
        try {
            int pid = Process.myPid();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/" + pid + "/stat")), 1000);
            String load = reader.readLine();
            reader.close();
            cpuInfos = load.split(" ");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            if (cpuInfos.length >= 16) {
                appCpuTime = Long.parseLong((String)cpuInfos[13]) + Long.parseLong((String)cpuInfos[14]) + Long.parseLong((String)cpuInfos[15]) + Long.parseLong((String)cpuInfos[16]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return appCpuTime;
    }

    public void getApplication() {
        Application application = null;
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Field appField = activityThreadClass.getDeclaredField("mInitialApplication");
            Method method = activityThreadClass.getMethod("currentActivityThread", new Class[0]);
            Object localObject = method.invoke(null, (Object[])null);
            appField.setAccessible(true);
            application = (Application)appField.get(localObject);
            if (application != null) {
                application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
                    }

                    public void onActivityStarted(@NonNull Activity activity) {
                        ARDeviceUtil.this.activityCounter++;
                        if (ARDeviceUtil.this.activityCounter == 1 && ARDeviceUtil.this.lifecycleEvent != null) {
                            ARDeviceUtil.this.lifecycleEvent.onBackGround(false);
                        }
                    }

                    public void onActivityResumed(@NonNull Activity activity) {
                    }

                    public void onActivityPaused(@NonNull Activity activity) {
                    }

                    public void onActivityStopped(@NonNull Activity activity) {
                        ARDeviceUtil.this.activityCounter--;
                        if (ARDeviceUtil.this.activityCounter == 0 && ARDeviceUtil.this.lifecycleEvent != null) {
                            ARDeviceUtil.this.lifecycleEvent.onBackGround(true);
                        }
                    }

                    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
                    }

                    public void onActivityDestroyed(@NonNull Activity activity) {
                    }
                });
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static interface LifecycleEvent {
        public void onBackGround(boolean var1);
    }
}

