/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.live;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class LiveTranscoding {
    public int width = 360;
    public int height = 640;
    public int videoBitrate = 400;
    public int videoFramerate = 15;
    @Deprecated
    public boolean lowLatency = false;
    public int videoGop = 30;
    public RtcImage watermark;
    public RtcImage backgroundImage;
    public int videoCodecProfile = VideoCodecProfileType.access$000(VideoCodecProfileType.HIGH);
    public int backgroundColor = 0;
    public int userCount = 0;
    public String transcodingExtraInfo = "";
    @Deprecated
    public String metadata = "";
    public int audioSampleRate;
    public int audioBitrate = 48;
    public int audioChannels = 1;
    public int audioCodecProfile;
    private Map<String, TranscodingUser> transcodingUsers;

    public LiveTranscoding() {
        this.watermark = new RtcImage();
        this.backgroundImage = new RtcImage();
        this.audioSampleRate = AudioSampleRateType.TYPE_44100.value;
        this.audioCodecProfile = AudioCodecProfileType.LC_AAC.value;
        this.transcodingUsers = new HashMap<String, TranscodingUser>();
        this.transcodingUsers = new HashMap<String, TranscodingUser>();
    }

    public int addUser(TranscodingUser var1) {
        if (var1 != null && !TextUtils.isEmpty((CharSequence)var1.uid)) {
            this.transcodingUsers.put(var1.uid, var1);
            this.userCount = this.transcodingUsers.size();
            return 0;
        }
        return -2;
    }

    public final ArrayList<TranscodingUser> getUsers() {
        Collection<TranscodingUser> var1 = this.transcodingUsers.values();
        return new ArrayList<TranscodingUser>(var1);
    }

    public TranscodingUser[] getUserArray() {
        ArrayList<TranscodingUser> list = this.getUsers();
        TranscodingUser[] userArray = new TranscodingUser[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            userArray[i] = list.get(i);
        }
        return userArray;
    }

    public void setUsers(ArrayList<TranscodingUser> var1) {
        this.transcodingUsers.clear();
        if (var1 != null) {
            for (TranscodingUser var3 : var1) {
                this.transcodingUsers.put(var3.uid, var3);
            }
        }
        this.userCount = this.transcodingUsers.size();
    }

    public void setUsers(Map<String, TranscodingUser> var1) {
        this.transcodingUsers.clear();
        if (var1 != null) {
            this.transcodingUsers.putAll(var1);
        }
        this.userCount = this.transcodingUsers.size();
    }

    public int removeUser(int var1) {
        if (!this.transcodingUsers.containsKey(var1)) {
            return -2;
        }
        this.transcodingUsers.remove(var1);
        this.userCount = this.transcodingUsers.size();
        return 0;
    }

    public int getUserCount() {
        return this.transcodingUsers.size();
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int var1) {
        this.backgroundColor = var1;
    }

    public static class RtcImage {
        public String url = "";
        public int x = 0;
        public int y = 0;
        public int width = 0;
        public int height = 0;
    }

    public static class TranscodingUser {
        public String uid = "";
        public int x = 0;
        public int y = 0;
        public int width = 0;
        public int height = 0;
        public int zOrder = 0;
        public float alpha = 1.0f;
        public int audioChannel = 0;
    }

    public static enum VideoCodecProfileType {
        BASELINE(66),
        MAIN(77),
        HIGH(100);

        private int value;

        private VideoCodecProfileType(int var3) {
            this.value = var3;
        }

        public static int getValue(VideoCodecProfileType var0) {
            return var0.value;
        }

        static /* synthetic */ int access$000(VideoCodecProfileType x0) {
            return x0.value;
        }
    }

    public static enum AudioSampleRateType {
        TYPE_32000(32000),
        TYPE_44100(44100),
        TYPE_48000(48000);

        private int value;

        private AudioSampleRateType(int var3) {
            this.value = var3;
        }

        public static int getValue(AudioSampleRateType var0) {
            return var0.value;
        }
    }

    public static enum AudioCodecProfileType {
        LC_AAC(0),
        HE_AAC(1);

        private int value;

        private AudioCodecProfileType(int var3) {
            this.value = var3;
        }

        public static int getValue(AudioCodecProfileType var0) {
            return var0.value;
        }
    }

    public static enum VIDEO_CODEC_PROFILE_TYPE {
        VIDEO_CODEC_PROFILE_BASELINE(66),
        VIDEO_CODEC_PROFILE_MAIN(77),
        VIDEO_CODEC_PROFILE_HIGH(100);

        private final int value;

        private VIDEO_CODEC_PROFILE_TYPE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

