/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.recorder;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Looper;
import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.webrtc.recorder.Encoder;

abstract class BaseEncoder
implements Encoder {
    private String mCodecName;
    private MediaCodec mEncoder;
    private Callback mCallback;
    private MediaCodec.Callback mCodecCallback = new MediaCodec.Callback(){

        public void onInputBufferAvailable(MediaCodec codec, int index) {
            BaseEncoder.this.mCallback.onInputBufferAvailable(BaseEncoder.this, index);
        }

        public void onOutputBufferAvailable(MediaCodec codec, int index, MediaCodec.BufferInfo info) {
            BaseEncoder.this.mCallback.onOutputBufferAvailable(BaseEncoder.this, index, info);
        }

        public void onError(MediaCodec codec, MediaCodec.CodecException e) {
            BaseEncoder.this.mCallback.onError(BaseEncoder.this, (Exception)e);
        }

        public void onOutputFormatChanged(MediaCodec codec, MediaFormat format) {
            BaseEncoder.this.mCallback.onOutputFormatChanged(BaseEncoder.this, format);
        }
    };

    BaseEncoder() {
    }

    BaseEncoder(String codecName) {
        this.mCodecName = codecName;
    }

    @Override
    public void setCallback(Encoder.Callback callback) {
        if (!(callback instanceof Callback)) {
            throw new IllegalArgumentException();
        }
        this.setCallback((Callback)callback);
    }

    void setCallback(Callback callback) {
        if (this.mEncoder != null) {
            throw new IllegalStateException("mEncoder is not null");
        }
        this.mCallback = callback;
    }

    @Override
    public void prepare() throws IOException {
        if (Looper.myLooper() == null || Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("should run in a HandlerThread");
        }
        if (this.mEncoder != null) {
            throw new IllegalStateException("prepared!");
        }
        MediaFormat format = this.createMediaFormat();
        Log.d((String)"Encoder", (String)("Create media format: " + format));
        String mimeType = format.getString("mime");
        MediaCodec encoder = this.createEncoder(mimeType);
        try {
            if (this.mCallback != null) {
                encoder.setCallback(this.mCodecCallback);
            }
            encoder.configure(format, null, null, 1);
            this.onEncoderConfigured(encoder);
            encoder.start();
        }
        catch (MediaCodec.CodecException e) {
            Log.e((String)"Encoder", (String)("Configure codec failure!\n  with format" + format), (Throwable)e);
            throw e;
        }
        this.mEncoder = encoder;
    }

    protected void onEncoderConfigured(MediaCodec encoder) {
    }

    private MediaCodec createEncoder(String type) throws IOException {
        try {
            if (this.mCodecName != null) {
                return MediaCodec.createByCodecName((String)this.mCodecName);
            }
        }
        catch (IOException e) {
            Log.w((String)"@@", (String)("Create MediaCodec by name '" + this.mCodecName + "' failure!"), (Throwable)e);
        }
        return MediaCodec.createEncoderByType((String)type);
    }

    protected abstract MediaFormat createMediaFormat();

    protected final MediaCodec getEncoder() {
        return Objects.requireNonNull(this.mEncoder, "doesn't prepare()");
    }

    public final ByteBuffer getOutputBuffer(int index) {
        return this.getEncoder().getOutputBuffer(index);
    }

    public final ByteBuffer getInputBuffer(int index) {
        return this.getEncoder().getInputBuffer(index);
    }

    public final void queueInputBuffer(int index, int offset, int size, long pstTs, int flags) {
        this.getEncoder().queueInputBuffer(index, offset, size, pstTs, flags);
    }

    public final void releaseOutputBuffer(int index) {
        this.getEncoder().releaseOutputBuffer(index, false);
    }

    @Override
    public void stop() {
        if (this.mEncoder != null) {
            this.mEncoder.stop();
        }
    }

    @Override
    public void release() {
        if (this.mEncoder != null) {
            this.mEncoder.release();
            this.mEncoder = null;
        }
    }

    static abstract class Callback
    implements Encoder.Callback {
        Callback() {
        }

        void onInputBufferAvailable(BaseEncoder encoder, int index) {
        }

        void onOutputFormatChanged(BaseEncoder encoder, MediaFormat format) {
        }

        void onOutputBufferAvailable(BaseEncoder encoder, int index, MediaCodec.BufferInfo info) {
        }
    }
}

