/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc;

import android.content.Context;
import android.view.TextureView;
import java.util.concurrent.ConcurrentHashMap;
import org.ar.rtc.IAudioEffectManager;
import org.ar.rtc.IAudioFrameObserver;
import org.ar.rtc.IRtcEngineEventHandler;
import org.ar.rtc.RtcChannel;
import org.ar.rtc.RtcEngineImpl;
import org.ar.rtc.VideoEncoderConfiguration;
import org.ar.rtc.internal.EncryptionConfig;
import org.ar.rtc.internal.LastmileProbeConfig;
import org.ar.rtc.live.LiveInjectStreamConfig;
import org.ar.rtc.live.LiveTranscoding;
import org.ar.rtc.mediaio.IVideoSink;
import org.ar.rtc.mediaio.IVideoSource;
import org.ar.rtc.video.ARVideoFrame;
import org.ar.rtc.video.CameraCapturerConfiguration;
import org.ar.rtc.video.ChannelMediaRelayConfiguration;
import org.ar.rtc.video.VideoCanvas;
import org.webrtc.ARAudioManager;
import org.webrtc.TextureViewRenderer;

public abstract class RtcEngine {
    private static RtcEngineImpl mInstance = null;
    protected ConcurrentHashMap<String, VideoCanvas> m_remote_render_list = new ConcurrentHashMap();
    protected VideoCanvas m_local_video_canvas;
    protected int m_localRenderMode = 1;
    protected int m_localRenderMirrorMode = 1;
    protected boolean isOpenEarMonitoring = false;
    protected boolean isOpeningEarMonitoring = false;
    protected ARAudioManager.AudioDevice curAudioDevice;

    public static synchronized RtcEngine create(Context context, String appId, IRtcEngineEventHandler handler) {
        if (context != null && RtcEngineImpl.initializeNativeLibs()) {
            if (mInstance == null) {
                mInstance = new RtcEngineImpl(context, appId, handler);
            } else {
                mInstance.reinitialize(context, appId, handler);
            }
            return mInstance;
        }
        return null;
    }

    public abstract void setAudioMode(boolean var1);

    public abstract int setChannelProfile(int var1);

    public abstract int setClientRole(int var1);

    public abstract int joinChannel(String var1, String var2, String var3, String var4);

    public abstract int switchChannel(String var1, String var2);

    public abstract int leaveChannel();

    public abstract int enableDualStreamMode(boolean var1);

    public abstract int setRemoteVideoStreamType(String var1, int var2);

    public abstract int setRemoteDefaultVideoStreamType(int var1);

    public abstract int createDataStream(boolean var1, boolean var2);

    public abstract int sendStreamMessage(int var1, byte[] var2);

    public abstract int enableAudio();

    public abstract int disableAudio();

    public abstract int setAudioProfile(int var1, int var2);

    public abstract int adjustRecordingSignalVolume(int var1);

    public abstract int adjustUserPlaybackSignalVolume(String var1, int var2);

    public abstract int adjustPlaybackSignalVolume(int var1);

    public abstract int enableLocalAudio(boolean var1);

    public abstract int muteLocalAudioStream(boolean var1);

    public abstract int muteRemoteAudioStream(String var1, boolean var2);

    public abstract int muteAllRemoteAudioStreams(boolean var1);

    public abstract int setDefaultMuteAllRemoteAudioStreams(boolean var1);

    public abstract int enableInEarMonitoring(boolean var1);

    public abstract int setInEarMonitoringVolume(int var1);

    public abstract int startAudioRecording(String var1, int var2, int var3);

    public abstract int stopAudioRecording();

    public abstract int enableVideo();

    public abstract int disableVideo();

    public abstract int setVideoEncoderConfiguration(VideoEncoderConfiguration var1);

    public abstract int setCameraCapturerConfiguration(CameraCapturerConfiguration var1);

    public abstract int setupLocalVideo(VideoCanvas var1);

    public abstract int setupRemoteVideo(VideoCanvas var1);

    public abstract int setLocalRenderMode(int var1, int var2);

    public abstract int setRemoteRenderMode(String var1, int var2, int var3);

    public static TextureView CreateRendererView(Context context) {
        TextureViewRenderer render = new TextureViewRenderer(context);
        if (mInstance != null) {
            render.init(mInstance.getEglBase().getEglBaseContext(), null);
        }
        TextureViewRenderer view = render;
        return view;
    }

    public abstract int startPreview();

    public abstract int stopPreview();

    public abstract int enableLocalVideo(boolean var1);

    public abstract int muteLocalVideoStream(boolean var1);

    public abstract int muteRemoteVideoStream(String var1, boolean var2);

    public abstract int muteAllRemoteVideoStreams(boolean var1);

    public abstract int setDefaultMuteAllRemoteVideoStreams(boolean var1);

    public abstract int switchCamera();

    public abstract boolean isCameraZoomSupported();

    public abstract boolean isCameraTorchSupported();

    public abstract boolean isCameraFocusSupported();

    public abstract boolean isCameraExposurePositionSupported();

    public abstract boolean isCameraAutoFocusFaceModeSupported();

    public abstract int setCameraZoomFactor(float var1);

    public abstract float getCameraMaxZoomFactor();

    public abstract int setCameraFocusPositionInPreview(float var1, float var2);

    public abstract int setCameraExposurePosition(float var1, float var2);

    public abstract int setCameraTorchOn(boolean var1);

    public abstract int setCameraAutoFocusFaceModeEnabled(boolean var1);

    public abstract int renewToken(String var1);

    public int enableWebSdkInteroperability() {
        return 0;
    }

    public abstract int setDefaultAudioRoutetoSpeakerphone(boolean var1);

    public abstract int setEnableSpeakerphone(boolean var1);

    public abstract boolean isSpeakerphoneEnabled();

    public abstract int enableAudioVolumeIndication(int var1, int var2, boolean var3);

    public static String getSdkVersion() {
        return "4.2.2.0";
    }

    public abstract int setLogFile(String var1);

    public abstract int setLogFilter(int var1);

    public abstract int setLogFileSize(int var1);

    public abstract int getConnectionState();

    public abstract int setParameters(String var1);

    public abstract String getErrorDescription(int var1);

    public abstract String getCallId();

    public abstract int enableFaceDetection(boolean var1);

    @Deprecated
    public abstract int setLocalVoiceReverbPreset(int var1);

    public abstract int setAudioEffectPreset(int var1);

    public abstract int setVoiceBeautifierPreset(int var1);

    public abstract int startAudioMixing(String var1, boolean var2, boolean var3, int var4);

    public abstract int stopAudioMixing();

    public abstract int pauseAudioMixing();

    public abstract int resumeAudioMixing();

    public abstract int adjustAudioMixingVolume(int var1);

    public abstract int adjustAudioMixingPlayoutVolume(int var1);

    public abstract int adjustAudioMixingPublishVolume(int var1);

    public abstract int getAudioMixingPlayoutVolume();

    public abstract int getAudioMixingPublishVolume();

    public abstract IAudioEffectManager getAudioEffectManager();

    public abstract void setExternalVideoSource(boolean var1, boolean var2, boolean var3);

    public abstract boolean pushExternalVideoFrame(ARVideoFrame var1);

    public abstract boolean isTextureEncodeSupported();

    public abstract int setVideoSource(IVideoSource var1);

    public abstract int setExternalAudioSource(boolean var1, int var2, int var3);

    public abstract int pushExternalAudioFrame(byte[] var1, long var2);

    public abstract int registerAudioFrameObserver(IAudioFrameObserver var1);

    public abstract RtcChannel createRtcChannel(String var1);

    public abstract int startEchoTest(int var1);

    public abstract int stopEchoTest();

    public abstract int enableLastmileTest();

    public abstract int disableLastmileTest();

    public abstract int startLastmileProbeTest(LastmileProbeConfig var1);

    public abstract int stopLastmileProbeTest();

    public abstract int addInjectStreamUrl(String var1, LiveInjectStreamConfig var2);

    public abstract int removeInjectStreamUrl(String var1);

    public abstract int addPublishStreamUrl(String var1, boolean var2);

    public abstract int removePublishStreamUrl(String var1);

    public abstract int setLiveTranscoding(LiveTranscoding var1);

    public abstract int startChannelMediaRelay(ChannelMediaRelayConfiguration var1);

    public abstract int stopChannelMediaRelay();

    public abstract int updateChannelMediaRelay(ChannelMediaRelayConfiguration var1);

    public abstract int setRemoteUserPriority(String var1, int var2);

    public abstract int setLocalPublishFallbackOption(int var1);

    public abstract int setRemoteSubscribeFallbackOption(int var1);

    public abstract int setLocalVideoRenderer(IVideoSink var1);

    public abstract int setRemoteVideoRenderer(String var1, IVideoSink var2);

    public abstract int setLocalVoiceEqualization(int var1, int var2);

    public abstract int enableEncryption(boolean var1, EncryptionConfig var2);

    public abstract long getNativehanlde();

    protected abstract int release();

    public static int destroy() {
        if (mInstance != null) {
            mInstance.doDestroy();
            mInstance = null;
            System.gc();
            return 0;
        }
        return -1;
    }
}

