/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.gl;

import android.opengl.GLES20;
import java.nio.Buffer;
import org.webrtc.GlUtil;

public class ARGlTextureFrameBuffer {
    private final int frameBufferId;
    private final int textureId;
    private final int pixelFormat;
    private int width;
    private int height;

    public ARGlTextureFrameBuffer(int var1) {
        switch (var1) {
            case 6407: 
            case 6408: 
            case 6409: {
                this.pixelFormat = var1;
                this.textureId = GlUtil.generateTexture(3553);
                this.width = 0;
                this.height = 0;
                int[] var2 = new int[1];
                GLES20.glGenFramebuffers((int)1, (int[])var2, (int)0);
                this.frameBufferId = var2[0];
                return;
            }
        }
        throw new IllegalArgumentException("Invalid pixel format: " + var1);
    }

    public void setSize(int var1, int var2) {
        if (var1 != 0 && var2 != 0) {
            if (var1 != this.width || var2 != this.height) {
                this.width = var1;
                this.height = var2;
                GLES20.glActiveTexture((int)33984);
                GLES20.glBindTexture((int)3553, (int)this.textureId);
                GLES20.glTexImage2D((int)3553, (int)0, (int)this.pixelFormat, (int)var1, (int)var2, (int)0, (int)this.pixelFormat, (int)5121, (Buffer)null);
                GLES20.glBindTexture((int)3553, (int)0);
                GlUtil.checkNoGLES2Error("GlTextureFrameBuffer setSize");
                GLES20.glBindFramebuffer((int)36160, (int)this.frameBufferId);
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.textureId, (int)0);
                int var3 = GLES20.glCheckFramebufferStatus((int)36160);
                if (var3 != 36053) {
                    throw new IllegalStateException("Framebuffer not complete, status: " + var3);
                }
                GLES20.glBindFramebuffer((int)36160, (int)0);
            }
        } else {
            throw new IllegalArgumentException("Invalid size: " + var1 + "x" + var2);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrameBufferId() {
        return this.frameBufferId;
    }

    public int getTextureId() {
        return this.textureId;
    }

    public void release() {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.textureId}, (int)0);
        GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{this.frameBufferId}, (int)0);
        this.width = 0;
        this.height = 0;
    }
}

