/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.gl;

import java.nio.ByteBuffer;
import org.ar.rtc.gl.VideoFrame;

public class ARJavaI420Buffer
implements VideoFrame.I420Buffer {
    private final int width;
    private final int height;
    private final ByteBuffer dataY;
    private final ByteBuffer dataU;
    private final ByteBuffer dataV;
    private final int strideY;
    private final int strideU;
    private final int strideV;
    private final Runnable releaseCallback;
    private final Object refCountLock = new Object();
    private int refCount;

    private ARJavaI420Buffer(int var1, int var2, ByteBuffer var3, int var4, ByteBuffer var5, int var6, ByteBuffer var7, int var8, Runnable var9) {
        this.width = var1;
        this.height = var2;
        this.dataY = var3;
        this.dataU = var5;
        this.dataV = var7;
        this.strideY = var4;
        this.strideU = var6;
        this.strideV = var8;
        this.releaseCallback = var9;
        this.refCount = 1;
    }

    public static ARJavaI420Buffer wrap(int var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, ByteBuffer var6, int var7, Runnable var8) {
        if (var2 != null && var4 != null && var6 != null) {
            if (var2.isDirect() && var4.isDirect() && var6.isDirect()) {
                var2 = var2.slice();
                var4 = var4.slice();
                var6 = var6.slice();
                int var9 = (var1 + 1) / 2;
                int var10 = var3 * var1;
                int var11 = var5 * var9;
                int var12 = var7 * var9;
                if (var2.capacity() < var10) {
                    throw new IllegalArgumentException("Y-buffer must be at least " + var10 + " bytes.");
                }
                if (var4.capacity() < var11) {
                    throw new IllegalArgumentException("U-buffer must be at least " + var11 + " bytes.");
                }
                if (var6.capacity() < var12) {
                    throw new IllegalArgumentException("V-buffer must be at least " + var12 + " bytes.");
                }
                return new ARJavaI420Buffer(var0, var1, var2, var3, var4, var5, var6, var7, var8);
            }
            throw new IllegalArgumentException("Data buffers must be direct byte buffers.");
        }
        throw new IllegalArgumentException("Data buffers cannot be null.");
    }

    public static ARJavaI420Buffer createYUV(byte[] var0, int var1, int var2) {
        if (var0 != null && var0.length != 0) {
            ARJavaI420Buffer var3 = ARJavaI420Buffer.allocate(var1, var2);
            ByteBuffer var4 = var3.getDataY();
            ByteBuffer var5 = var3.getDataU();
            ByteBuffer var6 = var3.getDataV();
            int var7 = (var2 + 1) / 2;
            int var8 = var2 * var3.getStrideY();
            int var9 = var7 * var3.getStrideU();
            int var10 = var7 * var3.getStrideV();
            var4.put(var0, 0, var8);
            var5.put(var0, var8, var9);
            var6.put(var0, var8 + var9, var10);
            return var3;
        }
        return null;
    }

    public static ARJavaI420Buffer allocate(int var0, int var1) {
        int var2 = (var1 + 1) / 2;
        int var3 = (var0 + 1) / 2;
        int var4 = 0;
        int var5 = var4 + var0 * var1;
        int var6 = var5 + var3 * var2;
        ByteBuffer var7 = ByteBuffer.allocateDirect(var0 * var1 + 2 * var3 * var2);
        var7.position(var4);
        var7.limit(var5);
        ByteBuffer var8 = var7.slice();
        var7.position(var5);
        var7.limit(var6);
        ByteBuffer var9 = var7.slice();
        var7.position(var6);
        var7.limit(var6 + var3 * var2);
        ByteBuffer var10 = var7.slice();
        return new ARJavaI420Buffer(var0, var1, var8, var0, var9, var3, var10, var3, null);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public ByteBuffer getDataU() {
        return this.dataU.slice();
    }

    @Override
    public ByteBuffer getDataV() {
        return this.dataV.slice();
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getStrideU() {
        return this.strideU;
    }

    @Override
    public int getStrideV() {
        return this.strideV;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        this.retain();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retain() {
        Object object = this.refCountLock;
        synchronized (object) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.refCountLock;
        synchronized (object) {
            if (--this.refCount == 0 && this.releaseCallback != null) {
                this.releaseCallback.run();
            }
        }
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int var1, int var2, int var3, int var4, int var5, int var6) {
        return VideoFrame.cropAndScaleI420(this, var1, var2, var3, var4, var5, var6);
    }
}

