/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.gl;

import android.graphics.Point;
import android.opengl.Matrix;
import android.view.View;

public class ARRendererCommon {
    private static float BALANCED_VISIBLE_FRACTION = 0.5625f;

    public static final float[] identityMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static final float[] verticalFlipMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    }

    public static final float[] horizontalFlipMatrix() {
        return new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    }

    public static float[] rotateTextureMatrix(float[] var0, float var1) {
        float[] var2 = new float[16];
        Matrix.setRotateM((float[])var2, (int)0, (float)var1, (float)0.0f, (float)0.0f, (float)1.0f);
        ARRendererCommon.adjustOrigin(var2);
        return ARRendererCommon.multiplyMatrices(var0, var2);
    }

    public static float[] multiplyMatrices(float[] var0, float[] var1) {
        float[] var2 = new float[16];
        Matrix.multiplyMM((float[])var2, (int)0, (float[])var0, (int)0, (float[])var1, (int)0);
        return var2;
    }

    public static float[] getLayoutMatrix(boolean var0, float var1, float var2) {
        float var3 = 1.0f;
        float var4 = 1.0f;
        if (var2 > var1) {
            var4 = var1 / var2;
        } else {
            var3 = var2 / var1;
        }
        if (var0) {
            var3 *= -1.0f;
        }
        float[] var5 = new float[16];
        Matrix.setIdentityM((float[])var5, (int)0);
        Matrix.scaleM((float[])var5, (int)0, (float)var3, (float)var4, (float)1.0f);
        ARRendererCommon.adjustOrigin(var5);
        return var5;
    }

    public static android.graphics.Matrix convertMatrixToAndroidGraphicsMatrix(float[] var0) {
        float[] var1 = new float[]{var0[0], var0[4], var0[12], var0[1], var0[5], var0[13], var0[3], var0[7], var0[15]};
        android.graphics.Matrix var2 = new android.graphics.Matrix();
        var2.setValues(var1);
        return var2;
    }

    public static float[] convertMatrixFromAndroidGraphicsMatrix(android.graphics.Matrix var0) {
        float[] var1 = new float[9];
        var0.getValues(var1);
        float[] var2 = new float[]{var1[0], var1[3], 0.0f, var1[6], var1[1], var1[4], 0.0f, var1[7], 0.0f, 0.0f, 1.0f, 0.0f, var1[2], var1[5], 0.0f, var1[8]};
        return var2;
    }

    public static Point getDisplaySize(ScalingType var0, float var1, int var2, int var3) {
        return ARRendererCommon.getDisplaySize(ARRendererCommon.convertScalingTypeToVisibleFraction(var0), var1, var2, var3);
    }

    private static void adjustOrigin(float[] var0) {
        var0[12] = var0[12] - 0.5f * (var0[0] + var0[4]);
        var0[13] = var0[13] - 0.5f * (var0[1] + var0[5]);
        var0[12] = var0[12] + 0.5f;
        var0[13] = var0[13] + 0.5f;
    }

    private static float convertScalingTypeToVisibleFraction(ScalingType var0) {
        switch (var0) {
            case SCALE_ASPECT_FIT: {
                return 1.0f;
            }
            case SCALE_ASPECT_FILL: {
                return 0.0f;
            }
            case SCALE_ASPECT_BALANCED: {
                return BALANCED_VISIBLE_FRACTION;
            }
        }
        throw new IllegalArgumentException();
    }

    private static Point getDisplaySize(float var0, float var1, int var2, int var3) {
        if (var0 != 0.0f && var1 != 0.0f) {
            int var4 = Math.min(var2, Math.round((float)var3 / var0 * var1));
            int var5 = Math.min(var3, Math.round((float)var2 / var0 / var1));
            return new Point(var4, var5);
        }
        return new Point(var2, var3);
    }

    public static interface RendererEvents {
        public void onFirstFrameRendered();

        public void onFrameResolutionChanged(int var1, int var2, int var3);
    }

    public static interface GlDrawer {
        public void drawOes(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void drawRgb(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void drawYuv(int[] var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void release();
    }

    public static class VideoLayoutMeasure {
        private ScalingType scalingTypeMatchOrientation = ScalingType.SCALE_ASPECT_BALANCED;
        private ScalingType scalingTypeMismatchOrientation = ScalingType.SCALE_ASPECT_BALANCED;

        public void setScalingType(ScalingType var1) {
            this.scalingTypeMatchOrientation = var1;
            this.scalingTypeMismatchOrientation = var1;
        }

        public void setScalingType(ScalingType var1, ScalingType var2) {
            this.scalingTypeMatchOrientation = var1;
            this.scalingTypeMismatchOrientation = var2;
        }

        public Point measure(int var1, int var2, int var3, int var4) {
            int var5 = View.getDefaultSize((int)Integer.MAX_VALUE, (int)var1);
            int var6 = View.getDefaultSize((int)Integer.MAX_VALUE, (int)var2);
            if (var3 != 0 && var4 != 0 && var5 != 0 && var6 != 0) {
                float var7 = (float)var3 / (float)var4;
                float var8 = (float)var5 / (float)var6;
                ScalingType var9 = var7 > 1.0f == var8 > 1.0f ? this.scalingTypeMatchOrientation : this.scalingTypeMismatchOrientation;
                Point var10 = ARRendererCommon.getDisplaySize(var9, var7, var5, var6);
                if (View.MeasureSpec.getMode((int)var1) == 0x40000000) {
                    var10.x = var5;
                }
                if (View.MeasureSpec.getMode((int)var2) == 0x40000000) {
                    var10.y = var6;
                }
                return var10;
            }
            return new Point(var5, var6);
        }
    }

    public static enum ScalingType {
        SCALE_ASPECT_FIT,
        SCALE_ASPECT_FILL,
        SCALE_ASPECT_BALANCED;

    }
}

