/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.gl;

import android.graphics.Matrix;
import android.graphics.Point;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.ar.rtc.gl.ARGlUtil;
import org.ar.rtc.gl.ARRendererCommon;
import org.ar.rtc.gl.ARRgbaBuffer;
import org.ar.rtc.gl.VideoFrame;

public class ARVideoFrameDrawer {
    static final float[] srcPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    private final float[] dstPoints = new float[6];
    private final Point renderSize = new Point();
    private int renderWidth;
    private int renderHeight;
    private final YuvUploader yuvUploader = new YuvUploader();
    private VideoFrame lastI420Frame;
    private VideoFrame lastRgbaFrame;
    private final Matrix renderMatrix = new Matrix();
    private final RGBAUploader rgbaUploader = new RGBAUploader();

    static void drawTexture(ARRendererCommon.GlDrawer var0, VideoFrame.TextureBuffer var1, Matrix var2, int var3, int var4, int var5, int var6, int var7, int var8) {
        Matrix var9 = new Matrix(var1.getTransformMatrix());
        var9.preConcat(var2);
        float[] var10 = ARRendererCommon.convertMatrixFromAndroidGraphicsMatrix(var9);
        switch (var1.getType()) {
            case OES: {
                var0.drawOes(var1.getTextureId(), var10, var3, var4, var5, var6, var7, var8);
                break;
            }
            case RGB: {
                var0.drawRgb(var1.getTextureId(), var10, var3, var4, var5, var6, var7, var8);
                break;
            }
            default: {
                throw new RuntimeException("Unknown texture type.");
            }
        }
    }

    private static int distance(float var0, float var1, float var2, float var3) {
        return (int)Math.round(Math.hypot(var2 - var0, var3 - var1));
    }

    private void calculateTransformedRenderSize(int var1, int var2, Matrix var3) {
        if (var3 == null) {
            this.renderWidth = var1;
            this.renderHeight = var2;
        } else {
            var3.mapPoints(this.dstPoints, srcPoints);
            for (int var4 = 0; var4 < 3; ++var4) {
                float[] var10000 = this.dstPoints;
                int n = var4 * 2 + 0;
                var10000[n] = var10000[n] * (float)var1;
                var10000 = this.dstPoints;
                int n2 = var4 * 2 + 1;
                var10000[n2] = var10000[n2] * (float)var2;
            }
            this.renderWidth = ARVideoFrameDrawer.distance(this.dstPoints[0], this.dstPoints[1], this.dstPoints[2], this.dstPoints[3]);
            this.renderHeight = ARVideoFrameDrawer.distance(this.dstPoints[0], this.dstPoints[1], this.dstPoints[4], this.dstPoints[5]);
        }
    }

    public void drawFrame(VideoFrame var1, ARRendererCommon.GlDrawer var2) {
        this.drawFrame(var1, var2, null);
    }

    public void drawFrame(VideoFrame var1, ARRendererCommon.GlDrawer var2, Matrix var3) {
        this.drawFrame(var1, var2, var3, 0, 0, var1.getRotatedWidth(), var1.getRotatedHeight());
    }

    public void drawFrame(VideoFrame var1, ARRendererCommon.GlDrawer var2, Matrix var3, int var4, int var5, int var6, int var7) {
        int var8 = var1.getRotatedWidth();
        int var9 = var1.getRotatedHeight();
        this.calculateTransformedRenderSize(var8, var9, var3);
        boolean var10 = var1.getBuffer() instanceof VideoFrame.TextureBuffer;
        boolean var11 = var1.getBuffer() instanceof ARRgbaBuffer;
        this.renderMatrix.reset();
        this.renderMatrix.preTranslate(0.5f, 0.5f);
        if (!var10) {
            this.renderMatrix.preScale(1.0f, -1.0f);
        }
        this.renderMatrix.preRotate((float)var1.getRotation());
        this.renderMatrix.preTranslate(-0.5f, -0.5f);
        if (var3 != null) {
            this.renderMatrix.preConcat(var3);
        }
        if (var10) {
            this.lastI420Frame = null;
            this.lastRgbaFrame = null;
            ARVideoFrameDrawer.drawTexture(var2, (VideoFrame.TextureBuffer)var1.getBuffer(), this.renderMatrix, this.renderWidth, this.renderHeight, var4, var5, var6, var7);
        } else if (var11) {
            if (var1 != this.lastRgbaFrame) {
                this.lastRgbaFrame = var1;
                ARRgbaBuffer var12 = (ARRgbaBuffer)var1.getBuffer();
                this.rgbaUploader.uploadData(var12.getBuffer(), var12.getWidth(), var12.getHeight());
                var12.release();
            }
            var2.drawRgb(this.rgbaUploader.getTextureId(), ARRendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.renderMatrix), this.renderWidth, this.renderHeight, var4, var5, var6, var7);
        } else {
            if (var1 != this.lastI420Frame) {
                this.lastI420Frame = var1;
                VideoFrame.I420Buffer var13 = var1.getBuffer().toI420();
                this.yuvUploader.uploadFromBuffer(var13);
                var13.release();
            }
            var2.drawYuv(this.yuvUploader.getYuvTextures(), ARRendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.renderMatrix), this.renderWidth, this.renderHeight, var4, var5, var6, var7);
        }
    }

    public void release() {
        this.yuvUploader.release();
        this.lastI420Frame = null;
        this.rgbaUploader.release();
        this.lastRgbaFrame = null;
    }

    private static class YuvUploader {
        private ByteBuffer copyBuffer;
        private int[] yuvTextures;

        private YuvUploader() {
        }

        public int[] uploadYuvData(int var1, int var2, int[] var3, ByteBuffer[] var4) {
            int var8;
            int[] var5 = new int[]{var1, var1 / 2, var1 / 2};
            int[] var6 = new int[]{var2, var2 / 2, var2 / 2};
            int var7 = 0;
            for (var8 = 0; var8 < 3; ++var8) {
                if (var3[var8] <= var5[var8]) continue;
                var7 = Math.max(var7, var5[var8] * var6[var8]);
            }
            if (var7 > 0 && (this.copyBuffer == null || this.copyBuffer.capacity() < var7)) {
                this.copyBuffer = ByteBuffer.allocateDirect(var7);
            }
            if (this.yuvTextures == null) {
                this.yuvTextures = new int[3];
                for (var8 = 0; var8 < 3; ++var8) {
                    this.yuvTextures[var8] = ARGlUtil.generateTexture(3553);
                }
            }
            for (var8 = 0; var8 < 3; ++var8) {
                GLES20.glActiveTexture((int)(33984 + var8));
                GLES20.glBindTexture((int)3553, (int)this.yuvTextures[var8]);
                ByteBuffer var9 = var3[var8] == var5[var8] ? var4[var8] : this.copyBuffer;
                GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)var5[var8], (int)var6[var8], (int)0, (int)6409, (int)5121, (Buffer)var9);
            }
            return this.yuvTextures;
        }

        public int[] uploadFromBuffer(VideoFrame.I420Buffer var1) {
            int[] var2 = new int[]{var1.getStrideY(), var1.getStrideU(), var1.getStrideV()};
            ByteBuffer[] var3 = new ByteBuffer[]{var1.getDataY(), var1.getDataU(), var1.getDataV()};
            return this.uploadYuvData(var1.getWidth(), var1.getHeight(), var2, var3);
        }

        public int[] getYuvTextures() {
            return this.yuvTextures;
        }

        public void release() {
            this.copyBuffer = null;
            if (this.yuvTextures != null) {
                GLES20.glDeleteTextures((int)3, (int[])this.yuvTextures, (int)0);
                this.yuvTextures = null;
            }
        }
    }

    private static class RGBAUploader {
        private int mTextureId = 0;
        private ByteBuffer mData;

        private RGBAUploader() {
        }

        public int uploadData(ByteBuffer var1, int var2, int var3) {
            this.mData = var1;
            if (this.mTextureId == 0) {
                this.mTextureId = ARGlUtil.generateTexture(3553);
            }
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.mTextureId);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)var2, (int)var3, (int)0, (int)6408, (int)5121, (Buffer)this.mData);
            ARGlUtil.checkNoGLES2Error("glTexImage2D");
            return this.mTextureId;
        }

        public int getTextureId() {
            return this.mTextureId;
        }

        public void release() {
            this.mData = null;
            if (this.mTextureId != 0) {
                GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mTextureId}, (int)0);
            }
        }
    }
}

