/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.gl;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.ar.rtc.gl.ARGlShader;
import org.ar.rtc.gl.ARGlTextureFrameBuffer;
import org.ar.rtc.gl.ARGlUtil;
import org.ar.rtc.gl.ARJavaI420Buffer;
import org.ar.rtc.gl.ARRendererCommon;
import org.ar.rtc.gl.VideoFrame;
import org.ar.rtc.utils.ThreadUtils;

public class ARYuvConverter {
    private static final FloatBuffer DEVICE_RECTANGLE = ARGlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer TEXTURE_RECTANGLE = ARGlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private static final String VERTEX_SHADER = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
    private static final String OES_FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES tex;\nuniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 1.5 * xUnit).rgb);\n}\n";
    private static final String RGB_FRAGMENT_SHADER = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D tex;\nuniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 1.5 * xUnit).rgb);\n}\n";
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final ARGlTextureFrameBuffer textureFrameBuffer;
    private VideoFrame.TextureBuffer.Type shaderTextureType;
    private ARGlShader shader;
    private int texMatrixLoc;
    private int xUnitLoc;
    private int coeffsLoc;
    private boolean released = false;

    public ARYuvConverter() {
        this.threadChecker.checkIsOnValidThread();
        this.textureFrameBuffer = new ARGlTextureFrameBuffer(6408);
    }

    public VideoFrame.I420Buffer convert(VideoFrame.TextureBuffer var1) {
        int var2 = var1.getWidth();
        int var3 = var1.getHeight();
        int var4 = (var2 + 7) / 8 * 8;
        int var5 = (var3 + 1) / 2;
        int var6 = var4 * (var3 + var5 + 1);
        ByteBuffer var7 = ByteBuffer.allocateDirect(var6);
        this.convert(var7, var2, var3, var4, var1.getTextureId(), ARRendererCommon.convertMatrixFromAndroidGraphicsMatrix(var1.getTransformMatrix()), var1.getType());
        int var9 = 0 + var4 * var3;
        int var10 = var9 + var4 / 2;
        var7.position(0);
        var7.limit(0 + var4 * var3);
        ByteBuffer var11 = var7.slice();
        var7.position(var9);
        var7.limit(var9 + var4 * var5);
        ByteBuffer var12 = var7.slice();
        var7.position(var10);
        var7.limit(var10 + var4 * var5);
        ByteBuffer var13 = var7.slice();
        return ARJavaI420Buffer.wrap(var2, var3, var11, var4, var12, var4, var13, var4, null);
    }

    @Deprecated
    void convert(ByteBuffer var1, int var2, int var3, int var4, int var5, float[] var6) {
        this.convert(var1, var2, var3, var4, var5, var6, VideoFrame.TextureBuffer.Type.OES);
    }

    private void initShader(VideoFrame.TextureBuffer.Type var1) {
        String var2;
        if (this.shader != null) {
            this.shader.release();
        }
        switch (var1) {
            case OES: {
                var2 = OES_FRAGMENT_SHADER;
                break;
            }
            case RGB: {
                var2 = RGB_FRAGMENT_SHADER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported texture type.");
            }
        }
        this.shaderTextureType = var1;
        this.shader = new ARGlShader(VERTEX_SHADER, var2);
        this.shader.useProgram();
        this.texMatrixLoc = this.shader.getUniformLocation("texMatrix");
        this.xUnitLoc = this.shader.getUniformLocation("xUnit");
        this.coeffsLoc = this.shader.getUniformLocation("coeffs");
        GLES20.glUniform1i((int)this.shader.getUniformLocation("tex"), (int)0);
        ARGlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
        this.shader.setVertexAttribArray("in_pos", 2, DEVICE_RECTANGLE);
        this.shader.setVertexAttribArray("in_tc", 2, TEXTURE_RECTANGLE);
    }

    private void convert(ByteBuffer var1, int var2, int var3, int var4, int var5, float[] var6, VideoFrame.TextureBuffer.Type var7) {
        this.threadChecker.checkIsOnValidThread();
        if (this.released) {
            throw new IllegalStateException("YuvConverter.convert called on released object");
        }
        if (var7 != this.shaderTextureType) {
            this.initShader(var7);
        }
        this.shader.useProgram();
        if (var4 % 8 != 0) {
            throw new IllegalArgumentException("Invalid stride, must be a multiple of 8");
        }
        if (var4 < var2) {
            throw new IllegalArgumentException("Invalid stride, must >= width");
        }
        int var8 = (var2 + 3) / 4;
        int var9 = (var2 + 7) / 8;
        int var10 = (var3 + 1) / 2;
        int var11 = var3 + var10;
        int var12 = var4 * var11;
        if (var1.capacity() < var12) {
            throw new IllegalArgumentException("YuvConverter.convert called with too small buffer");
        }
        var6 = ARRendererCommon.multiplyMatrices(var6, ARRendererCommon.verticalFlipMatrix());
        int var13 = var4 / 4;
        this.textureFrameBuffer.setSize(var13, var11);
        GLES20.glBindFramebuffer((int)36160, (int)this.textureFrameBuffer.getFrameBufferId());
        ARGlUtil.checkNoGLES2Error("glBindFramebuffer");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)var7.getGlTarget(), (int)var5);
        GLES20.glUniformMatrix4fv((int)this.texMatrixLoc, (int)1, (boolean)false, (float[])var6, (int)0);
        GLES20.glViewport((int)0, (int)0, (int)var8, (int)var3);
        GLES20.glUniform2f((int)this.xUnitLoc, (float)(var6[0] / (float)var2), (float)(var6[1] / (float)var2));
        GLES20.glUniform4f((int)this.coeffsLoc, (float)0.299f, (float)0.587f, (float)0.114f, (float)0.0f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glViewport((int)0, (int)var3, (int)var9, (int)var10);
        GLES20.glUniform2f((int)this.xUnitLoc, (float)(2.0f * var6[0] / (float)var2), (float)(2.0f * var6[1] / (float)var2));
        GLES20.glUniform4f((int)this.coeffsLoc, (float)-0.169f, (float)-0.331f, (float)0.499f, (float)0.5f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glViewport((int)(var4 / 8), (int)var3, (int)var9, (int)var10);
        GLES20.glUniform4f((int)this.coeffsLoc, (float)0.499f, (float)-0.418f, (float)-0.0813f, (float)0.5f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glReadPixels((int)0, (int)0, (int)var13, (int)var11, (int)6408, (int)5121, (Buffer)var1);
        ARGlUtil.checkNoGLES2Error("YuvConverter.convert");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindTexture((int)var7.getGlTarget(), (int)0);
    }

    public void release() {
        this.threadChecker.checkIsOnValidThread();
        this.released = true;
        if (this.shader != null) {
            this.shader.release();
        }
        this.textureFrameBuffer.release();
    }
}

