/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.internal;

import android.content.Context;
import android.util.Log;
import org.ar.rtc.IRtcEngineEventHandler;
import org.ar.rtc.RtcChannel;
import org.ar.rtc.RtcEngineImpl;
import org.ar.rtc.internal.JNIRtcChannelEventHandler;
import org.ar.rtc.models.ChannelMediaOptions;

public class RtcChannelImpl
extends RtcChannel {
    private long mNativeHandle = 0L;
    private boolean mInitialized = false;
    private RtcEngineImpl mRtcEngineImpl = null;
    private boolean mJoined = false;

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public boolean hasJoined() {
        return this.mJoined;
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    public int initialize(RtcEngineImpl rtcEngineImpl, long nativeHandle) {
        this.mRtcEngineImpl = rtcEngineImpl;
        this.mNativeHandle = nativeHandle;
        this.mInitialized = true;
        this.nativeRtcChannelSetEvent(this.mNativeHandle, new ChannelEvent());
        return 0;
    }

    @Override
    public int destroy() {
        if (this.mInitialized) {
            int ret = this.mRtcEngineImpl.destroyRtcChannel(this.channelId());
            this.mInitialized = false;
            return ret;
        }
        return -7;
    }

    @Override
    public String channelId() {
        return !this.mInitialized ? "" : this.nativeRtcChannelChannelId(this.mNativeHandle);
    }

    @Override
    public String getCallId() {
        return !this.mInitialized ? "" : this.nativeRtcChannelGetCallId(this.mNativeHandle);
    }

    @Override
    public int getConnectionState() {
        return !this.mInitialized ? 1 : this.nativeRtcChannelGetConncetionState(this.mNativeHandle);
    }

    @Override
    public int joinChannel(String token, String optionalInfo, String uid, ChannelMediaOptions options) {
        if (!this.mInitialized) {
            return -7;
        }
        Context context = this.mRtcEngineImpl.getContext();
        if (context == null) {
            return -7;
        }
        this.mJoined = true;
        return this.nativeRtcChannelJoinChannel(this.mNativeHandle, token, optionalInfo, uid, options == null ? true : options.autoSubscribeAudio, options == null ? true : options.autoSubscribeVideo);
    }

    @Override
    public int leaveChannel() {
        if (!this.mInitialized) {
            return -7;
        }
        this.mJoined = false;
        return this.nativeRtcChannelLeaveChannel(this.mNativeHandle);
    }

    @Override
    public int publish() {
        return !this.mInitialized ? -7 : this.nativeRtcChannelPublish(this.mNativeHandle);
    }

    @Override
    public int unpublish() {
        return !this.mInitialized ? -7 : this.nativeRtcChannelUnpublish(this.mNativeHandle);
    }

    @Override
    public int renewToken(String token) {
        return !this.mInitialized ? -7 : this.nativeRtcChannelRenewToken(this.mNativeHandle, token);
    }

    @Override
    public int setClientRole(int role) {
        return !this.mInitialized ? -7 : this.nativeRtcChannelSetClientRole(this.mNativeHandle, role);
    }

    @Override
    public int setRemoteRenderMode(String uid, int renderMode, int mirrorMode) {
        return this.mRtcEngineImpl.setRemoteRenderMode(uid, renderMode, mirrorMode);
    }

    @Override
    public int setDefaultMuteAllRemoteAudioStreams(boolean muted) {
        return !this.mInitialized ? -7 : this.nativeRtcChannelSetDefaultMuteAllRemoteAudioStreams(this.mNativeHandle, muted);
    }

    @Override
    public int setDefaultMuteAllRemoteVideoStreams(boolean muted) {
        return !this.mInitialized ? -7 : this.nativeRtcChannelSetDefaultMuteAllRemoteVideoStreams(this.mNativeHandle, muted);
    }

    @Override
    public int muteAllRemoteAudioStreams(boolean muted) {
        return !this.mInitialized ? -7 : this.nativeRtcChannelMuteAllRemoteAudioStreams(this.mNativeHandle, muted);
    }

    @Override
    public int adjustUserPlaybackSignalVolume(String uid, int volume) {
        return !this.mInitialized ? -7 : this.nativeRtcChannelAdjustUserPlaybackSignalVolume(this.mNativeHandle, uid, volume);
    }

    @Override
    public int muteRemoteAudioStream(String uid, boolean muted) {
        return !this.mInitialized ? -7 : this.nativeRtcChannelMuteRemoteAudioStream(this.mNativeHandle, uid, muted);
    }

    @Override
    public int muteAllRemoteVideoStreams(boolean muted) {
        return !this.mInitialized ? -7 : this.nativeRtcChannelMuteAllRemoteVideoStreams(this.mNativeHandle, muted);
    }

    @Override
    public int muteRemoteVideoStream(String uid, boolean muted) {
        return !this.mInitialized ? -7 : this.nativeRtcChannelMuteRemoteVideoStream(this.mNativeHandle, uid, muted);
    }

    @Override
    public int setRemoteVideoStreamType(String uid, int streamType) {
        return !this.mInitialized ? -7 : this.nativeRtcChannelSetRemoteVideoStreamType(this.mNativeHandle, uid, streamType);
    }

    @Override
    public int setRemoteDefaultVideoStreamType(int streamType) {
        return !this.mInitialized ? -7 : this.nativeRtcChannelSetRemoteDefaultVideoStreamType(this.mNativeHandle, streamType);
    }

    private native String nativeRtcChannelChannelId(long var1);

    private native String nativeRtcChannelGetCallId(long var1);

    private native int nativeRtcChannelSetEvent(long var1, Object var3);

    private native int nativeRtcChannelJoinChannel(long var1, String var3, String var4, String var5, boolean var6, boolean var7);

    private native int nativeRtcChannelLeaveChannel(long var1);

    private native int nativeRtcChannelPublish(long var1);

    private native int nativeRtcChannelUnpublish(long var1);

    private native int nativeRtcChannelRenewToken(long var1, String var3);

    private native int nativeRtcChannelSetClientRole(long var1, int var3);

    private native int nativeRtcChannelSetDefaultMuteAllRemoteAudioStreams(long var1, boolean var3);

    private native int nativeRtcChannelSetDefaultMuteAllRemoteVideoStreams(long var1, boolean var3);

    private native int nativeRtcChannelMuteAllRemoteAudioStreams(long var1, boolean var3);

    private native int nativeRtcChannelMuteRemoteAudioStream(long var1, String var3, boolean var4);

    private native int nativeRtcChannelAdjustUserPlaybackSignalVolume(long var1, String var3, int var4);

    private native int nativeRtcChannelMuteAllRemoteVideoStreams(long var1, boolean var3);

    private native int nativeRtcChannelMuteRemoteVideoStream(long var1, String var3, boolean var4);

    private native int nativeRtcChannelSetRemoteVideoStreamType(long var1, String var3, int var4);

    private native int nativeRtcChannelSetRemoteDefaultVideoStreamType(long var1, int var3);

    private native int nativeRtcChannelGetConncetionState(long var1);

    private class ChannelEvent
    extends JNIRtcChannelEventHandler {
        private ChannelEvent() {
        }

        @Override
        public void onChannelWarning(int warn) {
            super.onChannelWarning(warn);
            Log.d((String)"RtcChannel", (String)"onChannelWarning");
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onChannelWarning(RtcChannelImpl.this, warn);
            }
        }

        @Override
        public void onChannelError(int err) {
            super.onChannelError(err);
            Log.d((String)"RtcChannel", (String)"onChannelError");
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onChannelError(RtcChannelImpl.this, err);
            }
        }

        @Override
        public void onJoinChannelSuccess(String uid, int elapsed) {
            super.onJoinChannelSuccess(uid, elapsed);
            Log.d((String)"RtcChannel", (String)"onJoinChannelSuccess");
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onJoinChannelSuccess(RtcChannelImpl.this, uid, elapsed);
            }
        }

        @Override
        public void onRejoinChannelSuccess(String uid, int elapsed) {
            super.onRejoinChannelSuccess(uid, elapsed);
            Log.d((String)"RtcChannel", (String)"onRejoinChannelSuccess");
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onRejoinChannelSuccess(RtcChannelImpl.this, uid, elapsed);
            }
        }

        @Override
        public void onLeaveChannel(IRtcEngineEventHandler.RtcStats stats) {
            Log.d((String)"RtcChannel", (String)"onLeaveChannel");
            super.onLeaveChannel(stats);
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onLeaveChannel(RtcChannelImpl.this, stats);
            }
        }

        @Override
        public void onClientRoleChanged(int oldRole, int newRole) {
            super.onClientRoleChanged(oldRole, newRole);
            Log.d((String)"RtcChannel", (String)"onClientRoleChanged");
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onClientRoleChanged(RtcChannelImpl.this, oldRole, newRole);
            }
        }

        @Override
        public void onUserJoined(String uid, int elapsed) {
            super.onUserJoined(uid, elapsed);
            Log.d((String)"RtcChannel", (String)("onUserJoined uid:" + uid));
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onUserJoined(RtcChannelImpl.this, uid, elapsed);
            }
        }

        @Override
        public void onUserOffline(String uid, int reason) {
            super.onUserOffline(uid, reason);
            Log.d((String)"RtcChannel", (String)("onUserOffline uid:" + uid));
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onUserOffline(RtcChannelImpl.this, uid, reason);
            }
        }

        @Override
        public void onConnectionStateChanged(int state, int reason) {
            Log.d((String)"RtcChannel", (String)"onConnectionStateChanged");
            super.onConnectionStateChanged(state, reason);
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onConnectionStateChanged(RtcChannelImpl.this, state, reason);
            }
        }

        @Override
        public void onConnectionLost() {
            Log.d((String)"RtcChannel", (String)"onConnectionLost");
            super.onConnectionLost();
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onConnectionLost(RtcChannelImpl.this);
            }
        }

        @Override
        public void onTokenPrivilegeWillExpire(String token) {
            Log.d((String)"RtcChannel", (String)"onTokenPrivilegeWillExpire");
            super.onTokenPrivilegeWillExpire(token);
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onTokenPrivilegeWillExpire(RtcChannelImpl.this, token);
            }
        }

        @Override
        public void onRequestToken() {
            Log.d((String)"RtcChannel", (String)"onRequestToken");
            super.onRequestToken();
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onRequestToken(RtcChannelImpl.this);
            }
        }

        @Override
        public void onRtcStats(IRtcEngineEventHandler.RtcStats stats) {
            Log.d((String)"RtcChannel", (String)"onRtcStats");
            super.onRtcStats(stats);
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onRtcStats(RtcChannelImpl.this, stats);
            }
        }

        @Override
        public void onNetworkQuality(String uid, int txQuality, int rxQuality) {
            super.onNetworkQuality(uid, txQuality, rxQuality);
            Log.d((String)"RtcChannel", (String)"onNetworkQuality");
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onNetworkQuality(RtcChannelImpl.this, uid, txQuality, rxQuality);
            }
        }

        @Override
        public void onRemoteVideoStats(IRtcEngineEventHandler.RemoteVideoStats stats) {
            super.onRemoteVideoStats(stats);
            Log.d((String)"RtcChannel", (String)"onRemoteVideoStats");
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onRemoteVideoStats(RtcChannelImpl.this, stats);
            }
        }

        @Override
        public void onRemoteAudioStats(IRtcEngineEventHandler.RemoteAudioStats stats) {
            super.onRemoteAudioStats(stats);
            Log.d((String)"RtcChannel", (String)"onRemoteAudioStats");
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onRemoteAudioStats(RtcChannelImpl.this, stats);
            }
        }

        @Override
        public void onRemoteAudioStateChanged(String uid, int state, int reason, int elapsed) {
            super.onRemoteAudioStateChanged(uid, state, reason, elapsed);
            Log.d((String)"RtcChannel", (String)"onRemoteAudioStateChanged");
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onRemoteAudioStateChanged(RtcChannelImpl.this, uid, state, reason, elapsed);
            }
        }

        @Override
        public void onActiveSpeaker(String uid) {
            super.onActiveSpeaker(uid);
            Log.d((String)"RtcChannel", (String)"onActiveSpeaker");
        }

        @Override
        public void onVideoSizeChanged(String uid, int width, int height, int rotation) {
            super.onVideoSizeChanged(uid, width, height, rotation);
            Log.d((String)"RtcChannel", (String)"onVideoSizeChanged");
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onVideoSizeChanged(RtcChannelImpl.this, uid, width, height, rotation);
            }
        }

        @Override
        public void onRemoteVideoStateChanged(String uid, int state, int reason, int elapsed) {
            super.onRemoteVideoStateChanged(uid, state, reason, elapsed);
            Log.d((String)"RtcChannel", (String)"onRemoteVideoStateChanged");
            if (RtcChannelImpl.this.getEventHandler() != null) {
                RtcChannelImpl.this.getEventHandler().onRemoteVideoStateChanged(RtcChannelImpl.this, uid, state, reason, elapsed);
            }
        }
    }
}

