/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.mediaio;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.ImageFormat;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import android.view.WindowManager;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.ar.rtc.mediaio.CameraSource;
import org.ar.rtc.mediaio.CaptureParameters;
import org.ar.rtc.mediaio.IVideoFrameConsumer;
import org.ar.rtc.mediaio.MediaIO;
import org.webrtc.Logging;

@TargetApi(value=21)
public class ARBufferedCamera2
extends CameraSource {
    private static final String TAG = ARBufferedCamera2.class.getSimpleName();
    private Context mContext;
    private String mCameraId;
    private int cameraOrientation;
    private boolean isCameraFrontFacing;
    private CameraCaptureSession mCaptureSession;
    private CaptureRequest.Builder mPreviewRequestBuilder;
    private CaptureRequest mPreviewRequest;
    private CameraDevice mCameraDevice;
    private CameraCharacteristics mCharacteristics;
    private boolean mFlashSupported;
    private int mState = 0;
    private static final int STATE_PREVIEW = 0;
    private static final int STATE_WAITING_LOCK = 1;
    private static final int STATE_WAITING_PRECAPTURE = 2;
    private static final int STATE_WAITING_NON_PRECAPTURE = 3;
    private HandlerThread mBackgroundThread;
    private Handler mBackgroundHandler;
    private Semaphore mCameraOpenCloseLock = new Semaphore(1);
    private ImageReader mImageReader;
    private byte[] mBufferArrayData;
    private ByteBuffer mByteBufferData;
    private CaptureParameters mParameters;
    private final ImageReader.OnImageAvailableListener mOnImageAvailableListener = new NamelessClass_3();
    private final CameraDevice.StateCallback mStateCallback = new NamelessClass_2();
    private CameraCaptureSession.CaptureCallback mCaptureCallback = new NamelessClass_1();
    private onBitmapListener bitmapListener;

    public void setBitmapListener(onBitmapListener bitmapListener) {
        this.bitmapListener = bitmapListener;
    }

    public byte[] bytebuffer2ByteArray(ByteBuffer buffer) {
        buffer.flip();
        int len = buffer.limit() - buffer.position();
        byte[] bytes = new byte[len];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = buffer.get();
        }
        return bytes;
    }

    public ARBufferedCamera2(Context context) {
        this.mContext = context;
        this.mParameters = new CaptureParameters();
        this.mParameters.width = 640;
        this.mParameters.height = 480;
        this.mParameters.fps = 15;
        this.mParameters.pixelFormat = MediaIO.PixelFormat.I420.intValue();
        this.mParameters.bufferType = MediaIO.BufferType.BYTE_BUFFER.intValue();
        this.mParameters.captureType = MediaIO.CaptureType.CAMERA.intValue();
        this.mParameters.contentHint = MediaIO.ContentHint.NONE.intValue();
    }

    public ARBufferedCamera2(Context context, CaptureParameters parameters) {
        this.mContext = context;
        if (parameters != null) {
            this.mParameters = new CaptureParameters();
            this.mParameters.width = parameters.width;
            this.mParameters.height = parameters.height;
            this.mParameters.fps = parameters.fps;
            this.mParameters.pixelFormat = parameters.pixelFormat;
            this.mParameters.bufferType = parameters.bufferType;
            this.mParameters.captureType = parameters.captureType;
            this.mParameters.contentHint = parameters.contentHint;
        }
    }

    public void useFrontCamera(boolean front) {
        this.isCameraFrontFacing = front;
    }

    @Override
    public boolean onInitialize(IVideoFrameConsumer consumer) {
        this.consumer = consumer;
        this.allocateBuffer(this.mParameters.pixelFormat);
        return true;
    }

    @Override
    public boolean onStart() {
        this.startBackgroundThread();
        this.openCamera(this.mParameters.width, this.mParameters.height);
        return true;
    }

    @Override
    public void onStop() {
        this.doStop();
    }

    @Override
    public void onDispose() {
        this.doStop();
        this.mBufferArrayData = null;
        this.mByteBufferData = null;
    }

    @Override
    public int getBufferType() {
        return this.mParameters.bufferType;
    }

    public int getCaptureType() {
        return this.mParameters.captureType;
    }

    public int getContentHint() {
        return this.mParameters.contentHint;
    }

    @SuppressLint(value={"WrongConstant"})
    private void allocateBuffer(int pixelFormat) {
        int var2 = 0;
        if (pixelFormat == MediaIO.PixelFormat.I420.intValue()) {
            var2 = this.mParameters.width * this.mParameters.height * ImageFormat.getBitsPerPixel((int)17) / 8;
        }
        if (this.mParameters.bufferType == MediaIO.BufferType.BYTE_ARRAY.intValue()) {
            this.mBufferArrayData = new byte[var2];
        } else if (this.mParameters.bufferType == MediaIO.BufferType.BYTE_BUFFER.intValue()) {
            this.mBufferArrayData = new byte[var2];
            this.mByteBufferData = ByteBuffer.allocateDirect(var2);
        }
    }

    private void openCamera(int width, int height) {
        this.setUpCameraOutputs(width, height);
        CameraManager var3 = (CameraManager)this.mContext.getSystemService("camera");
        try {
            if (!this.mCameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Time out waiting to lock camera opening.");
            }
            var3.openCamera(this.mCameraId, this.mStateCallback, this.mBackgroundHandler);
        }
        catch (CameraAccessException var5) {
            Log.e((String)TAG, (String)var5.toString());
        }
        catch (InterruptedException var6) {
            throw new RuntimeException("Interrupted while trying to lock camera opening.", var6);
        }
        catch (SecurityException var7) {
            Log.e((String)TAG, (String)var7.toString());
        }
    }

    private void doStop() {
        this.closeCamera();
        this.stopBackgroundThread();
    }

    private void createCameraPreviewSession() {
        try {
            this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(1);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
            if (this.mFlashSupported) {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
            }
            this.mPreviewRequestBuilder.addTarget(this.mImageReader.getSurface());
            List<Surface> var1 = Arrays.asList(this.mImageReader.getSurface());
            this.mCameraDevice.createCaptureSession(var1, new CameraCaptureSession.StateCallback(){

                public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                    if (null != ARBufferedCamera2.this.mCameraDevice) {
                        ARBufferedCamera2.this.mCaptureSession = cameraCaptureSession;
                        try {
                            ARBufferedCamera2.this.mPreviewRequest = ARBufferedCamera2.this.mPreviewRequestBuilder.build();
                            ARBufferedCamera2.this.mCaptureSession.setRepeatingRequest(ARBufferedCamera2.this.mPreviewRequest, ARBufferedCamera2.this.mCaptureCallback, ARBufferedCamera2.this.mBackgroundHandler);
                        }
                        catch (CameraAccessException | IllegalStateException var3) {
                            var3.printStackTrace();
                        }
                    }
                }

                public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                    Log.e((String)TAG, (String)"Configure camera failed");
                }
            }, (Handler)null);
        }
        catch (CameraAccessException var2) {
            var2.printStackTrace();
        }
    }

    private void setUpCameraOutputs(int width, int height) {
        CameraManager var3 = (CameraManager)this.mContext.getSystemService("camera");
        try {
            String[] var4 = var3.getCameraIdList();
            for (int var5 = 0; var5 < var4.length; ++var5) {
                String var6;
                this.mCameraId = var6 = var4[var5];
                this.mCharacteristics = var3.getCameraCharacteristics(var6);
                this.cameraOrientation = (Integer)this.mCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                Boolean var7 = (Boolean)this.mCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
                boolean bl = this.mFlashSupported = var7 == null ? false : var7;
                if (!this.isCameraFrontFacing || (Integer)this.mCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0) break;
            }
            this.mImageReader = ImageReader.newInstance((int)this.mParameters.width, (int)this.mParameters.height, (int)this.getAndroidImageFormat(this.mParameters.pixelFormat), (int)2);
            this.mImageReader.setOnImageAvailableListener(this.mOnImageAvailableListener, this.mBackgroundHandler);
        }
        catch (CameraAccessException var8) {
            var8.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private int getAndroidImageFormat(int mediaioFormat) {
        int var2 = mediaioFormat == MediaIO.PixelFormat.I420.intValue() ? 35 : 0;
        return var2;
    }

    private static Size chooseOptimalSize(Size[] var0, int var1, int var2, int var3, int var4, Size var5) {
        ArrayList<Size> var6 = new ArrayList<Size>();
        ArrayList<Size> var7 = new ArrayList<Size>();
        int var8 = var5.getWidth();
        int var9 = var5.getHeight();
        Size[] var10 = var0;
        int var11 = var0.length;
        for (int var12 = 0; var12 < var11; ++var12) {
            Size var13 = var10[var12];
            if (var13.getWidth() > var3 || var13.getHeight() > var4 || var13.getHeight() != var13.getWidth() * var9 / var8) continue;
            if (var13.getWidth() >= var1 && var13.getHeight() >= var2) {
                var6.add(var13);
                continue;
            }
            var7.add(var13);
        }
        if (var6.size() > 0) {
            return Collections.min(var6, new CompareSizesByArea());
        }
        if (var7.size() > 0) {
            return Collections.max(var7, new CompareSizesByArea());
        }
        Log.e((String)TAG, (String)"Couldn't find any suitable preview size");
        return var0[0];
    }

    private void closeCamera() {
        try {
            this.mCameraOpenCloseLock.acquire();
            if (null != this.mCaptureSession) {
                this.mCaptureSession.close();
                this.mCaptureSession = null;
            }
            if (null != this.mCameraDevice) {
                this.mCameraDevice.close();
                this.mCameraDevice = null;
            }
            if (null != this.mImageReader) {
                this.mImageReader.close();
                this.mImageReader = null;
            }
        }
        catch (InterruptedException var5) {
            throw new RuntimeException("Interrupted while trying to lock camera closing.", var5);
        }
        finally {
            this.mCameraOpenCloseLock.release();
        }
    }

    private void startBackgroundThread() {
        this.mBackgroundThread = new HandlerThread("CameraBackground");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    private void stopBackgroundThread() {
        if (this.mBackgroundThread != null) {
            this.mBackgroundThread.quitSafely();
            try {
                this.mBackgroundThread.join();
                this.mBackgroundThread = null;
                this.mBackgroundHandler = null;
            }
            catch (InterruptedException var2) {
                var2.printStackTrace();
            }
        }
    }

    private static void readImageIntoBuffer(Image image, byte[] data) {
        int var2 = image.getWidth();
        int var3 = image.getHeight();
        Image.Plane[] var4 = image.getPlanes();
        int var5 = 0;
        for (int var6 = 0; var6 < var4.length; ++var6) {
            int var13;
            int var11;
            ByteBuffer var7 = var4[var6].getBuffer();
            int var8 = var4[var6].getRowStride();
            int var9 = var4[var6].getPixelStride();
            int var10 = var6 == 0 ? var2 : var2 / 2;
            int n = var11 = var6 == 0 ? var3 : var3 / 2;
            if (var9 == 1 && var8 == var10) {
                var7.get(data, var5, var10 * var11);
                var5 += var10 * var11;
                continue;
            }
            byte[] var12 = new byte[var8];
            for (var13 = 0; var13 < var11 - 1; ++var13) {
                var7.get(var12, 0, var8);
                for (int var14 = 0; var14 < var10; ++var14) {
                    data[var5++] = var12[var14 * var9];
                }
            }
            var7.get(var12, 0, Math.min(var8, var7.remaining()));
            for (var13 = 0; var13 < var10; ++var13) {
                data[var5++] = var12[var13 * var9];
            }
        }
    }

    private int getDeviceOrientation() {
        int var3;
        boolean var1 = false;
        WindowManager var2 = (WindowManager)this.mContext.getSystemService("window");
        switch (var2.getDefaultDisplay().getRotation()) {
            default: {
                var3 = 0;
                break;
            }
            case 1: {
                var3 = 90;
                break;
            }
            case 2: {
                var3 = 180;
                break;
            }
            case 3: {
                var3 = 270;
            }
        }
        return var3;
    }

    private int getFrameOrientation() {
        int var1 = this.getDeviceOrientation();
        if (!this.isCameraFrontFacing) {
            var1 = 360 - var1;
        }
        return (this.cameraOrientation + var1) % 360;
    }

    static class CompareSizesByArea
    implements Comparator<Size> {
        CompareSizesByArea() {
        }

        @Override
        public int compare(Size lhs, Size rhs) {
            return Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
        }
    }

    class NamelessClass_1
    extends CameraCaptureSession.CaptureCallback {
        NamelessClass_1() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void process(CaptureResult result) {
            switch (ARBufferedCamera2.this.mState) {
                default: {
                    return;
                }
                case 1: {
                    Integer var3;
                    Integer var2 = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
                    if (var2 != null && (4 == var2 || 5 == var2) && (var3 = (Integer)result.get(CaptureResult.CONTROL_AE_STATE)) != null && var3 != 2) return;
                }
                case 2: {
                    Integer var2 = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (var2 != null && var2 != 5 && var2 != 4) return;
                    ARBufferedCamera2.this.mState = 3;
                    return;
                }
                case 3: {
                    Integer var2 = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (var2 != null && var2 == 5) return;
                }
            }
        }

        public void onCaptureProgressed(CameraCaptureSession session, CaptureRequest request, CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }
    }

    class NamelessClass_2
    extends CameraDevice.StateCallback {
        NamelessClass_2() {
        }

        public void onOpened(CameraDevice cameraDevice) {
            ARBufferedCamera2.this.mCameraDevice = cameraDevice;
            ARBufferedCamera2.this.createCameraPreviewSession();
            ARBufferedCamera2.this.mCameraOpenCloseLock.release();
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            cameraDevice.close();
            ARBufferedCamera2.this.mCameraDevice = null;
            ARBufferedCamera2.this.mCameraOpenCloseLock.release();
        }

        public void onError(CameraDevice cameraDevice, int error) {
            cameraDevice.close();
            ARBufferedCamera2.this.mCameraDevice = null;
            ARBufferedCamera2.this.mCameraOpenCloseLock.release();
        }
    }

    class NamelessClass_3
    implements ImageReader.OnImageAvailableListener {
        NamelessClass_3() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onImageAvailable(ImageReader reader) {
            try (Image var2 = null;){
                var2 = reader.acquireLatestImage();
                if (var2 == null) return;
                if (var2.getFormat() == 35 && var2.getPlanes().length == 3) {
                    if (reader.getWidth() != var2.getWidth() || reader.getHeight() != var2.getHeight()) throw new IllegalStateException("ImageReader size " + reader.getWidth() + "x" + reader.getHeight() + " did not match Image size: " + var2.getWidth() + "x" + var2.getHeight());
                    ARBufferedCamera2.readImageIntoBuffer(var2, ARBufferedCamera2.this.mBufferArrayData);
                    int var3 = ARBufferedCamera2.this.getFrameOrientation();
                    if (ARBufferedCamera2.this.consumer != null && ((ARBufferedCamera2)ARBufferedCamera2.this).mParameters.bufferType == MediaIO.BufferType.BYTE_ARRAY.intValue()) {
                        ARBufferedCamera2.this.consumer.consumeByteArrayFrame(ARBufferedCamera2.this.mBufferArrayData, ((ARBufferedCamera2)ARBufferedCamera2.this).mParameters.pixelFormat, var2.getWidth(), var2.getHeight(), var3, System.currentTimeMillis());
                        return;
                    } else {
                        if (ARBufferedCamera2.this.consumer == null || ((ARBufferedCamera2)ARBufferedCamera2.this).mParameters.bufferType != MediaIO.BufferType.BYTE_BUFFER.intValue()) return;
                        ARBufferedCamera2.this.mByteBufferData.rewind();
                        ARBufferedCamera2.this.mByteBufferData.put(ARBufferedCamera2.this.mBufferArrayData, 0, ARBufferedCamera2.this.mBufferArrayData.length);
                        if (ARBufferedCamera2.this.bitmapListener == null) return;
                        ARBufferedCamera2.this.bitmapListener.onBitmap(ARBufferedCamera2.this.mByteBufferData, ((ARBufferedCamera2)ARBufferedCamera2.this).mParameters.pixelFormat, var2.getWidth(), var2.getHeight(), var3, System.currentTimeMillis());
                    }
                    return;
                } else {
                    Logging.e(TAG, "Unexpected image format: " + var2.getFormat() + "or #planes:" + var2.getPlanes().length);
                }
                return;
            }
        }
    }

    public static interface onBitmapListener {
        public void onBitmap(ByteBuffer var1, int var2, int var3, int var4, int var5, long var6);
    }
}

