/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.mediaio;

import android.annotation.TargetApi;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import java.util.concurrent.Callable;
import org.ar.rtc.gl.AREglBase;
import org.ar.rtc.gl.ARGlUtil;
import org.ar.rtc.gl.ARTextureBufferImpl;
import org.ar.rtc.gl.ARYuvConverter;
import org.ar.rtc.gl.VideoFrame;
import org.ar.rtc.utils.ThreadUtils;

public class ARSurfaceTextureHelper {
    private static final String TAG = "SurfaceTextureHelper";
    private final Handler handler;
    private final AREglBase eglBase;
    private final SurfaceTexture surfaceTexture;
    private final int oesTextureId;
    private ARYuvConverter ARYuvConverter;
    private OnTextureFrameAvailableListener listener;
    private boolean hasPendingTexture = false;
    private volatile boolean isTextureInUse = false;
    private boolean isQuitting = false;
    private OnTextureFrameAvailableListener pendingListener;
    final Runnable setListenerRunnable = new Runnable(){

        @Override
        public void run() {
            Log.d((String)ARSurfaceTextureHelper.TAG, (String)("Setting listener to " + ARSurfaceTextureHelper.this.pendingListener));
            ARSurfaceTextureHelper.this.listener = ARSurfaceTextureHelper.this.pendingListener;
            ARSurfaceTextureHelper.this.pendingListener = null;
            if (ARSurfaceTextureHelper.this.hasPendingTexture) {
                ARSurfaceTextureHelper.this.updateTexImage();
                ARSurfaceTextureHelper.this.hasPendingTexture = false;
            }
        }
    };

    public static ARSurfaceTextureHelper create(final String var0, final AREglBase.Context var1) {
        HandlerThread var2 = new HandlerThread(var0);
        var2.start();
        final Handler var3 = new Handler(var2.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly(var3, new Callable<ARSurfaceTextureHelper>(){

            @Override
            public ARSurfaceTextureHelper call() {
                try {
                    return new ARSurfaceTextureHelper(var1, var3);
                }
                catch (RuntimeException var2) {
                    Log.e((String)ARSurfaceTextureHelper.TAG, (String)(var0 + " create failure"), (Throwable)var2);
                    return null;
                }
            }
        });
    }

    private ARSurfaceTextureHelper(AREglBase.Context var1, Handler var2) {
        if (var2.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
        }
        this.handler = var2;
        this.eglBase = AREglBase.create(var1, AREglBase.CONFIG_PIXEL_BUFFER);
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException var4) {
            Log.e((String)TAG, (String)"SurfaceTextureHelper: failed to create pbufferSurface!!");
            this.eglBase.release();
            var2.getLooper().quit();
            throw var4;
        }
        this.oesTextureId = ARGlUtil.generateTexture(36197);
        this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
        ARSurfaceTextureHelper.setOnFrameAvailableListener(this.surfaceTexture, new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture var1) {
                ARSurfaceTextureHelper.this.hasPendingTexture = true;
                ARSurfaceTextureHelper.this.tryDeliverTextureFrame();
            }
        }, var2);
    }

    @TargetApi(value=21)
    private static void setOnFrameAvailableListener(SurfaceTexture var0, SurfaceTexture.OnFrameAvailableListener var1, Handler var2) {
        if (Build.VERSION.SDK_INT >= 21) {
            var0.setOnFrameAvailableListener(var1, var2);
        } else {
            var0.setOnFrameAvailableListener(var1);
        }
    }

    public AREglBase.Context getEglContext() {
        return this.eglBase.getEglBaseContext();
    }

    public void startListening(OnTextureFrameAvailableListener var1) {
        if (this.listener != null || this.pendingListener != null) {
            throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
        }
        this.pendingListener = var1;
        this.handler.post(this.setListenerRunnable);
    }

    public void stopListening() {
        Log.d((String)TAG, (String)"stopListening()");
        this.handler.removeCallbacks(this.setListenerRunnable);
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                ARSurfaceTextureHelper.this.listener = null;
                ARSurfaceTextureHelper.this.pendingListener = null;
            }
        });
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void returnTextureFrame() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                ARSurfaceTextureHelper.this.isTextureInUse = false;
                if (ARSurfaceTextureHelper.this.isQuitting) {
                    ARSurfaceTextureHelper.this.release();
                } else {
                    ARSurfaceTextureHelper.this.tryDeliverTextureFrame();
                }
            }
        });
    }

    public boolean isTextureInUse() {
        return this.isTextureInUse;
    }

    public void dispose() {
        Log.d((String)TAG, (String)"dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                ARSurfaceTextureHelper.this.isQuitting = true;
                if (!ARSurfaceTextureHelper.this.isTextureInUse) {
                    ARSurfaceTextureHelper.this.release();
                }
            }
        });
    }

    public VideoFrame.I420Buffer textureToYuv(final VideoFrame.TextureBuffer var1) {
        if (var1.getTextureId() != this.oesTextureId) {
            throw new IllegalStateException("textureToByteBuffer called with unexpected textureId");
        }
        final VideoFrame.I420Buffer[] var2 = new VideoFrame.I420Buffer[1];
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                if (ARSurfaceTextureHelper.this.ARYuvConverter == null) {
                    ARSurfaceTextureHelper.this.ARYuvConverter = new ARYuvConverter();
                }
                var2[0] = ARSurfaceTextureHelper.this.ARYuvConverter.convert(var1);
            }
        });
        return var2[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTexImage() {
        try {
            Object object = AREglBase.lock;
            synchronized (object) {
                this.surfaceTexture.updateTexImage();
            }
        }
        catch (IllegalStateException var4) {
            Log.e((String)TAG, (String)"SurfaceTextureHelper: failed to updateTexImage!!");
        }
    }

    private void tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (!this.isQuitting && this.hasPendingTexture && !this.isTextureInUse && this.listener != null) {
            this.isTextureInUse = true;
            this.hasPendingTexture = false;
            this.updateTexImage();
            float[] var1 = new float[16];
            this.surfaceTexture.getTransformMatrix(var1);
            long var2 = this.surfaceTexture.getTimestamp();
            this.listener.onTextureFrameAvailable(this.oesTextureId, var1, var2);
        }
    }

    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (!this.isTextureInUse && this.isQuitting) {
            if (this.ARYuvConverter != null) {
                this.ARYuvConverter.release();
            }
        } else {
            throw new IllegalStateException("Unexpected release.");
        }
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.oesTextureId}, (int)0);
        this.surfaceTexture.release();
        this.eglBase.release();
        this.handler.getLooper().quit();
    }

    public VideoFrame.TextureBuffer createTextureBuffer(int var1, int var2, Matrix var3) {
        return new ARTextureBufferImpl(var1, var2, VideoFrame.TextureBuffer.Type.OES, this.oesTextureId, var3, this, new Runnable(){

            @Override
            public void run() {
                ARSurfaceTextureHelper.this.returnTextureFrame();
            }
        });
    }

    public static interface OnTextureFrameAvailableListener {
        public void onTextureFrameAvailable(int var1, float[] var2, long var3);
    }
}

