/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.mediaio;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.Log;
import android.view.TextureView;
import java.nio.ByteBuffer;
import org.ar.rtc.gl.AREglBase;
import org.ar.rtc.gl.ARRendererCommon;
import org.ar.rtc.mediaio.BaseVideoRenderer;
import org.ar.rtc.mediaio.IVideoSink;
import org.ar.rtc.mediaio.MediaIO;
import org.ar.rtc.utils.ThreadUtils;

public class ARTextureView
extends TextureView
implements IVideoSink,
TextureView.SurfaceTextureListener {
    private static final String TAG = TextureView.class.getSimpleName();
    private BaseVideoRenderer mRender = new BaseVideoRenderer(TAG);
    private AREglBase.Context mEglContext;
    private int[] mConfigAttributes;
    private ARRendererCommon.GlDrawer mDrawer;

    public ARTextureView(Context var1) {
        super(var1);
        this.mRender.setRenderView(this, this);
    }

    public ARTextureView(Context var1, AttributeSet var2) {
        super(var1, var2);
        this.mRender.setRenderView(this, this);
    }

    public void init(AREglBase.Context var1) {
        this.mEglContext = var1;
    }

    public void init(AREglBase.Context var1, int[] var2, ARRendererCommon.GlDrawer var3) {
        this.mEglContext = var1;
        this.mConfigAttributes = var2;
        this.mDrawer = var3;
    }

    @Override
    public long getEGLContextHandle() {
        return this.mRender.getEGLContextHandle();
    }

    public void setBufferType(MediaIO.BufferType var1) {
        this.mRender.setBufferType(var1);
    }

    public void setPixelFormat(MediaIO.PixelFormat var1) {
        this.mRender.setPixelFormat(var1);
    }

    public void setMirror(boolean var1) {
        this.mRender.getEglRender().setMirror(var1);
    }

    @Override
    public boolean onInitialize() {
        if (this.mConfigAttributes != null && this.mDrawer != null) {
            this.mRender.init(this.mEglContext, this.mConfigAttributes, this.mDrawer);
        } else {
            this.mRender.init(this.mEglContext);
        }
        return true;
    }

    @Override
    public boolean onStart() {
        return this.mRender.start();
    }

    @Override
    public void onStop() {
        this.mRender.stop();
    }

    @Override
    public void onDispose() {
        this.mRender.release();
    }

    @Override
    public void consumeTextureFrame(int var1, int var2, int var3, int var4, int var5, long var6, float[] var8) {
        this.mRender.consume(var1, var2, var3, var4, var5, var6, var8);
    }

    @Override
    public void consumeByteBufferFrame(ByteBuffer var1, int var2, int var3, int var4, int var5, long var6) {
        this.mRender.consume(var1, var2, var3, var4, var5, var6);
    }

    @Override
    public void consumeByteArrayFrame(byte[] var1, int var2, int var3, int var4, int var5, long var6) {
        this.mRender.consume(var1, var2, var3, var4, var5, var6);
    }

    @Override
    public int getBufferType() {
        int var1 = this.mRender.getBufferType();
        if (var1 == -1) {
            throw new IllegalArgumentException("Buffer type is not set");
        }
        return var1;
    }

    @Override
    public int getPixelFormat() {
        int var1 = this.mRender.getPixelFormat();
        if (var1 == -1) {
            throw new IllegalArgumentException("Pixel format is not set");
        }
        return var1;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture var1, int var2, int var3) {
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture var1, int var2, int var3) {
        Log.e((String)TAG, (String)("onSurfaceTextureSizeChanged: width- " + var2 + ", height: " + var3));
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture var1) {
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture var1) {
    }

    protected void onLayout(boolean var1, int var2, int var3, int var4, int var5) {
        ThreadUtils.checkIsOnMainThread();
        this.mRender.getEglRender().setLayoutAspectRatio((float)(var4 - var2) / (float)(var5 - var3));
    }
}

