/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.mediaio;

import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import org.ar.rtc.gl.AREglBase;
import org.ar.rtc.gl.AREglRenderer;
import org.ar.rtc.gl.ARGlRectDrawer;
import org.ar.rtc.gl.ARJavaI420Buffer;
import org.ar.rtc.gl.ARRendererCommon;
import org.ar.rtc.gl.ARRgbaBuffer;
import org.ar.rtc.gl.ARTextureBufferImpl;
import org.ar.rtc.gl.VideoFrame;
import org.ar.rtc.mediaio.MediaIO;
import org.ar.rtc.utils.ThreadUtils;

public class BaseVideoRenderer
implements SurfaceHolder.Callback,
TextureView.SurfaceTextureListener {
    private static final String TAG = BaseVideoRenderer.class.getSimpleName();
    private static final String ERROR_EGL = "Only one egl surface allowed";
    private final AREglRenderer AREglRenderer;
    private int mBufferType = -1;
    private int mPixelFormat = -1;
    private SurfaceView mSurfaceView;
    private TextureView mTextureView;
    private Surface mSurface;
    private SurfaceTexture mSurfaceTexture;
    private SurfaceHolder.Callback mSurfaceViewListener;
    private TextureView.SurfaceTextureListener mSurfaceTextureListener;
    private boolean mHasEglSurface = false;
    private boolean mStarted = false;

    public BaseVideoRenderer(String var1) {
        this.AREglRenderer = new AREglRenderer(var1);
    }

    public AREglRenderer getEglRender() {
        return this.AREglRenderer;
    }

    public long getEGLContextHandle() {
        return this.AREglRenderer.getEglContext().getNativeEglContext();
    }

    public void init(AREglBase.Context var1) {
        this.init(var1, AREglBase.CONFIG_PLAIN, new ARGlRectDrawer());
    }

    public void init(AREglBase.Context var1, int[] var2, ARRendererCommon.GlDrawer var3) {
        this.AREglRenderer.init(var1, var2, var3);
    }

    public void setRenderView(SurfaceView var1, SurfaceHolder.Callback var2) {
        ThreadUtils.checkIsOnMainThread();
        if (this.mHasEglSurface) {
            throw new IllegalStateException(ERROR_EGL);
        }
        this.mSurfaceView = var1;
        this.mSurfaceViewListener = var2;
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public void setRenderView(TextureView var1, TextureView.SurfaceTextureListener var2) {
        ThreadUtils.checkIsOnMainThread();
        if (this.mHasEglSurface) {
            throw new IllegalStateException(ERROR_EGL);
        }
        this.mTextureView = var1;
        this.mSurfaceTextureListener = var2;
        this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
    }

    public void setRenderSurface(Surface var1) {
        ThreadUtils.checkIsOnMainThread();
        if (this.mHasEglSurface) {
            throw new IllegalStateException(ERROR_EGL);
        }
        this.mSurface = var1;
        this.AREglRenderer.createEglSurface(var1);
        this.mHasEglSurface = true;
    }

    public void setRenderSurface(SurfaceTexture var1) {
        ThreadUtils.checkIsOnMainThread();
        if (this.mHasEglSurface) {
            throw new IllegalStateException(ERROR_EGL);
        }
        this.mSurfaceTexture = var1;
        this.AREglRenderer.createEglSurface(var1);
        this.mHasEglSurface = true;
    }

    public void setBufferType(MediaIO.BufferType var1) {
        this.mBufferType = var1.intValue();
    }

    public void setPixelFormat(MediaIO.PixelFormat var1) {
        this.mPixelFormat = var1.intValue();
    }

    public void release() {
        this.AREglRenderer.release();
    }

    public boolean start() {
        this.mStarted = true;
        return true;
    }

    public void stop() {
        this.mStarted = false;
    }

    public void consume(int var1, int var2, int var3, int var4, int var5, long var6, float[] var8) {
        if (this.mStarted) {
            VideoFrame.TextureBuffer.Type var9;
            if (var2 == 11) {
                var9 = VideoFrame.TextureBuffer.Type.OES;
            } else {
                if (var2 != 10) {
                    return;
                }
                var9 = VideoFrame.TextureBuffer.Type.RGB;
            }
            this.rendTextureFrame(var1, var9, var3, var4, var5, var6, var8);
        }
    }

    public void consume(ByteBuffer var1, int var2, int var3, int var4, int var5, long var6) {
        if (this.mStarted) {
            if (var2 == 1) {
                this.rendI420Frame(var1, var2, var3, var4, var5, var6);
            } else if (var2 == 4) {
                this.rendRGBAFrame(var1, var2, var3, var4, var5, var6);
            }
        }
    }

    public void consume(byte[] var1, int var2, int var3, int var4, int var5, long var6) {
        if (this.mStarted) {
            if (var2 == 1) {
                this.rendI420Frame(var1, var2, var3, var4, var5, var6);
            } else if (var2 == 4) {
                this.rendRGBAFrame(var1, var2, var3, var4, var5, var6);
            }
        }
    }

    public int getBufferType() {
        if (this.mBufferType == -1) {
            throw new IllegalArgumentException("Buffer type is not set");
        }
        return this.mBufferType;
    }

    public int getPixelFormat() {
        if (this.mPixelFormat == -1) {
            throw new IllegalArgumentException("Pixel format is not set");
        }
        return this.mPixelFormat;
    }

    private void rendTextureFrame(int var1, VideoFrame.TextureBuffer.Type var2, int var3, int var4, int var5, long var6, float[] var8) {
        Matrix var9 = ARRendererCommon.convertMatrixToAndroidGraphicsMatrix(var8);
        ARTextureBufferImpl var10 = new ARTextureBufferImpl(var3, var4, var2, var1, var9, null, new Runnable(){

            @Override
            public void run() {
            }
        });
        VideoFrame var11 = new VideoFrame(var10, var5, var6);
        this.AREglRenderer.renderFrame(var11);
        var11.release();
    }

    private void rendI420Frame(ByteBuffer var1, int var2, int var3, int var4, int var5, long var6) {
        if (var1 != null) {
            byte[] var8 = new byte[var1.remaining()];
            var1.get(var8, 0, var8.length);
            ARJavaI420Buffer var9 = ARJavaI420Buffer.createYUV(var8, var3, var4);
            if (var9 != null) {
                VideoFrame var10 = new VideoFrame(var9, var5, var6);
                this.AREglRenderer.renderFrame(var10);
                var10.release();
            }
        }
    }

    private void rendI420Frame(byte[] var1, int var2, int var3, int var4, int var5, long var6) {
        ARJavaI420Buffer var8;
        if (var1 != null && var1.length != 0 && (var8 = ARJavaI420Buffer.createYUV(var1, var3, var4)) != null) {
            VideoFrame var9 = new VideoFrame(var8, var5, var6);
            this.AREglRenderer.renderFrame(var9);
            var9.release();
        }
    }

    private void rendRGBAFrame(final ByteBuffer var1, int var2, int var3, int var4, int var5, long var6) {
        if (var1 != null) {
            ARRgbaBuffer var8 = new ARRgbaBuffer(var1, var3, var4, new Runnable(){

                @Override
                public void run() {
                    BaseVideoRenderer.this.releaseBuffer(var1);
                }
            });
            VideoFrame var9 = new VideoFrame(var8, var5, var6);
            this.AREglRenderer.renderFrame(var9);
            var9.release();
        }
    }

    private void rendRGBAFrame(byte[] var1, int var2, int var3, int var4, int var5, long var6) {
        if (var1 != null && var1.length != 0) {
            final ByteBuffer var8 = ByteBuffer.wrap(var1);
            ARRgbaBuffer var9 = new ARRgbaBuffer(var8, var3, var4, new Runnable(){

                @Override
                public void run() {
                    BaseVideoRenderer.this.releaseBuffer(var8);
                }
            });
            VideoFrame var10 = new VideoFrame(var9, var5, var6);
            this.AREglRenderer.renderFrame(var10);
            var10.release();
        }
    }

    public void surfaceCreated(SurfaceHolder var1) {
        ThreadUtils.checkIsOnMainThread();
        this.AREglRenderer.createEglSurface(var1.getSurface());
        this.mHasEglSurface = true;
        if (this.mSurfaceViewListener != null) {
            this.mSurfaceViewListener.surfaceCreated(var1);
        }
    }

    public void surfaceChanged(SurfaceHolder var1, int var2, int var3, int var4) {
        ThreadUtils.checkIsOnMainThread();
        Log.e((String)TAG, (String)("surfaceChanged: format: " + var2 + " size: " + var3 + "x" + var4));
        if (this.mSurfaceViewListener != null) {
            this.mSurfaceViewListener.surfaceChanged(var1, var2, var3, var4);
        }
    }

    public void surfaceDestroyed(SurfaceHolder var1) {
        ThreadUtils.checkIsOnMainThread();
        final CountDownLatch var2 = new CountDownLatch(1);
        this.AREglRenderer.releaseEglSurface(new Runnable(){

            @Override
            public void run() {
                var2.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(var2);
        if (this.mSurfaceViewListener != null) {
            this.mSurfaceViewListener.surfaceDestroyed(var1);
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture var1, int var2, int var3) {
        ThreadUtils.checkIsOnMainThread();
        this.AREglRenderer.createEglSurface(var1);
        this.mHasEglSurface = true;
        if (this.mSurfaceTextureListener != null) {
            this.mSurfaceTextureListener.onSurfaceTextureAvailable(var1, var2, var3);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture var1, int var2, int var3) {
        Log.e((String)TAG, (String)("onSurfaceTextureSizeChanged: width- " + var2 + ", height: " + var3));
        if (this.mSurfaceTextureListener != null) {
            this.mSurfaceTextureListener.onSurfaceTextureSizeChanged(var1, var2, var3);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture var1) {
        ThreadUtils.checkIsOnMainThread();
        final CountDownLatch var2 = new CountDownLatch(1);
        this.AREglRenderer.releaseEglSurface(new Runnable(){

            @Override
            public void run() {
                var2.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(var2);
        if (this.mSurfaceTextureListener != null) {
            this.mSurfaceTextureListener.onSurfaceTextureDestroyed(var1);
        }
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture var1) {
        if (this.mSurfaceTextureListener != null) {
            this.mSurfaceTextureListener.onSurfaceTextureUpdated(var1);
        }
    }

    private void releaseBuffer(ByteBuffer var1) {
        var1 = null;
    }
}

