/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.mediaplayer;

import android.text.TextUtils;
import android.view.TextureView;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import org.ar.rtc.mediaplayer.IMediaPlayerKit;
import org.ar.rtc.mediaplayer.MediaPlayerObserver;
import org.ar.rtc.mediaplayer.PlayerConstans;
import org.webrtc.RendererCommon;
import org.webrtc.TextureViewRenderer;
import org.webrtc.VideoRenderer;

public class ARMediaPlayer
implements IMediaPlayerKit {
    private static final String TAG = ARMediaPlayer.class.getSimpleName() + "[player]";
    private List<MediaPlayerObserver> mPlayerObservers;
    private View renderView = null;
    public long mNativetestrId = this.nativeInitialize(new PlayerStateListener());

    public ARMediaPlayer() {
        this.mPlayerObservers = new ArrayList<MediaPlayerObserver>();
    }

    @Override
    public int open(String var1, long var2) {
        if (!TextUtils.isEmpty((CharSequence)var1) && var2 >= 0L) {
            return this.nativeOpen(this.mNativetestrId, var1, var2);
        }
        return -1;
    }

    @Override
    public int setView(TextureView var1) {
        this.renderView = var1;
        VideoRenderer videoRenderer = new VideoRenderer((TextureViewRenderer)var1);
        return this.nativeSetview(this.mNativetestrId, videoRenderer.GetRenderPointer());
    }

    @Override
    public int play() {
        return this.nativePlay(this.mNativetestrId);
    }

    @Override
    public int setRenderMode(int var1) {
        if (this.renderView != null) {
            ((TextureViewRenderer)this.renderView).setScalingType(var1 == 1 ? RendererCommon.ScalingType.SCALE_ASPECT_FILL : RendererCommon.ScalingType.SCALE_ASPECT_FIT);
            return 0;
        }
        return -1;
    }

    @Override
    public int pause() {
        return this.nativePause(this.mNativetestrId);
    }

    @Override
    public int stop() {
        int var1 = this.nativeStop(this.mNativetestrId);
        return var1;
    }

    @Override
    public int seek(long var1) {
        return this.nativeSeek(this.mNativetestrId, var1);
    }

    @Override
    public int mute(boolean var1) {
        return this.nativeMute(this.mNativetestrId, var1);
    }

    @Override
    public boolean isMuted() {
        return this.nativeIsmuted(this.mNativetestrId);
    }

    @Override
    public int adjustPlayoutVolume(int var1) {
        return this.nativeAdjustPlayoutVolume(this.mNativetestrId, var1);
    }

    @Override
    public int getPlayoutVolume() {
        return this.nativeGetPlayoutVolume(this.mNativetestrId);
    }

    @Override
    public long getPlayPosition() {
        return this.nativeGetPlayPosition(this.mNativetestrId);
    }

    @Override
    public long getDuration() {
        return this.nativeGetDuration(this.mNativetestrId);
    }

    @Override
    public int getState() {
        return this.nativeGetState(this.mNativetestrId);
    }

    @Override
    public int getStreamCount() {
        return this.nativeGetStreamCount(this.mNativetestrId);
    }

    @Override
    public int getStreamByIndex() {
        return 0;
    }

    @Override
    public int destroy() {
        this.renderView = null;
        this.mPlayerObservers.clear();
        this.nativeDestory(this.mNativetestrId);
        return 0;
    }

    @Override
    public int registerPlayerObserver(MediaPlayerObserver var1) {
        if (!this.mPlayerObservers.contains(var1)) {
            this.mPlayerObservers.add(var1);
        }
        return 0;
    }

    @Override
    public int unRegisterPlayerObserver(MediaPlayerObserver var1) {
        if (this.mPlayerObservers.contains(var1)) {
            this.mPlayerObservers.remove(var1);
        }
        return 0;
    }

    private native long nativeInitialize(Object var1);

    private native int nativeOpen(long var1, String var3, long var4);

    private native int nativePlay(long var1);

    private native int nativePause(long var1);

    private native int nativeStop(long var1);

    private native int nativeSeek(long var1, long var3);

    private native int nativeMute(long var1, boolean var3);

    private native boolean nativeIsmuted(long var1);

    private native int nativeAdjustPlayoutVolume(long var1, int var3);

    private native int nativeGetPlayoutVolume(long var1);

    private native int nativeGetPlayPosition(long var1);

    private native int nativeGetDuration(long var1);

    private native int nativeGetState(long var1);

    private native int nativeGetStreamCount(long var1);

    private native int nativeSetview(long var1, long var3);

    private native int nativeDestory(long var1);

    private static interface IMediaPlayerObserver {
        public void onPlayerStateChanged(int var1, int var2);

        public void onPositionChanged(long var1);

        public void onPlayerEvent(int var1);

        public void onMetaData(int var1, byte[] var2);
    }

    private class PlayerStateListener
    implements IMediaPlayerObserver {
        private PlayerStateListener() {
        }

        @Override
        public void onPlayerStateChanged(int var1, int var2) {
            for (MediaPlayerObserver event : ARMediaPlayer.this.mPlayerObservers) {
                event.onPlayerStateChanged(PlayerConstans.MediaPlayerState.getState(var1), PlayerConstans.MediaPlayerError.getState(var2));
            }
        }

        @Override
        public void onPositionChanged(long var1) {
            for (MediaPlayerObserver event : ARMediaPlayer.this.mPlayerObservers) {
                event.onPositionChanged(var1);
            }
        }

        @Override
        public void onPlayerEvent(int var1) {
            for (MediaPlayerObserver event : ARMediaPlayer.this.mPlayerObservers) {
                event.onPlayerEvent(PlayerConstans.MediaPlayerEvent.getState(var1));
            }
        }

        @Override
        public void onMetaData(int var1, byte[] var2) {
            for (MediaPlayerObserver event : ARMediaPlayer.this.mPlayerObservers) {
                event.onMetaData(PlayerConstans.MediaPlayerMetadataType.getState(var1), var2);
            }
        }
    }
}

