/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.net;

import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.text.format.Formatter;
import androidx.annotation.RequiresPermission;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.ar.rtc.net.Utils;

public final class ARNetUtil {
    private ARNetUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void openWirelessSettings() {
        Utils.getApp().startActivity(new Intent("android.settings.WIRELESS_SETTINGS").setFlags(0x10000000));
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isConnected() {
        NetworkInfo info = ARNetUtil.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static void isAvailableByDns(String ip) {
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public static void setMobileDataEnabled(boolean enabled) {
        try {
            TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
            if (tm == null) {
                return;
            }
            Method setMobileDataEnabledMethod = tm.getClass().getDeclaredMethod("setDataEnabled", Boolean.TYPE);
            if (null != setMobileDataEnabledMethod) {
                setMobileDataEnabledMethod.invoke((Object)tm, enabled);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isMobileData() {
        NetworkInfo info = ARNetUtil.getActiveNetworkInfo();
        return null != info && info.isAvailable() && info.getType() == 0;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean is4G() {
        NetworkInfo info = ARNetUtil.getActiveNetworkInfo();
        return info != null && info.isAvailable() && info.getSubtype() == 13;
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static boolean getWifiEnabled() {
        WifiManager manager = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (manager == null) {
            return false;
        }
        return manager.isWifiEnabled();
    }

    @RequiresPermission(value="android.permission.CHANGE_WIFI_STATE")
    public static void setWifiEnabled(boolean enabled) {
        WifiManager manager = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (manager == null) {
            return;
        }
        if (enabled == manager.isWifiEnabled()) {
            return;
        }
        manager.setWifiEnabled(enabled);
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isWifiConnected() {
        ConnectivityManager cm = (ConnectivityManager)Utils.getApp().getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo ni = cm.getActiveNetworkInfo();
        return ni != null && ni.getType() == 1;
    }

    public static String getNetworkOperatorName() {
        TelephonyManager tm = (TelephonyManager)Utils.getApp().getSystemService("phone");
        if (tm == null) {
            return "";
        }
        return tm.getNetworkOperatorName();
    }

    public static NetworkType getNetworkType() {
        NetworkType netType = NetworkType.NETWORK_NO;
        NetworkInfo info = ARNetUtil.getActiveNetworkInfo();
        if (info != null && info.isAvailable()) {
            if (info.getType() == 9) {
                netType = NetworkType.NETWORK_ETHERNET;
            } else if (info.getType() == 1) {
                netType = NetworkType.NETWORK_WIFI;
            } else if (info.getType() == 0) {
                switch (info.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        netType = NetworkType.NETWORK_2G;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        netType = NetworkType.NETWORK_3G;
                        break;
                    }
                    case 13: 
                    case 18: {
                        netType = NetworkType.NETWORK_4G;
                        break;
                    }
                    default: {
                        String subtypeName = info.getSubtypeName();
                        if (subtypeName.equalsIgnoreCase("TD-SCDMA") || subtypeName.equalsIgnoreCase("WCDMA") || subtypeName.equalsIgnoreCase("CDMA2000")) {
                            netType = NetworkType.NETWORK_3G;
                            break;
                        }
                        netType = NetworkType.NETWORK_UNKNOWN;
                        break;
                    }
                }
            } else {
                netType = NetworkType.NETWORK_UNKNOWN;
            }
        }
        return netType;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private static NetworkInfo getActiveNetworkInfo() {
        ConnectivityManager cm = (ConnectivityManager)Utils.getApp().getSystemService("connectivity");
        if (cm == null) {
            return null;
        }
        return cm.getActiveNetworkInfo();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static String getIPAddress(boolean useIPv4) {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            LinkedList<InetAddress> adds = new LinkedList<InetAddress>();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    adds.addFirst(addresses.nextElement());
                }
            }
            for (InetAddress add : adds) {
                boolean isIPv4;
                if (add.isLoopbackAddress()) continue;
                String hostAddress = add.getHostAddress();
                boolean bl = isIPv4 = hostAddress.indexOf(58) < 0;
                if (useIPv4) {
                    if (!isIPv4) continue;
                    return hostAddress;
                }
                if (isIPv4) continue;
                int index = hostAddress.indexOf(37);
                return index < 0 ? hostAddress.toUpperCase() : hostAddress.substring(0, index).toUpperCase();
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getBroadcastIpAddress() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            LinkedList adds = new LinkedList();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> ias = ni.getInterfaceAddresses();
                for (int i = 0; i < ias.size(); ++i) {
                    InterfaceAddress ia = ias.get(i);
                    InetAddress broadcast = ia.getBroadcast();
                    if (broadcast == null) continue;
                    return broadcast.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return "";
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static String getDomainAddress(String domain) {
        try {
            InetAddress inetAddress = InetAddress.getByName(domain);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "";
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getIpAddressByWifi() {
        WifiManager wm = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().ipAddress);
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getGatewayByWifi() {
        WifiManager wm = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().gateway);
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getNetMaskByWifi() {
        WifiManager wm = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().netmask);
    }

    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    public static String getServerAddressByWifi() {
        WifiManager wm = (WifiManager)Utils.getApp().getSystemService("wifi");
        if (wm == null) {
            return "";
        }
        return Formatter.formatIpAddress((int)wm.getDhcpInfo().serverAddress);
    }

    public static interface Callback {
        public void call(boolean var1);
    }

    public static enum NetworkType {
        NETWORK_UNKNOWN(-1),
        NETWORK_NO(0),
        NETWORK_ETHERNET(1),
        NETWORK_WIFI(2),
        NETWORK_2G(3),
        NETWORK_3G(4),
        NETWORK_4G(5);

        public final int type;

        private NetworkType(int type) {
            this.type = type;
        }
    }
}

