/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.utils;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    public static void checkIsOnMainThread() {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new IllegalStateException("Not on main thread!");
        }
    }

    public static void executeUninterruptibly(BlockingOperation var0) {
        boolean var1 = false;
        while (true) {
            try {
                var0.run();
            }
            catch (InterruptedException var3) {
                var1 = true;
                continue;
            }
            break;
        }
        if (var1) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean joinUninterruptibly(Thread var0, long var1) {
        long var3 = SystemClock.elapsedRealtime();
        long var5 = var1;
        boolean var7 = false;
        while (var5 > 0L) {
            try {
                var0.join(var5);
                break;
            }
            catch (InterruptedException var11) {
                var7 = true;
                long var9 = SystemClock.elapsedRealtime() - var3;
                var5 = var1 - var9;
            }
        }
        if (var7) {
            Thread.currentThread().interrupt();
        }
        return !var0.isAlive();
    }

    public static void joinUninterruptibly(final Thread var0) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() throws InterruptedException {
                var0.join();
            }
        });
    }

    public static void awaitUninterruptibly(final CountDownLatch var0) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() throws InterruptedException {
                var0.await();
            }
        });
    }

    public static boolean awaitUninterruptibly(CountDownLatch var0, long var1) {
        long var3 = SystemClock.elapsedRealtime();
        long var5 = var1;
        boolean var7 = false;
        boolean var8 = false;
        while (true) {
            try {
                var8 = var0.await(var5, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException var12) {
                long var10;
                var7 = true;
                if ((var5 = var1 - (var10 = SystemClock.elapsedRealtime() - var3)) > 0L) continue;
            }
            break;
        }
        if (var7) {
            Thread.currentThread().interrupt();
        }
        return var8;
    }

    public static void waitUninterruptibly(final Object var0) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() throws InterruptedException {
                var0.wait();
            }
        });
    }

    public static <V> V invokeAtFrontUninterruptibly(Handler var0, final Callable<V> var1) {
        if (var0.getLooper().getThread() == Thread.currentThread()) {
            try {
                return var1.call();
            }
            catch (Exception var6) {
                throw new RuntimeException(var6);
            }
        }
        class Result {
            public V value;

            Result() {
            }
        }
        final Result var2 = new Result();
        class CaughtException {
            Exception e;

            CaughtException() {
            }
        }
        final CaughtException var3 = new CaughtException();
        final CountDownLatch var4 = new CountDownLatch(1);
        var0.post(new Runnable(){
            {
            }

            @Override
            public void run() {
                try {
                    var2.value = var1.call();
                }
                catch (Exception var2x) {
                    var3.e = var2x;
                }
                var4.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(var4);
        if (var3.e != null) {
            RuntimeException var5 = new RuntimeException(var3.e);
            var5.setStackTrace(ThreadUtils.concatStackTraces(var3.e.getStackTrace(), var5.getStackTrace()));
            throw var5;
        }
        return var2.value;
    }

    public static void invokeAtFrontUninterruptibly(Handler var0, final Runnable var1) {
        ThreadUtils.invokeAtFrontUninterruptibly(var0, new Callable<Void>(){

            @Override
            public Void call() {
                var1.run();
                return null;
            }
        });
    }

    public static StackTraceElement[] concatStackTraces(StackTraceElement[] var0, StackTraceElement[] var1) {
        StackTraceElement[] var2 = new StackTraceElement[var0.length + var1.length];
        System.arraycopy(var0, 0, var2, 0, var0.length);
        System.arraycopy(var1, 0, var2, var0.length, var1.length);
        return var2;
    }

    public static class ThreadChecker {
        private Thread thread = Thread.currentThread();

        public void checkIsOnValidThread() {
            if (this.thread == null) {
                this.thread = Thread.currentThread();
            }
            if (Thread.currentThread() != this.thread) {
                throw new IllegalStateException("Wrong thread");
            }
        }

        public void detachThread() {
            this.thread = null;
        }
    }

    public static interface BlockingOperation {
        public void run() throws InterruptedException;
    }
}

