/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.MediaCodecInfo;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Environment;
import android.util.Log;
import android.view.Surface;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCapturer;
import org.webrtc.recorder.AudioEncodeConfig;
import org.webrtc.recorder.ScreenRecorder;
import org.webrtc.recorder.VideoEncodeConfig;

@TargetApi(value=21)
public class ScreenCapturerAndroid
implements VideoCapturer,
SurfaceTextureHelper.OnTextureFrameAvailableListener {
    private static final int DISPLAY_FLAGS = 1;
    private static final int VIRTUAL_DISPLAY_DPI = 480;
    private final Intent mediaProjectionPermissionResultData;
    private final MediaProjection.Callback mediaProjectionCallback;
    private int width;
    private int height;
    private VirtualDisplay virtualDisplay;
    private SurfaceTextureHelper surfaceTextureHelper;
    private VideoCapturer.CapturerObserver capturerObserver;
    private long numCapturedFrames = 0L;
    private MediaProjection mediaProjection;
    private boolean isDisposed = false;
    private MediaProjectionManager mediaProjectionManager;
    private ScreenCallback mScreenCallback;
    static boolean save = false;
    FileOutputStream fos = null;
    private ScreenRecorder mRecorder;
    static final String VIDEO_AVC = "video/avc";
    static final String AUDIO_AAC = "audio/mp4a-latm";

    public ScreenCapturerAndroid(Intent mediaProjectionPermissionResultData, MediaProjection.Callback mediaProjectionCallback, ScreenCallback callback) {
        this.mediaProjectionPermissionResultData = mediaProjectionPermissionResultData;
        this.mediaProjectionCallback = mediaProjectionCallback;
        this.mScreenCallback = callback;
    }

    private void checkNotDisposed() {
        if (this.isDisposed) {
            throw new RuntimeException("capturer is disposed.");
        }
    }

    @Override
    public synchronized void initialize(SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, VideoCapturer.CapturerObserver capturerObserver) {
        this.checkNotDisposed();
        if (capturerObserver == null) {
            throw new RuntimeException("capturerObserver not set.");
        }
        this.capturerObserver = capturerObserver;
        if (surfaceTextureHelper == null) {
            throw new RuntimeException("surfaceTextureHelper not set.");
        }
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.mediaProjectionManager = (MediaProjectionManager)applicationContext.getSystemService("media_projection");
    }

    @Override
    public synchronized void startCapture(int width, int height, int ignoredFramerate) {
        this.checkNotDisposed();
        this.width = width;
        this.height = height;
        this.mediaProjection = this.mediaProjectionManager.getMediaProjection(-1, this.mediaProjectionPermissionResultData);
        this.mediaProjection.registerCallback(this.mediaProjectionCallback, this.surfaceTextureHelper.getHandler());
        this.createVirtualDisplay();
        this.capturerObserver.onCapturerStarted(true);
        this.surfaceTextureHelper.startListening(this);
    }

    @Override
    public synchronized void stopCapture() {
        this.checkNotDisposed();
        ThreadUtils.invokeAtFrontUninterruptibly(this.surfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                ScreenCapturerAndroid.this.surfaceTextureHelper.stopListening();
                ScreenCapturerAndroid.this.capturerObserver.onCapturerStopped();
                if (ScreenCapturerAndroid.this.mediaProjection != null) {
                    ScreenCapturerAndroid.this.mediaProjection.unregisterCallback(ScreenCapturerAndroid.this.mediaProjectionCallback);
                    ScreenCapturerAndroid.this.mediaProjection.stop();
                    ScreenCapturerAndroid.this.mediaProjection = null;
                }
            }
        });
    }

    @Override
    public synchronized void dispose() {
        this.isDisposed = true;
    }

    @Override
    public synchronized void changeCaptureFormat(int width, int height, int ignoredFramerate) {
        this.checkNotDisposed();
        this.width = width;
        this.height = height;
        if (this.virtualDisplay == null) {
            return;
        }
        this.virtualDisplay.resize(this.width, this.height, 480);
        ThreadUtils.invokeAtFrontUninterruptibly(this.surfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                ScreenCapturerAndroid.this.virtualDisplay.release();
                ScreenCapturerAndroid.this.createVirtualDisplay();
            }
        });
    }

    private void createVirtualDisplay() {
        this.surfaceTextureHelper.getSurfaceTexture().setDefaultBufferSize(this.width, this.height);
        this.virtualDisplay = this.mediaProjection.createVirtualDisplay("WebRTC_ScreenCapture", this.width, this.height, 480, 1, new Surface(this.surfaceTextureHelper.getSurfaceTexture()), null, null);
    }

    @Override
    public void onTextureFrameAvailable(int oesTextureId, float[] transformMatrix, long timestampNs) {
        ++this.numCapturedFrames;
        this.capturerObserver.onTextureFrameCaptured(this.width, this.height, oesTextureId, transformMatrix, 0, timestampNs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(byte[] buffer, int offset, int length, String path, boolean append) {
        try {
            if (null == this.fos) {
                this.fos = new FileOutputStream(path, append);
            }
            this.fos.write(buffer);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (this.fos != null) {
                try {
                    this.fos.flush();
                    this.fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private AudioEncodeConfig createAudioConfig() {
        String codec = "OMX.google.aac.encoder";
        if (codec == null) {
            return null;
        }
        int bitrate = 80000;
        int samplerate = 44100;
        int channelCount = 1;
        int profile = 1;
        return new AudioEncodeConfig(codec, AUDIO_AAC, bitrate, samplerate, channelCount, profile);
    }

    private void startCapturing() {
        VideoEncodeConfig video = this.createVideoConfig();
        AudioEncodeConfig audio = this.createAudioConfig();
        if (video == null) {
            return;
        }
        File dir = ScreenCapturerAndroid.getSavingDir();
        if (!dir.exists() && !dir.mkdirs()) {
            this.cancelRecorder();
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.US);
        File file = new File(dir, "ardesk-" + format.format(new Date()) + "-" + this.width + "x" + this.height + ".mp4");
        Log.d((String)"@@", (String)("Create recorder with :" + video + " \n " + audio + "\n " + file));
        this.mRecorder = this.newRecorder(video, audio, file);
        this.startRecorder();
    }

    private ScreenRecorder newRecorder(VideoEncodeConfig video, AudioEncodeConfig audio, File output) {
        ScreenRecorder r = new ScreenRecorder(video, audio, this.virtualDisplay, output.getAbsolutePath());
        r.setCallback(new ScreenRecorder.Callback(){
            long startTime = 0L;

            @Override
            public void onStop(Throwable error) {
                if (error != null) {
                    error.printStackTrace();
                }
            }

            @Override
            public void onStart() {
            }

            @Override
            public void onRecording(long presentationTimeUs) {
                if (this.startTime <= 0L) {
                    this.startTime = presentationTimeUs;
                }
            }
        });
        return r;
    }

    private void startRecorder() {
        if (this.mRecorder == null) {
            return;
        }
        this.mRecorder.start();
    }

    private void stopRecorder() {
        if (this.mRecorder != null) {
            this.mRecorder.quit();
        }
        this.mRecorder = null;
    }

    private void cancelRecorder() {
        if (this.mRecorder == null) {
            return;
        }
        this.stopRecorder();
    }

    private VideoEncodeConfig createVideoConfig() {
        String codec = "OMX.qcom.video.encoder.avc";
        if ("OMX.qcom.video.encoder.avc" == null) {
            return null;
        }
        int framerate = 25;
        int iframe = 1;
        int bitrate = 2048000;
        MediaCodecInfo.CodecProfileLevel profileLevel = null;
        return new VideoEncodeConfig(this.width, this.height, bitrate, framerate, iframe, "OMX.qcom.video.encoder.avc", VIDEO_AVC, profileLevel);
    }

    private static File getSavingDir() {
        return new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MOVIES), "Screenshots");
    }

    @Override
    public boolean isScreencast() {
        return true;
    }

    @Override
    public boolean useBackCamera() {
        return true;
    }

    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats() {
        return new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
    }

    public long getNumCapturedFrames() {
        return this.numCapturedFrames;
    }

    public static interface ScreenCallback {
        public void ScreenData(byte[] var1, int var2, int var3);
    }
}

